/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusManager;
import xyz.pixelatedw.mineminenomi.api.events.LivingHealByEvent;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class HealComponent
extends AbilityComponent<IAbility> {
    private static final UUID HEAL_BONUS_MANAGER_UUID = UUID.fromString("c778872e-258a-4672-8cd6-0f930ad9adba");
    private final BonusManager bonusManager = new BonusManager(HEAL_BONUS_MANAGER_UUID);

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(float heal) {
        return HealComponent.getTooltip(heal, heal);
    }

    public static AbilityDescriptionLine.IDescriptionLine getTooltip(float min, float max) {
        return (e, a) -> {
            AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_HEAL, min, max);
            a.getComponent(ModAbilityKeys.HEAL).ifPresent(comp -> {
                float maxBonus;
                float minBonus = comp.getBonusManager().applyBonus(min) - min;
                float diffBonus = minBonus + (maxBonus = comp.getBonusManager().applyBonus(max) - max);
                AbilityStat.AbilityStatType bonusType = diffBonus > 0.0f ? AbilityStat.AbilityStatType.BUFF : (diffBonus < 0.0f ? AbilityStat.AbilityStatType.DEBUFF : AbilityStat.AbilityStatType.NEUTRAL);
                statBuilder.withBonus(minBonus, maxBonus, bonusType);
            });
            return statBuilder.build().getStatDescription();
        };
    }

    public HealComponent(IAbility ability) {
        super(ModAbilityKeys.HEAL, ability);
        this.addBonusManager(this.bonusManager);
    }

    public boolean healTarget(LivingEntity healer, LivingEntity target, float baseHeal) {
        this.ensureIsRegistered();
        float finalHeal = this.bonusManager.applyBonus(baseHeal);
        LivingHealByEvent event = new LivingHealByEvent(healer, target, finalHeal);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            target.func_70691_i(finalHeal);
            return true;
        }
        return false;
    }

    public BonusManager getBonusManager() {
        return this.bonusManager;
    }
}

