/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class PauseTickComponent
extends AbilityComponent<IAbility> {
    private final PriorityEventPool<IPauseEvent> pauseEvents = new PriorityEventPool();
    private final PriorityEventPool<IResumeEvent> resumeEvents = new PriorityEventPool();
    private boolean isPaused;

    public PauseTickComponent(IAbility ability) {
        super(ModAbilityKeys.PAUSE_TICK, ability);
    }

    public void setPause(LivingEntity entity, boolean isPaused) {
        this.ensureIsRegistered();
        this.isPaused = isPaused;
        if (this.isPaused) {
            this.pauseEvents.dispatch(event -> event.pause(entity, (IAbility)this.getAbility()));
        } else {
            this.resumeEvents.dispatch(event -> event.resume(entity, (IAbility)this.getAbility()));
        }
    }

    public boolean isPaused() {
        return this.isPaused;
    }

    public PauseTickComponent addPauseEvent(int priority, IPauseEvent event) {
        this.pauseEvents.addEvent(priority, event);
        return this;
    }

    public PauseTickComponent addResumeEvent(int priority, IResumeEvent event) {
        this.resumeEvents.addEvent(priority, event);
        return this;
    }

    @Override
    @Nullable
    public CompoundNBT save() {
        CompoundNBT nbt = super.save();
        nbt.func_74757_a("isPaused", this.isPaused);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.isPaused = nbt.func_74767_n("isPaused");
    }

    @FunctionalInterface
    public static interface IResumeEvent {
        public void resume(LivingEntity var1, IAbility var2);
    }

    @FunctionalInterface
    public static interface IPauseEvent {
        public void pause(LivingEntity var1, IAbility var2);
    }
}

