/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityDescriptionLine;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityStat;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusManager;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class ProjectileComponent
extends AbilityComponent<IAbility> {
    private static final UUID PROJ_DAMAGE_BONUS_MANAGER_UUID = UUID.fromString("2ab0d674-f9ca-4c11-976a-c8a105332318");
    private static final UUID PROJ_INACCURACY_BONUS_MANAGER_UUID = UUID.fromString("2ad65e4e-5edf-4c95-a826-d1f7bba33c23");
    private static final StringTextComponent PERCENTAGE_SIGN = new StringTextComponent("%");
    public static final Predicate<Entity> TARGET_CHECK = target -> target != null && target.func_70089_S() && target instanceof LivingEntity;
    private final IProjectileFactory factory;
    private AbilityProjectileEntity cachedProjectile;
    private AbilityProjectileEntity projectileShot;
    private boolean isHitScan;
    private final PriorityEventPool<IAfterShootEvent> afterShootEvents = new PriorityEventPool();
    private final BonusManager damageBonusManager = new BonusManager(PROJ_DAMAGE_BONUS_MANAGER_UUID);
    private final BonusManager inaccuracyBonusManager = new BonusManager(PROJ_INACCURACY_BONUS_MANAGER_UUID);

    public static AbilityDescriptionLine.IDescriptionLine[] getProjectileTooltips() {
        AbilityDescriptionLine.IDescriptionLine[] list = new AbilityDescriptionLine.IDescriptionLine[]{(entity, ability) -> new StringTextComponent("\u00a7a" + ModI18n.ABILITY_DESCRIPTION_STAT_NAME_PROJECTILE.getString() + "\u00a7r"), ProjectileComponent.getDamageFromProjectileTooltip(), ProjectileComponent.getPiercingFromProjectileTooltip()};
        return list;
    }

    private static AbilityDescriptionLine.IDescriptionLine getDamageFromProjectileTooltip() {
        return (entity, ability) -> {
            AbilityProjectileEntity proj = ability.getComponent(ModAbilityKeys.PROJECTILE).map(comp -> comp.getCachedProjectile(entity)).orElse(null);
            if (proj != null && proj.getDamage() > 0.0f) {
                float bonus = ability.getComponent(ModAbilityKeys.PROJECTILE).map(ProjectileComponent::getDamageBonusManager).map(manager -> Float.valueOf(manager.applyBonus(proj.getDamage()) - proj.getDamage())).orElse(Float.valueOf(0.0f)).floatValue();
                AbilityStat.AbilityStatType bonusType = bonus > 0.0f ? AbilityStat.AbilityStatType.BUFF : (bonus < 0.0f ? AbilityStat.AbilityStatType.DEBUFF : AbilityStat.AbilityStatType.NEUTRAL);
                AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_DAMAGE, proj.getDamage()).withBonus(bonus, bonusType);
                return statBuilder.build().getStatDescription(2);
            }
            return null;
        };
    }

    private static AbilityDescriptionLine.IDescriptionLine getPiercingFromProjectileTooltip() {
        return (e, a) -> {
            AbilityProjectileEntity proj = a.getComponent(ModAbilityKeys.PROJECTILE).map(comp -> comp.cachedProjectile).orElse(null);
            if (proj != null && proj.getArmorPiercing() > 0.0f) {
                AbilityStat.Builder statBuilder = new AbilityStat.Builder((ITextComponent)ModI18n.ABILITY_DESCRIPTION_STAT_NAME_PIERCING, proj.getArmorPiercing() * 100.0f).withUnit((ITextComponent)PERCENTAGE_SIGN);
                return statBuilder.build().getStatDescription(2);
            }
            return null;
        };
    }

    public <P extends AbilityProjectileEntity> ProjectileComponent(IAbility ability, IProjectileFactory<P> projectileFactory) {
        super(ModAbilityKeys.PROJECTILE, ability);
        this.factory = projectileFactory;
        this.addBonusManager(this.damageBonusManager);
        this.addBonusManager(this.inaccuracyBonusManager);
    }

    public ProjectileComponent addAfterShootEvent(int priority, IAfterShootEvent event) {
        this.afterShootEvents.addEvent(priority, event);
        return this;
    }

    public void shoot(LivingEntity entity) {
        this.shoot(entity, 2.0f, 1.0f);
    }

    public void shoot(LivingEntity entity, float speed, float inaccuracy) {
        Object proj = this.getNewProjectile(entity);
        this.shoot((AbilityProjectileEntity)((Object)proj), entity, speed, inaccuracy);
    }

    public void shootWithSpread(LivingEntity entity, float speed, float inaccuracy, int spread) {
        Object proj = this.getNewProjectile(entity);
        this.shootWithSpread((AbilityProjectileEntity)((Object)proj), entity, speed, inaccuracy, spread);
    }

    public void shootWithSpread(AbilityProjectileEntity projectile, LivingEntity entity, float speed, float inaccuracy, int spread) {
        double px = entity.func_226277_ct_() + WyHelper.randomWithRange(-spread, spread) + WyHelper.randomDouble();
        double py = entity.func_226280_cw_() + WyHelper.randomWithRange(0, spread) + WyHelper.randomDouble();
        double pz = entity.func_226281_cx_() + WyHelper.randomWithRange(-spread, spread) + WyHelper.randomDouble();
        projectile.func_70012_b(px, py, pz, 0.0f, 0.0f);
        this.shoot(projectile, entity, speed, inaccuracy);
    }

    public void shoot(AbilityProjectileEntity projectile, LivingEntity entity, float speed, float inaccuracy) {
        this.ensureIsRegistered();
        if (this.isHitScan) {
            float distance = (float)projectile.getMaxLife() * speed;
            EntityRayTraceResult entityResult = WyHelper.rayTraceEntities((Entity)entity, distance, projectile.func_213311_cf(), TARGET_CHECK);
            if (entityResult.func_216348_a() != null && entityResult.func_216348_a() instanceof LivingEntity) {
                projectile.func_70107_b(entityResult.func_216348_a().func_213303_ch().field_72450_a, entityResult.func_216348_a().func_213303_ch().field_72448_b, entityResult.func_216348_a().func_213303_ch().field_72449_c);
                projectile.onModHit((RayTraceResult)entityResult);
            } else if (entityResult.func_216348_a() == null) {
                BlockRayTraceResult blockResult = WyHelper.rayTraceBlocks((Entity)entity, distance);
                projectile.func_70107_b(blockResult.func_216347_e().field_72450_a, entityResult.func_216347_e().field_72448_b, entityResult.func_216347_e().field_72449_c);
                projectile.onModHit((RayTraceResult)blockResult);
            }
        } else {
            inaccuracy = ItemsHelper.getSniperInaccuracy(inaccuracy, entity);
            inaccuracy = this.inaccuracyBonusManager.applyBonus(inaccuracy);
            this.projectileShot = projectile;
            entity.field_70170_p.func_217376_c((Entity)projectile);
            projectile.func_234612_a_((Entity)entity, entity.field_70125_A, entity.field_70177_z, 0.0f, speed, inaccuracy);
        }
        this.afterShootEvents.dispatch(event -> event.triggerAfterEvent(entity));
    }

    @Nullable
    public AbilityProjectileEntity getShotProjectile() {
        return this.projectileShot;
    }

    public boolean hasProjectileAlive() {
        return this.projectileShot != null && this.projectileShot.func_70089_S();
    }

    public <P extends AbilityProjectileEntity> P getNewProjectile(LivingEntity entity) {
        Object proj = this.factory.createProjectile(entity);
        ((AbilityProjectileEntity)((Object)proj)).setDamage(this.damageBonusManager.applyBonus(((AbilityProjectileEntity)((Object)proj)).getDamage()));
        return proj;
    }

    public BonusManager getDamageBonusManager() {
        return this.damageBonusManager;
    }

    public BonusManager getInaccuracyBonusManager() {
        return this.inaccuracyBonusManager;
    }

    public AbilityProjectileEntity getCachedProjectile(LivingEntity entity) {
        if (this.cachedProjectile == null) {
            this.cachedProjectile = this.factory.createProjectile(entity);
        }
        return this.cachedProjectile;
    }

    public void setHitScan(boolean flag) {
        this.isHitScan = flag;
    }

    @FunctionalInterface
    public static interface IAfterShootEvent {
        public void triggerAfterEvent(LivingEntity var1);
    }

    @FunctionalInterface
    public static interface IProjectileFactory<P extends AbilityProjectileEntity> {
        public P createProjectile(LivingEntity var1);
    }
}

