/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SSetOverlayLayersPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class SkinOverlayComponent
extends AbilityComponent<IAbility> {
    private Map<Integer, AbilityOverlay> overlays = new HashMap<Integer, AbilityOverlay>();
    private Set<Integer> shownOverlays = new HashSet<Integer>();

    public SkinOverlayComponent(IAbility ability, AbilityOverlay mainOverlay, AbilityOverlay ... abilityOverlays) {
        super(ModAbilityKeys.SKIN_OVERLAY, ability);
        this.addOverlay(mainOverlay);
        for (AbilityOverlay overlay : abilityOverlays) {
            this.addOverlay(overlay);
        }
    }

    public void addOverlay(AbilityOverlay overlay) {
        this.overlays.put(overlay.hashCode(), overlay);
    }

    public void removeOverlay(AbilityOverlay overlay) {
        this.overlays.remove(overlay.hashCode());
    }

    public Optional<AbilityOverlay> getShownOverlay(AbilityOverlay.OverlayPart ... parts) {
        if (parts.length <= 0) {
            return Optional.empty();
        }
        ArrayList overlays = new ArrayList();
        Collections.addAll(overlays, parts);
        return this.shownOverlays.stream().map(hash -> this.overlays.get(hash)).filter(Objects::nonNull).filter(overlay -> overlays.contains((Object)overlay.getOverlayPart())).findFirst();
    }

    public boolean hasAnyShownOverlay(AbilityOverlay.OverlayPart ... parts) {
        if (parts.length <= 0) {
            return false;
        }
        ArrayList overlays = new ArrayList();
        Collections.addAll(overlays, parts);
        return this.shownOverlays.stream().map(hash -> this.overlays.get(hash)).filter(Objects::nonNull).filter(overlay -> overlays.contains((Object)overlay.getOverlayPart())).count() > 0L;
    }

    public void showAll(LivingEntity entity) {
        this.ensureIsRegistered();
        this.shownOverlays.addAll(this.overlays.keySet());
        this.updateShownOverlays(entity);
    }

    public void show(LivingEntity entity, AbilityOverlay overlay) {
        this.ensureIsRegistered();
        if (!this.overlays.containsKey(overlay.hashCode())) {
            this.addOverlay(overlay);
        }
        this.shownOverlays.add(overlay.hashCode());
        this.updateShownOverlays(entity);
    }

    public void hideAll(LivingEntity entity) {
        this.shownOverlays.clear();
        this.updateShownOverlays(entity);
    }

    public void hide(LivingEntity entity, AbilityOverlay overlay) {
        this.shownOverlays.remove(overlay.hashCode());
        this.updateShownOverlays(entity);
    }

    public void setShownOverlays(Set<Integer> overlays) {
        this.shownOverlays = overlays;
    }

    private void updateShownOverlays(LivingEntity entity) {
        if (!entity.field_70170_p.field_72995_K) {
            WyNetwork.sendToAllTrackingAndSelf(new SSetOverlayLayersPacket(entity, (IAbility)this.getAbility(), this.shownOverlays), (Entity)entity);
        }
    }
}

