/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.abilities.components;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AbilityComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.api.math.EasingFunctionHelper;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.server.ability.components.SChangeAbilitySwitchModePacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class SwitchModeComponent
extends AbilityComponent<IAbility> {
    private final PriorityEventPool<ISwitchStateEvent> switchEvents = new PriorityEventPool();
    private boolean switchState = true;
    private boolean playReadyAnim = false;
    private float readyAnim = 0.0f;

    public SwitchModeComponent(IAbility ability) {
        super(ModAbilityKeys.SWITCH_MODE, ability);
    }

    public SwitchModeComponent addSwitchStateEvent(ISwitchStateEvent event) {
        this.switchEvents.addEvent(event);
        return this;
    }

    public SwitchModeComponent addSwitchStateEvent(int priority, ISwitchStateEvent event) {
        this.switchEvents.addEvent(priority, event);
        return this;
    }

    @Override
    public void postInit(IAbility ability) {
        ability.getComponent(ModAbilityKeys.SLOT_DECORATION).ifPresent(component -> component.addPostRenderEvent(100, (entity, minecraft, matrix, x, y, partialTicks) -> {
            if (this.playReadyAnim && this.readyAnim <= 0.0f) {
                this.readyAnim = 30.0f;
            } else if (this.playReadyAnim && this.readyAnim > 0.0f) {
                this.readyAnim = (float)((double)this.readyAnim - 1.75 * (double)minecraft.func_193989_ak());
                if (this.readyAnim <= 0.0f) {
                    this.playReadyAnim = false;
                } else if (this.readyAnim > 0.0f) {
                    float anim = this.readyAnim * 0.03f;
                    anim = Math.max(0.0f, anim);
                    float scale = 1.8f * EasingFunctionHelper.easeOutSine(Float.valueOf(anim));
                    float alpha = 1.0f * EasingFunctionHelper.easeOutSine(Float.valueOf(anim));
                    scale = MathHelper.func_76131_a((float)scale, (float)1.0f, (float)scale);
                    matrix.func_227860_a_();
                    matrix.func_227861_a_((double)x, (double)y, 1.0);
                    matrix.func_227861_a_(12.0, 12.0, 0.0);
                    matrix.func_227862_a_(scale, scale, 1.0f);
                    matrix.func_227861_a_(-12.0, -12.0, 0.0);
                    minecraft.func_110434_K().func_110577_a(ModResources.WIDGETS);
                    RendererHelper.drawTexturedModalRect(matrix, 0.0f, 0.0f, 0.0f, 0.0f, 23.0f, 23.0f, -1.0f, 1.0f, 0.95f, 0.0f, alpha);
                    matrix.func_227865_b_();
                }
            }
        }));
    }

    public void switchState(LivingEntity entity) {
        this.setSwitchState(entity, !this.switchState);
    }

    public void setSwitchState(LivingEntity entity, boolean mode) {
        this.ensureIsRegistered();
        this.switchState = mode;
        this.playReadyAnim = true;
        this.switchEvents.dispatch(event -> event.switchMode(entity, (IAbility)this.getAbility()));
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            WyNetwork.sendToAllTrackingAndSelf(new SChangeAbilitySwitchModePacket((LivingEntity)player, (IAbility)this.getAbility(), this.getSwitchState()), (Entity)player);
        }
    }

    public boolean getSwitchState() {
        return this.switchState;
    }

    @Override
    @Nullable
    public CompoundNBT save() {
        CompoundNBT nbt = super.save();
        nbt.func_74757_a("currentState", this.switchState);
        return nbt;
    }

    @Override
    public void load(CompoundNBT nbt) {
        super.load(nbt);
        this.switchState = nbt.func_74767_n("currentState");
    }

    @FunctionalInterface
    public static interface ISwitchStateEvent {
        public void switchMode(LivingEntity var1, IAbility var2);
    }
}

