/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.animations;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import xyz.pixelatedw.mineminenomi.api.abilities.components.AnimationComponent;
import xyz.pixelatedw.mineminenomi.api.animations.AnimationId;
import xyz.pixelatedw.mineminenomi.api.animations.IAnimation;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;

public abstract class Animation<E extends LivingEntity, M extends EntityModel>
implements IAnimation<E, M> {
    private long startTime;
    private long runTime;
    private int animDuration;
    private AnimationId<? extends Animation<E, M>> animId;
    private AnimationComponent.State state = AnimationComponent.State.STOP;
    private IAnimationSetup<E> animationSetup;
    private IAnimationAngles<E, M> animationAngles;
    private IAnimationHeldItem<E> animationHeldItem;
    @Nullable
    private M model;

    public <A extends Animation<E, M>> Animation(AnimationId<A> animId) {
        this.animId = animId;
    }

    public void setAnimationSetup(IAnimationSetup<E> func) {
        this.animationSetup = func;
    }

    public void setAnimationAngles(IAnimationAngles<E, M> func) {
        this.animationAngles = func;
    }

    public void setAnimationHeldItem(IAnimationHeldItem<E> func) {
        this.animationHeldItem = func;
    }

    @Override
    public void setupAnimation(E entity, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, float rotationYaw, float partialTicks) {
        if (this.animationSetup != null) {
            try {
                this.animationSetup.setupAnimation(entity, matrixStack, buffer, packedLight, rotationYaw, partialTicks);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setAnimationAngles(E entity, M entityModel, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.model = entityModel;
        if (this.animationAngles != null) {
            try {
                this.animationAngles.setAnimationAngles(entity, entityModel, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
                RendererHelper.hasModelChanged = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setupHeldItem(E entity, ItemStack stack, ItemCameraTransforms.TransformType transformType, HandSide handSide, MatrixStack matrixStack, IRenderTypeBuffer renderBuffer, int packedLight) {
        if (this.animationHeldItem != null) {
            try {
                this.animationHeldItem.setupHeldItem(entity, stack, transformType, handSide, matrixStack, renderBuffer, packedLight);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void start(LivingEntity entity, int animDuration) {
        if (this.model != null) {
            RendererHelper.resetHumanoidModelToDefaultPivots(this.model);
        }
        this.startTime = entity.field_70173_aa;
        this.runTime = 0L;
        this.animDuration = animDuration;
        this.state = AnimationComponent.State.PLAY;
    }

    public void stop(LivingEntity entity) {
        this.runTime = 0L;
        this.state = AnimationComponent.State.STOP;
        if (this.model != null) {
            RendererHelper.resetHumanoidModelToDefaultPivots(this.model);
        }
    }

    public void tick(LivingEntity entity) {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (this.isPlaying()) {
            this.runTime = (long)entity.field_70173_aa - this.startTime;
            if (this.animDuration != -1 && this.animDuration <= 0) {
                this.stop(entity);
            } else if (this.animDuration != -1) {
                --this.animDuration;
            }
        }
    }

    public long getTime() {
        return this.runTime;
    }

    public int getAnimationDuration() {
        return this.animDuration;
    }

    public AnimationComponent.State getState() {
        return this.state;
    }

    public boolean isPlaying() {
        return this.state == AnimationComponent.State.PLAY;
    }

    public boolean isStopped() {
        return this.state == AnimationComponent.State.STOP;
    }

    public AnimationId<? extends Animation<E, M>> getId() {
        return this.animId;
    }

    @FunctionalInterface
    public static interface IAnimationHeldItem<E extends LivingEntity> {
        public void setupHeldItem(E var1, ItemStack var2, ItemCameraTransforms.TransformType var3, HandSide var4, MatrixStack var5, IRenderTypeBuffer var6, int var7);
    }

    @FunctionalInterface
    public static interface IAnimationAngles<E extends LivingEntity, M extends EntityModel> {
        public void setAnimationAngles(E var1, M var2, float var3, float var4, float var5, float var6, float var7);
    }

    @FunctionalInterface
    public static interface IAnimationSetup<E extends LivingEntity> {
        public void setupAnimation(E var1, MatrixStack var2, IRenderTypeBuffer var3, int var4, float var5, float var6);
    }
}

