/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.challenges;

import com.google.common.collect.HashMultimap;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeDifficulty;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.challenges.arenas.PoneglyphLowspecArena;

public class ChallengeCore<T extends Challenge>
extends ForgeRegistryEntry<ChallengeCore<?>> {
    private String id;
    @Nullable
    private IFormattableTextComponent title;
    private final String unlocalizedTitle;
    private IFormattableTextComponent objective;
    private final String unlocalizedObjective;
    private final String category;
    private int timeLimit;
    private ResourceLocation rewards;
    private ChallengeDifficulty difficulty;
    private int difficultyStars;
    private float rewardsFactor;
    private HashMultimap<ArenaStyle, ArenaEntry> arenas = HashMultimap.create();
    private ITargetShowcase[] targetShowcase;
    private boolean isTargetCacheDirty = false;
    private LivingEntity[] targetsCache = new LivingEntity[4];
    private String[] bannedFactions;
    private final IFactory<T> factory;
    private ICanStart startCheck;
    private IEnemySpawns enemySpawns;
    @Nullable
    private String titleI18nId;
    @Nullable
    private String objectiveI18nId;
    private int order;

    public ChallengeCore(String id, String unlocalizedTitle, String unlocalizedObjective, String category, IFactory<T> factory) {
        this.id = id;
        this.unlocalizedTitle = unlocalizedTitle;
        this.unlocalizedObjective = unlocalizedObjective;
        this.category = category;
        this.factory = factory;
    }

    @Nullable
    public T createChallenge() {
        return this.factory.create(this);
    }

    private void setTargetShowcase(ITargetShowcase ... targets) {
        this.targetShowcase = targets;
        this.isTargetCacheDirty = true;
    }

    private void setRewardFactor(float factor) {
        this.rewardsFactor = factor;
    }

    private void setRewards(ResourceLocation rewards) {
        this.rewards = rewards;
    }

    private void setArenas(HashMultimap<ArenaStyle, ArenaEntry> map) {
        this.arenas = map;
    }

    private void setDifficulty(ChallengeDifficulty difficulty) {
        this.difficulty = difficulty;
    }

    private void setDifficultyStars(int stars) {
        this.difficultyStars = stars;
    }

    private void setTimeLimit(int minutes) {
        this.timeLimit = minutes;
    }

    public void setBannedFactions(String ... factions) {
        this.bannedFactions = factions;
    }

    public void setStartCheck(ICanStart startCheck) {
        this.startCheck = startCheck;
    }

    public void setEnemySpawns(IEnemySpawns spawns) {
        this.enemySpawns = spawns;
    }

    public String getId() {
        return this.id;
    }

    public float getRewardsFactor() {
        return this.rewardsFactor;
    }

    public ResourceLocation getRewards() {
        return this.rewards;
    }

    public IFormattableTextComponent getLocalizedTitle() {
        if (this.title == null) {
            this.title = new TranslationTextComponent(this.getUnlocalizedTitle());
        }
        return this.title;
    }

    public IFormattableTextComponent getLocalizedObjective() {
        if (this.objective == null) {
            this.objective = new TranslationTextComponent(this.getUnlocalizedObjective());
        }
        return this.objective;
    }

    private String getTitleLocalizationId() {
        ResourceLocation key;
        if (this.titleI18nId == null && (key = ModRegistries.CHALLENGES.getKey((IForgeRegistryEntry)this)) != null) {
            this.titleI18nId = Util.func_200697_a((String)"challenge", (ResourceLocation)key);
        }
        return this.titleI18nId;
    }

    private String getObjectiveLocalizationId() {
        ResourceLocation key;
        if (this.titleI18nId == null && (key = ModRegistries.CHALLENGES.getKey((IForgeRegistryEntry)this)) != null) {
            this.objectiveI18nId = Util.func_200697_a((String)"challenge", (ResourceLocation)key) + ".objective";
        }
        return this.objectiveI18nId;
    }

    public LivingEntity[] getTargetShowcase(World world) {
        if (this.isTargetCacheDirty && this.targetShowcase != null) {
            int i = 0;
            for (ITargetShowcase showcase : this.targetShowcase) {
                this.targetsCache[i] = showcase.createShowcase(world);
                ++i;
            }
            this.isTargetCacheDirty = false;
        }
        return this.targetsCache;
    }

    @Nullable
    public ArenaEntry getArenaFromStyle(ArenaStyle style, String clzId) {
        for (ArenaEntry entry : this.arenas.get((Object)style)) {
            if (!entry.arena.getClass().getName().equals(clzId)) continue;
            return entry;
        }
        return null;
    }

    @Nullable
    public ArenaEntry pickRandomArena() {
        ArenaStyle configStyle = ArenaStyle.SIMPLE;
        Iterator iterator = this.arenas.get((Object)configStyle).iterator();
        if (iterator.hasNext()) {
            ArenaEntry entry = (ArenaEntry)iterator.next();
            return entry;
        }
        return null;
    }

    private void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public ChallengeDifficulty getDifficulty() {
        return this.difficulty;
    }

    public int getDifficultyStars() {
        return this.difficultyStars;
    }

    public String getUnlocalizedTitle() {
        return this.unlocalizedTitle;
    }

    public String getUnlocalizedObjective() {
        return this.unlocalizedObjective;
    }

    public IFactory<? extends T> getFactory() {
        return this.factory;
    }

    public ITextComponent getObjective() {
        return this.objective;
    }

    public String getCategory() {
        return this.category;
    }

    public int getTimeLimit() {
        return this.timeLimit;
    }

    public String[] getBannedFactions() {
        return this.bannedFactions;
    }

    public ICanStart getStartCheck() {
        return this.startCheck;
    }

    public IEnemySpawns getEnemySpawns() {
        return this.enemySpawns;
    }

    @FunctionalInterface
    public static interface ITargetShowcase {
        public LivingEntity createShowcase(World var1);
    }

    @FunctionalInterface
    public static interface IEnemySpawns {
        public Set<ChallengeArena.EnemySpawn> getEnemySpawns(InProgressChallenge var1, ChallengeArena.SpawnPosition[] var2);
    }

    @FunctionalInterface
    public static interface IEnemyPosition {
        public ChallengeArena.SpawnPosition[] getEnemySpawnPos(InProgressChallenge var1);
    }

    @FunctionalInterface
    public static interface IChallengerPosition {
        public ChallengeArena.SpawnPosition getChallengerSpawnPos(int var1, InProgressChallenge var2);
    }

    @FunctionalInterface
    public static interface ICanStart {
        public boolean canStart(PlayerEntity var1);
    }

    @FunctionalInterface
    public static interface IFactory<A extends Challenge> {
        public A create(ChallengeCore<A> var1);
    }

    public static class ArenaEntry {
        public final ChallengeArena arena;
        public final IChallengerPosition challengerPosition;
        public final IEnemyPosition enemyPosition;

        public ArenaEntry(ChallengeArena arena, IChallengerPosition challengerPosition, IEnemyPosition enemyPosition) {
            this.arena = arena;
            this.challengerPosition = challengerPosition;
            this.enemyPosition = enemyPosition;
        }
    }

    public static class Builder<T extends Challenge> {
        private String id;
        private String unlocalizedTitle;
        private String unlocalizedObjective;
        private String category = "No Category";
        private int timeLimit = 10;
        private ResourceLocation rewards;
        private ChallengeDifficulty difficulty = ChallengeDifficulty.STANDARD;
        private int difficultyStars = 1;
        private float rewardsFactor = 1.0f;
        private HashMultimap<ArenaStyle, ArenaEntry> arenas = HashMultimap.create();
        private ITargetShowcase[] targetShowcase;
        private String[] bannedFactions;
        private IFactory<T> factory;
        private ICanStart startCheck = entity -> true;
        private IEnemySpawns enemySpawns;
        private int order = Integer.MAX_VALUE;

        public Builder(String id, String title, String objective, String category, IFactory<T> factory) {
            this.id = id;
            this.unlocalizedTitle = title;
            this.unlocalizedObjective = objective;
            this.category = category;
            this.factory = factory;
        }

        public Builder<T> setOrder(int order) {
            this.order = order;
            return this;
        }

        public Builder<T> setTimeLimit(int minutes) {
            this.timeLimit = minutes;
            return this;
        }

        public Builder<T> setRewardsFactor(float factor) {
            this.rewardsFactor = factor;
            return this;
        }

        public Builder<T> setRewards(ResourceLocation rewards) {
            this.rewards = rewards;
            return this;
        }

        public Builder<T> setBannedFactions(String ... factions) {
            this.bannedFactions = factions;
            return this;
        }

        public Builder<T> setStartCheck(ICanStart startCheck) {
            this.startCheck = startCheck;
            return this;
        }

        public Builder<T> setDifficulty(ChallengeDifficulty difficulty) {
            this.difficulty = difficulty;
            return this;
        }

        public Builder<T> setDifficultyStars(int stars) {
            this.difficultyStars = Math.min(stars, 10);
            return this;
        }

        public Builder<T> addArena(ArenaStyle style, ChallengeArena arena, IChallengerPosition challengerPosition, IEnemyPosition enemyPosition) {
            ArenaEntry arenaEntry = new ArenaEntry(arena, challengerPosition, enemyPosition);
            this.arenas.put((Object)style, (Object)arenaEntry);
            return this;
        }

        public Builder<T> setEnemySpawns(IEnemySpawns spawns) {
            this.enemySpawns = spawns;
            return this;
        }

        public Builder<T> setTargetShowcase(Supplier<EntityType<?>> ... targets) {
            this.targetShowcase = new ITargetShowcase[targets.length];
            int i = 0;
            while (i < targets.length) {
                int j = i++;
                this.targetShowcase[j] = world -> (LivingEntity)((EntityType)targets[j].get()).func_200721_a(world);
            }
            return this;
        }

        public Builder<T> setTargetShowcase(ITargetShowcase ... targets) {
            this.targetShowcase = targets;
            return this;
        }

        public ChallengeCore build() {
            this.addArena(ArenaStyle.LOWSPEC, PoneglyphLowspecArena.INSTANCE, PoneglyphLowspecArena::getChallengerSpawnPos, PoneglyphLowspecArena::getEnemySpawnPos);
            ChallengeCore<T> challenge = new ChallengeCore<T>(this.id, this.unlocalizedTitle, this.unlocalizedObjective, this.category, this.factory);
            ((ChallengeCore)challenge).setTimeLimit(this.timeLimit);
            ((ChallengeCore)challenge).setRewardFactor(this.rewardsFactor);
            ((ChallengeCore)challenge).setRewards(this.rewards);
            challenge.setBannedFactions(this.bannedFactions);
            challenge.setStartCheck(this.startCheck);
            ((ChallengeCore)challenge).setDifficulty(this.difficulty);
            int difficultyStars = this.difficultyStars;
            if (this.difficulty == ChallengeDifficulty.HARD) {
                difficultyStars += 10;
            } else if (this.difficulty == ChallengeDifficulty.ULTIMATE) {
                difficultyStars += 20;
            }
            ((ChallengeCore)challenge).setDifficultyStars(difficultyStars);
            ((ChallengeCore)challenge).setArenas((HashMultimap<ArenaStyle, ArenaEntry>)this.arenas);
            ((ChallengeCore)challenge).setTargetShowcase(this.targetShowcase);
            challenge.setEnemySpawns(this.enemySpawns);
            if (this.difficulty == ChallengeDifficulty.HARD) {
                ++this.order;
            } else if (this.difficulty == ChallengeDifficulty.ULTIMATE) {
                this.order += 2;
            }
            ((ChallengeCore)challenge).setOrder(this.order);
            return challenge;
        }
    }
}

