/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.challenges;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.STitlePacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketType;
import net.minecraftforge.common.world.ForgeChunkManager;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import xyz.pixelatedw.mineminenomi.ModMain;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCache;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeDifficulty;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.api.util.TPSDelta;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.world.ChallengesWorldData;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class InProgressChallenge {
    private static final int COUNTDOWN_SECONDS = 10;
    private static final int COUNTDOWN_TICKS = 200;
    private static final Marker MARKER = MarkerManager.getMarker((String)"IP_CHALLENGE");
    private static final BlockProtectionRule REPAIR_RULE = new BlockProtectionRule.Builder(CoreBlockProtectionRule.INSTANCE_WITHOUT_RESTRICTION, LiquidBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE).addApprovedBlocks(Blocks.field_150357_h, Blocks.field_180401_cv).addBannedBlocks(Blocks.field_150350_a).build();
    private final UUID id;
    private float inProgressTick;
    private Interval readyInterval = (Interval)Interval.startAtMax(10).trackTPS();
    private Interval endWaitInterval = (Interval)Interval.startAtMax(10).trackTPS();
    private Interval.Mutable tickInterval = (Interval.Mutable)new Interval.Mutable(5).trackTPS();
    private Phase phase = Phase.BUILD;
    private Result result = Result.TBD;
    private ServerPlayerEntity owner;
    private BlockPos returnPosition;
    private RegistryKey<World> returnDimension;
    private ServerWorld shard;
    private Challenge challenge;
    private ChallengeCore.ArenaEntry arenaEntry;
    private BlockPos pos;
    private List<LivingEntity> group;
    private HashMap<UUID, ChallengeCache> groupCache = new HashMap();
    private Set<LivingEntity> enemies = new HashSet<LivingEntity>();
    private int tickLimit;
    private long startTick;
    private long finishTick;
    private ChallengeCore<?> core;
    private boolean isFree = false;
    private boolean isCompleted = false;
    private Set<BlockPos> blocksPlaced;
    private IChallengesData ownerProps;
    private Random random;
    private float deltaTime = 0.0f;
    private Set<BlockPos> trackedManuallyPlacedBlocks = new HashSet<BlockPos>();

    public InProgressChallenge(UUID id, ServerPlayerEntity owner, ServerWorld shard, List<LivingEntity> group, Challenge challenge, boolean isFree) {
        this.id = id;
        this.owner = owner;
        this.returnPosition = this.owner.func_233580_cy_();
        this.returnDimension = this.owner.func_71121_q().func_234923_W_();
        this.challenge = challenge;
        this.core = challenge.getCore();
        this.shard = shard;
        this.arenaEntry = this.core.pickRandomArena();
        this.pos = new BlockPos(0, 90, 0);
        this.group = new ArrayList<LivingEntity>();
        this.group.add((LivingEntity)owner);
        this.group.addAll(group);
        this.isFree = isFree;
        this.ownerProps = ChallengesDataCapability.get((PlayerEntity)this.owner);
        this.random = new Random();
        this.tickLimit = challenge.getCore().getTimeLimit() * 60 * 20;
        this.inProgressTick = 0.0f;
        this.tickInterval.restartIntervalToMax();
        this.readyInterval.restartIntervalToMax();
        this.endWaitInterval.restartIntervalToMax();
    }

    public void tick() {
        this.deltaTime = TPSDelta.INSTANCE.getDeltaTime();
        this.inProgressTick += this.deltaTime;
        if ((this.phase == Phase.RUN || this.phase == Phase.END) && this.group.isEmpty()) {
            this.wipeOldEntities(false);
            this.phase = Phase.POSTEND;
            return;
        }
        if (!this.tickInterval.canTick()) {
            return;
        }
        if (this.phase.equals((Object)Phase.END)) {
            this.executeEndPhase();
        } else if (this.phase.equals((Object)Phase.RUN)) {
            this.executeRunPhase();
        } else if (this.phase.equals((Object)Phase.BUILD)) {
            this.executeBuildPhase();
        } else if (this.phase.equals((Object)Phase.SPAWN)) {
            this.executeSpawnPhase();
        } else if (this.phase.equals((Object)Phase.READY)) {
            this.executeReadyPhase();
        }
    }

    private void executeBuildPhase() {
        this.sendGroupTitle((ITextComponent)ModI18n.CHALLENGE_MESSAGE_START_TITLE, (ITextComponent)ModI18n.CHALLENGE_MESSAGE_START_SUBTITLE, 5, 90, 10);
        ForgeChunkManager.forceChunk((ServerWorld)this.shard, (String)"mineminenomi", (BlockPos)this.pos, (int)0, (int)0, (boolean)true, (boolean)false);
        if (this.ownerProps.isArenaDirty()) {
            ChallengeCore.ArenaEntry entry;
            long cleanStart = System.nanoTime();
            ChallengeArena previousArena = this.arenaEntry.arena;
            MutableBoundingBox previousArenBB = MutableBoundingBox.func_175899_a((int)-100, (int)-100, (int)-100, (int)100, (int)100, (int)100);
            if (this.ownerProps.getPreviousChallenge() != null && (entry = this.ownerProps.getPreviousChallenge().getArenaFromStyle(this.ownerProps.getPreviousArenaStyle(), this.ownerProps.getPreviousArenaClass())) != null) {
                previousArena = entry.arena;
            }
            if (previousArena != null) {
                previousArenBB = previousArena.getArenaLimits();
            }
            if (previousArena == null) {
                previousArena = this.arenaEntry.arena;
            }
            int x0 = this.getArenaPos().func_177958_n() + previousArenBB.field_78897_a * 2;
            int y0 = this.getArenaPos().func_177956_o() + previousArenBB.field_78895_b * 2;
            int z0 = this.getArenaPos().func_177952_p() + previousArenBB.field_78896_c * 2;
            int x1 = this.getArenaPos().func_177958_n() + previousArenBB.field_78893_d * 2;
            int y1 = this.getArenaPos().func_177956_o() + previousArenBB.field_78894_e * 2;
            int z1 = this.getArenaPos().func_177952_p() + previousArenBB.field_78892_f * 2;
            StructuresHelper.fillCube((World)this.shard, new BlockPos(x0, y0, z0), new BlockPos(x1, y1, z1), Blocks.field_150350_a.func_176223_P(), 0, REPAIR_RULE);
            long cleanEnd = (System.nanoTime() - cleanStart) / 1000000L;
            ModMain.LOGGER.debug(MARKER, "EMERGENCY CLEAR TIME: " + (float)cleanEnd / 1000.0f + "s");
        }
        this.trackedManuallyPlacedBlocks.clear();
        long buildStart = System.nanoTime();
        this.blocksPlaced = this.arenaEntry.arena.buildArena(this);
        long buildEnd = (System.nanoTime() - buildStart) / 1000000L;
        ModMain.LOGGER.debug(MARKER, "BUILD TIME: " + (float)buildEnd / 1000.0f + "s");
        this.ownerProps.markArenaDirty(true);
        this.ownerProps.setPreviousChallenge(this.core, this.arenaEntry.arena.getStyle(), this.arenaEntry.arena.getClass().getName());
        this.phase = Phase.SPAWN;
        this.tickInterval.setInterval(100);
    }

    private void executeSpawnPhase() {
        this.wipeOldEntities(true);
        this.spawnChallengers();
        this.spawnEnemies();
        this.phase = Phase.READY;
        this.tickInterval.setInterval(20);
    }

    private void executeReadyPhase() {
        if (this.readyInterval.getTick() <= 10) {
            StringTextComponent countdownMessage = new StringTextComponent(TextFormatting.GOLD + "" + (this.readyInterval.getTick() - 1));
            this.sendGroupTitle((ITextComponent)countdownMessage, 5, (int)Math.ceil(10.0f * (1.0f + this.deltaTime)), 5);
        }
        if (this.readyInterval.canTick()) {
            this.phase = Phase.RUN;
            this.group.forEach(entity -> entity.func_195063_d((Effect)ModEffects.IN_EVENT.get()));
            this.enemies.forEach(entity -> entity.func_195063_d((Effect)ModEffects.IN_EVENT.get()));
            this.sendGroupTitle((ITextComponent)ModI18n.CHALLENGE_MESSAGE_START_FIGHT, 2, (int)Math.ceil(5.0f * (1.0f + this.deltaTime)), 2);
            this.startTick = this.shard.func_82737_E();
        }
    }

    private void executeRunPhase() {
        if (this.inProgressTick > (float)this.tickLimit) {
            this.phase = Phase.END;
            this.result = Result.TIMEOUT;
            this.tickInterval.setInterval(20);
            return;
        }
        int groupAlive = 0;
        for (LivingEntity groupMember : this.group) {
            if (groupMember.func_70644_a((Effect)ModEffects.CHALLENGE_FAILED.get())) {
                this.despawnChallenger(groupMember);
                continue;
            }
            if (!groupMember.func_70089_S() || !WyHelper.isInChallengeDimension(groupMember.field_70170_p)) continue;
            ++groupAlive;
            break;
        }
        if (groupAlive <= 0) {
            this.group.clear();
            this.phase = Phase.END;
            this.result = Result.DEATH;
            return;
        }
        if (!this.enemies.isEmpty()) {
            this.enemies.removeIf(entity -> entity == null || !entity.func_70089_S());
        } else if (this.enemies.isEmpty()) {
            this.phase = Phase.END;
            this.result = Result.WIN;
            this.finishTick = this.shard.func_82737_E();
            this.tickInterval.setInterval(20);
            return;
        }
    }

    private void executeEndPhase() {
        if (this.endWaitInterval.canTick()) {
            this.phase = Phase.POSTEND;
            long cleanStart = System.nanoTime();
            MutableBoundingBox previousArenBB = MutableBoundingBox.func_175899_a((int)-50, (int)-50, (int)-50, (int)50, (int)50, (int)50);
            int x0 = this.getArenaPos().func_177958_n() + previousArenBB.field_78897_a * 2;
            int y0 = this.getArenaPos().func_177956_o() + previousArenBB.field_78895_b * 2;
            int z0 = this.getArenaPos().func_177952_p() + previousArenBB.field_78896_c * 2;
            int x1 = this.getArenaPos().func_177958_n() + previousArenBB.field_78893_d * 2;
            int y1 = this.getArenaPos().func_177956_o() + previousArenBB.field_78894_e * 2;
            int z1 = this.getArenaPos().func_177952_p() + previousArenBB.field_78892_f * 2;
            StructuresHelper.fillCube((World)this.shard, new BlockPos(x0, y0, z0), new BlockPos(x1, y1, z1), Blocks.field_150350_a.func_176223_P(), 0, null);
            this.ownerProps.markArenaDirty(false);
            long cleanEnd = (System.nanoTime() - cleanStart) / 1000000L;
            ModMain.LOGGER.debug(MARKER, "CLEAR TIME: " + (float)cleanEnd / 1000.0f + "s");
            ForgeChunkManager.forceChunk((ServerWorld)this.shard, (String)"mineminenomi", (BlockPos)this.pos, (int)0, (int)0, (boolean)false, (boolean)false);
            for (LivingEntity entity : this.getGroup()) {
                this.despawnChallenger(entity);
            }
            if (this.result == Result.WIN && !this.isCompleted) {
                this.completeChallenge();
                this.isCompleted = true;
            }
            this.groupCache.clear();
            ChallengesWorldData.get().stopChallenge(this);
        } else {
            StringTextComponent countdownMessage = new StringTextComponent("\u00a7f\u00a7l" + new TranslationTextComponent(ModI18n.CHALLENGE_MESSAGE_END_COUNTDOWN, new Object[]{this.endWaitInterval.getTick()}).getString() + "\u00a7r");
            this.sendGroupActionbar((ITextComponent)countdownMessage, 5, Math.round(20.0f * (1.0f + this.deltaTime)), 5);
        }
    }

    private void completeChallenge() {
        for (LivingEntity entity : this.getGroup()) {
            Object challenge;
            ServerPlayerEntity player;
            IChallengesData props;
            if (!entity.func_70089_S() || !(entity instanceof ServerPlayerEntity) || (props = ChallengesDataCapability.get((PlayerEntity)(player = (ServerPlayerEntity)entity))) == null || (challenge = props.getChallenge(this.getCore())) == null) continue;
            int time = Math.round((float)(this.finishTick - this.startTick) / 20.0f);
            String mode = "";
            if (this.hasRestrictions() && !this.hasActiveRestrictions()) {
                mode = " (TRAINING)";
            } else if (((Challenge)challenge).isPersonalBest(time)) {
                mode = " (PB)";
            }
            String timeStr = String.format("\u00a72\u00a7l%02d:%02d\u00a7r%s", time / 60, time % 60, mode);
            String rewardsMessage = "";
            if (this.hasRewards()) {
                rewardsMessage = ((Challenge)challenge).getRewards((PlayerEntity)player);
                ((Challenge)challenge).tryUpdateBestTime(time);
                ((Challenge)challenge).setComplete((PlayerEntity)player, true);
            }
            StringTextComponent reportStr = new StringTextComponent(ModI18n.CHALLENGE_MESSAGE_COMPLETION_REPORT.getString() + "" + timeStr);
            player.func_145747_a((ITextComponent)this.core.getLocalizedTitle(), Util.field_240973_b_);
            player.func_145747_a((ITextComponent)reportStr, Util.field_240973_b_);
            if (rewardsMessage == null) continue;
            player.func_145747_a((ITextComponent)new StringTextComponent(rewardsMessage), Util.field_240973_b_);
        }
    }

    public boolean hasRewards() {
        return this.isStandardDifficulty() ? true : this.hasActiveRestrictions();
    }

    public boolean hasRestrictions() {
        return !this.isStandardDifficulty();
    }

    public boolean hasActiveRestrictions() {
        return !this.isFree;
    }

    public boolean canDelete() {
        return this.phase == Phase.POSTEND;
    }

    public boolean isBuilding() {
        return this.phase == Phase.BUILD || this.phase == Phase.POSTEND;
    }

    public void despawnChallenger(LivingEntity entity) {
        if (entity.func_70089_S() && WyHelper.isInChallengeDimension(entity.field_70170_p) && entity instanceof ServerPlayerEntity) {
            BlockPos spawnPos;
            ServerWorld spawnWorld;
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            ChallengeCache cache = this.groupCache.get(player.func_110124_au());
            if (cache != null) {
                cache.restore(entity);
            }
            if (CommonConfig.INSTANCE.isReturnToSafetyEnabled()) {
                spawnWorld = player.func_184102_h().func_241755_D_();
                spawnPos = player.func_241140_K_();
                if (spawnPos == null) {
                    spawnPos = spawnWorld.func_241135_u_();
                }
            } else {
                spawnWorld = player.func_184102_h().func_71218_a(this.returnDimension);
                spawnPos = this.returnPosition;
            }
            AbilityHelper.disableAbilities((LivingEntity)player, 10, (Predicate<IAbility>)Predicates.alwaysTrue());
            player.field_70143_R = 0.0f;
            player.func_195061_cb();
            player.func_241209_g_(0);
            player.func_195063_d((Effect)ModEffects.CHALLENGE_FAILED.get());
            player.func_200619_a(spawnWorld, (double)spawnPos.func_177958_n(), (double)spawnPos.func_177956_o(), (double)spawnPos.func_177952_p(), player.field_70177_z, player.field_70125_A);
        }
    }

    private void spawnEnemies() {
        Set<ChallengeArena.EnemySpawn> positions = this.challenge.getCore().getEnemySpawns().getEnemySpawns(this, this.arenaEntry.enemyPosition.getEnemySpawnPos(this));
        this.enemies = positions.stream().map(ChallengeArena.EnemySpawn::getEntity).collect(Collectors.toSet());
        for (ChallengeArena.EnemySpawn spawnPoint : positions) {
            LivingEntity entity = spawnPoint.getEntity();
            entity.field_98038_p = true;
            this.getShard().func_217376_c((Entity)entity);
            entity.func_70634_a((double)spawnPoint.getSpawnPos().getPos().func_177958_n(), (double)spawnPoint.getSpawnPos().getPos().func_177956_o(), (double)spawnPoint.getSpawnPos().getPos().func_177952_p());
            entity.field_70177_z = spawnPoint.getSpawnPos().getYaw();
            entity.field_70125_A = spawnPoint.getSpawnPos().getPitch();
            if (entity instanceof MobEntity) {
                ((MobEntity)entity).func_70624_b((LivingEntity)this.getOwner());
                GoalUtil.lookAtEntity((MobEntity)entity, (Entity)this.getOwner());
            }
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.IN_EVENT.get(), 9999, 0));
            entity.func_70691_i(entity.func_110138_aP());
        }
    }

    private void spawnChallengers() {
        int i = 0;
        for (LivingEntity entity : this.group) {
            if (entity instanceof ServerPlayerEntity) {
                ServerPlayerEntity player = (ServerPlayerEntity)entity;
                ChallengeArena.SpawnPosition pos = this.arenaEntry.challengerPosition.getChallengerSpawnPos(i, this);
                ChunkPos chunkPos = new ChunkPos(pos.getPos());
                this.shard.func_72863_F().func_217228_a(TicketType.field_223185_g, chunkPos, 1, (Object)entity.func_145782_y());
                this.shard.func_212866_a_(chunkPos.field_77276_a, chunkPos.field_77275_b);
                player.func_200619_a(this.getShard(), (double)pos.getPos().func_177958_n(), (double)pos.getPos().func_177956_o(), (double)pos.getPos().func_177952_p(), pos.getYaw(), pos.getPitch());
                if (CommonConfig.INSTANCE.isChallengesCachingEnabled()) {
                    this.groupCache.put(entity.func_110124_au(), ChallengeCache.from((LivingEntity)player));
                }
            }
            ++i;
            entity.func_70691_i(entity.func_110138_aP());
            if (entity instanceof PlayerEntity) {
                ((PlayerEntity)entity).func_71024_bL().func_75122_a(20, 20.0f);
            }
            entity.func_195061_cb();
            entity.func_195064_c(new EffectInstance((Effect)ModEffects.IN_EVENT.get(), 9999, 0));
            IAbilityData props = AbilityDataCapability.get(entity);
            IHakiData hakiProps = HakiDataCapability.get(entity);
            for (IAbility ability : props.getEquippedAbilities()) {
                if (ability == null) continue;
                ability.getComponent(ModAbilityKeys.DISABLE).ifPresent(c -> c.startDisable(entity, 1.0f));
                ability.getComponent(ModAbilityKeys.DISABLE).ifPresent(c -> c.stopDisable(entity));
                ability.getComponent(ModAbilityKeys.COOLDOWN).ifPresent(c -> c.stopCooldown(entity));
            }
            hakiProps.setHakiOveruse(0);
        }
        this.shard.func_72966_v();
    }

    public void wipeOldEntities(boolean force) {
        this.shard.getEntities().forEach(entity -> {
            if (!(entity instanceof PlayerEntity)) {
                entity.func_70106_y();
            }
        });
    }

    private void sendGroupTitle(ITextComponent title, int fadeInTime, int stayTime, int fadeOutTime) {
        this.sendGroupTitle(title, null, fadeInTime, stayTime, fadeOutTime);
    }

    private void sendGroupTitle(ITextComponent title, @Nullable ITextComponent subtitle, int fadeInTime, int stayTime, int fadeOutTime) {
        for (LivingEntity groupMember : this.group) {
            if (!(groupMember instanceof ServerPlayerEntity)) continue;
            ServerPlayerEntity player = (ServerPlayerEntity)groupMember;
            try {
                player.field_71135_a.func_147359_a((IPacket)new STitlePacket(fadeInTime, stayTime, fadeOutTime));
                IFormattableTextComponent titleComponent = TextComponentUtils.func_240645_a_((CommandSource)player.func_195051_bN(), (ITextComponent)title, (Entity)player, (int)0);
                player.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.TITLE, (ITextComponent)titleComponent));
                if (subtitle == null) continue;
                IFormattableTextComponent subtitleComponent = TextComponentUtils.func_240645_a_((CommandSource)player.func_195051_bN(), (ITextComponent)subtitle, (Entity)player, (int)0);
                player.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.SUBTITLE, (ITextComponent)subtitleComponent));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void sendGroupActionbar(ITextComponent text, int fadeInTime, int stayTime, int fadeOutTime) {
        for (LivingEntity groupMember : this.group) {
            if (!groupMember.func_70089_S() || !(groupMember instanceof ServerPlayerEntity) || !WyHelper.isInChallengeDimension(groupMember.field_70170_p)) continue;
            ServerPlayerEntity player = (ServerPlayerEntity)groupMember;
            try {
                player.field_71135_a.func_147359_a((IPacket)new STitlePacket(fadeInTime, stayTime, fadeOutTime));
                IFormattableTextComponent titleComponent = TextComponentUtils.func_240645_a_((CommandSource)player.func_195051_bN(), (ITextComponent)text, (Entity)player, (int)0);
                player.field_71135_a.func_147359_a((IPacket)new STitlePacket(STitlePacket.Type.ACTIONBAR, (ITextComponent)titleComponent));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isStandardDifficulty() {
        return this.core.getDifficulty() == ChallengeDifficulty.STANDARD;
    }

    public boolean isHardDifficulty() {
        return this.core.getDifficulty() == ChallengeDifficulty.HARD;
    }

    public boolean isUltimateDifficulty() {
        return this.core.getDifficulty() == ChallengeDifficulty.ULTIMATE;
    }

    public BlockPos getArenaPos() {
        return this.pos;
    }

    public UUID getId() {
        return this.id;
    }

    public ChallengeCore getCore() {
        return this.core;
    }

    public List<LivingEntity> getGroup() {
        return this.group;
    }

    public HashMap<UUID, ChallengeCache> getGroupCache() {
        return this.groupCache;
    }

    public Set<LivingEntity> getEnemies() {
        return this.enemies;
    }

    public ServerPlayerEntity getOwner() {
        return this.owner;
    }

    public ServerWorld getShard() {
        return this.shard;
    }

    public ChallengeArena getArena() {
        return this.arenaEntry.arena;
    }

    public Random getRNG() {
        return this.random;
    }

    public void trackBlockPos(BlockPos pos) {
        this.trackedManuallyPlacedBlocks.add(pos);
    }

    public void trackBlockPos(Set<BlockPos> pos) {
        this.trackedManuallyPlacedBlocks.addAll(pos);
    }

    private static enum Result {
        TBD,
        WIN,
        TIMEOUT,
        DEATH;

    }

    private static enum Phase {
        BUILD,
        SPAWN,
        READY,
        RUN,
        END,
        POSTEND;

    }
}

