/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.entities;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.ai.brain.Memory;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;

public class GoalMemories {
    private final Map<MemoryModuleType<?>, Memory<?>> memories = Maps.newHashMap();

    public void tick() {
        Iterator<Map.Entry<MemoryModuleType<?>, Memory<?>>> it = this.memories.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<MemoryModuleType<?>, Memory<?>> entry = it.next();
            Memory<?> memory = entry.getValue();
            memory.func_234064_a_();
            if (!memory.func_234073_d_()) continue;
            it.remove();
        }
    }

    public <U> Optional<U> getMemory(MemoryModuleType<U> type) {
        try {
            return Optional.of(this.memories.get(type).func_234072_c_());
        }
        catch (NullPointerException e) {
            return Optional.empty();
        }
    }

    public boolean hasMemoryValue(MemoryModuleType<?> type) {
        return this.checkMemory(type);
    }

    public <U> void eraseMemory(MemoryModuleType<U> type) {
        this.memories.remove(type);
    }

    public <U> void setMemory(MemoryModuleType<U> memoryType, U memory) {
        this.setMemoryInternal(memoryType, Memory.func_234068_a_(memory));
    }

    public <U> void setMemoryWithExpiry(MemoryModuleType<U> memoryType, U memory, long timesToLive) {
        this.setMemoryInternal(memoryType, Memory.func_234069_a_(memory, (long)timesToLive));
    }

    public boolean checkMemory(MemoryModuleType<?> memoryType) {
        Memory<?> memory = this.memories.get(memoryType);
        return memory != null;
    }

    public <U> boolean isMemoryValue(MemoryModuleType<U> memoryType, U memory) {
        return !this.hasMemoryValue(memoryType) ? false : this.getMemory(memoryType).filter(p_233704_1_ -> p_233704_1_.equals(memory)).isPresent();
    }

    private <U> void setMemoryInternal(MemoryModuleType<U> memoryType, Memory<?> memory) {
        if (this.memories.containsKey(memoryType)) {
            if (this.isEmptyCollection(memory.func_234072_c_())) {
                this.eraseMemory(memoryType);
            } else {
                this.memories.put(memoryType, memory);
            }
        } else {
            this.memories.put(memoryType, memory);
        }
    }

    private boolean isEmptyCollection(Object collection) {
        return collection instanceof Collection && ((Collection)collection).isEmpty();
    }
}

