/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.entities;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.api.entities.IGoalMemoriesEntity;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.TargetHelper;
import xyz.pixelatedw.mineminenomi.api.util.TargetsPredicate;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.gcd.GCDCapability;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class GoalUtil {
    private static final EntityPredicate VISIBLE_TARGET_IN_RANGE = new EntityPredicate().func_221013_a(16.0);
    private static final EntityPredicate ALIVE_TARGET = new EntityPredicate().func_221014_c().func_221010_e();
    private static final TargetsPredicate NEARBY_TARGETS_PREDICATE = new TargetsPredicate().testEnemyFaction().testSimpleInView();

    public static boolean lastHurtCheckBefore(LivingEntity entity, int time) {
        if (entity.func_142015_aE() <= 0) {
            return false;
        }
        IEntityStats props = EntityStatsCapability.get(entity);
        if (props == null) {
            return false;
        }
        long timestamp = props.getLastAttackTimestamp();
        return entity.field_70170_p.func_82737_E() <= timestamp + (long)time;
    }

    public static boolean lastHurtCheckAfter(LivingEntity entity, int time) {
        if (entity.func_142015_aE() <= 0) {
            return false;
        }
        IEntityStats props = EntityStatsCapability.get(entity);
        if (props == null) {
            return false;
        }
        long timestamp = props.getLastAttackTimestamp();
        return entity.field_70170_p.func_82737_E() > timestamp + (long)time;
    }

    public static boolean canMove(LivingEntity entity) {
        return AbilityHelper.canUseMomentumAbilities(entity);
    }

    public static boolean shouldMove(MobEntity entity) {
        if (!GoalUtil.canMove((LivingEntity)entity)) {
            return false;
        }
        if (GoalUtil.hasAliveTarget(entity)) {
            return true;
        }
        return entity.func_70661_as().func_75505_d() != null;
    }

    @Deprecated
    public static void startGCD(LivingEntity entity) {
        GCDCapability.startGCD(entity);
    }

    @Deprecated
    public static boolean isGCDActive(LivingEntity entity) {
        return GCDCapability.isOnGCD(entity);
    }

    public static List<LivingEntity> getNearbyVisibleEntities(LivingEntity entity, double distance, @Nullable Predicate<Entity> predicate) {
        return WyHelper.getNearbyLiving(entity.func_213303_ch(), (IWorld)entity.field_70170_p, distance, predicate).stream().filter(target -> target != entity && VISIBLE_TARGET_IN_RANGE.func_221015_a(entity, target)).collect(Collectors.toList());
    }

    public static boolean hasAliveOwner(TameableEntity entity) {
        LivingEntity owner = entity.func_70902_q();
        return owner != null && owner.func_70089_S();
    }

    public static boolean hasAliveTarget(MobEntity entity) {
        LivingEntity target = entity.func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        return ALIVE_TARGET.func_221015_a((LivingEntity)entity, target);
    }

    public static boolean isAtSameHeight(LivingEntity entity, LivingEntity target, double variation) {
        return Math.abs(entity.func_213303_ch().func_178788_d((Vector3d)target.func_213303_ch()).field_72448_b) < 1.0 + variation;
    }

    public static boolean isOutsideDistance(LivingEntity entity, LivingEntity target, double distance) {
        return entity.func_70068_e((Entity)target) > distance * distance;
    }

    public static boolean isWithinDistance(LivingEntity entity, LivingEntity target, double distance) {
        return entity.func_70068_e((Entity)target) <= distance * distance;
    }

    public static boolean isWithinMeleeAttackRange(LivingEntity entity, LivingEntity target, float bonus) {
        double d0 = entity.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        double d1 = entity.func_213311_cf() * 2.0f * entity.func_213311_cf() * 2.0f + target.func_213311_cf();
        return d0 <= (d1 += (double)bonus);
    }

    public static boolean isWithinMeleeAttackRange(LivingEntity entity, LivingEntity target) {
        double d1;
        double d0 = entity.func_70092_e(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
        return d0 <= (d1 = (double)(entity.func_213311_cf() * 2.0f * entity.func_213311_cf() * 2.0f + target.func_213311_cf()));
    }

    @Deprecated
    public static <E extends LivingEntity> boolean isOtherTargetMuchFurtherAwayThanCurrentAttackTarget(E entity, LivingEntity target, double distance) {
        Optional optional = ((IGoalMemoriesEntity)entity).getMemory(MemoryModuleType.field_234103_o_);
        if (!optional.isPresent()) {
            return false;
        }
        double d0 = entity.func_195048_a(((LivingEntity)optional.get()).func_213303_ch());
        double d1 = entity.func_195048_a(target.func_213303_ch());
        return d1 > d0 + distance * distance;
    }

    public static boolean canSee(MobEntity entity, LivingEntity target) {
        return entity.func_70635_at().func_75522_a((Entity)target);
    }

    public static boolean isVisibleFrom(LivingEntity entity, Entity target, Vector3d lookVec) {
        Vector3d targetVec = new Vector3d(target.func_226277_ct_(), target.func_226280_cw_(), target.func_226281_cx_());
        if (target.field_70170_p != entity.field_70170_p || targetVec.func_72436_e(lookVec) > 16384.0) {
            return false;
        }
        return entity.field_70170_p.func_217299_a(new RayTraceContext(lookVec, targetVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)entity)).func_216346_c() == RayTraceResult.Type.MISS;
    }

    public static boolean isEntityInView(LivingEntity entity, Entity target) {
        return TargetHelper.isEntityInView(entity, target, 60.0f);
    }

    public static LivingEntity getNearestTarget(LivingEntity entity, Optional<LivingEntity> optionalTarget, LivingEntity target) {
        return !optionalTarget.isPresent() ? target : GoalUtil.getTargetNearestMe(entity, optionalTarget.get(), target);
    }

    public static LivingEntity getTargetNearestMe(LivingEntity entity, LivingEntity target1, LivingEntity target2) {
        Vector3d target1Position = target1.func_213303_ch();
        Vector3d target2Position = target2.func_213303_ch();
        return entity.func_195048_a(target1Position) < entity.func_195048_a(target2Position) ? target1 : target2;
    }

    public static void lookAt(MobEntity entity, Vector3d position) {
        entity.func_200602_a(EntityAnchorArgument.Type.EYES, position);
    }

    public static void lookAtEachOther(MobEntity entity1, MobEntity entity2) {
        GoalUtil.lookAtEntity(entity1, (Entity)entity2);
        GoalUtil.lookAtEntity(entity2, (Entity)entity1);
    }

    public static void lookAtEntity(MobEntity entity, @Nullable Entity target) {
        if (target == null) {
            return;
        }
        entity.func_200602_a(EntityAnchorArgument.Type.EYES, target.func_213303_ch().func_72441_c(0.0, (double)target.func_70047_e(), 0.0));
    }

    public static boolean hasEnoughTargetsAround(MobEntity entity, int minEnemies, float distance) {
        List<LivingEntity> targets = TargetHelper.getEntitiesInArea((LivingEntity)entity, (double)distance, NEARBY_TARGETS_PREDICATE, new Class[0]);
        int confirmedTargets = 0;
        for (LivingEntity target : targets) {
            if (target != null && target.func_70089_S() && entity.func_70068_e((Entity)target) <= (double)(distance * distance) && GoalUtil.canSee(entity, target)) {
                ++confirmedTargets;
            }
            if (confirmedTargets < minEnemies) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHealthAbovePercentage(LivingEntity entity, double percentage) {
        return (double)entity.func_110143_aJ() >= WyHelper.percentage(percentage, entity.func_110138_aP());
    }

    public static boolean hasHealthUnderPercentage(LivingEntity entity, double percentage) {
        return (double)entity.func_110143_aJ() < WyHelper.percentage(percentage, entity.func_110138_aP());
    }

    public static boolean hasSolidBlockAbove(LivingEntity entity) {
        BlockState above;
        if (entity instanceof MobEntity) {
            LivingEntity target = ((MobEntity)entity).func_70638_az();
            int checkDist = (int)Math.min(target.func_213303_ch().func_178788_d((Vector3d)entity.func_213303_ch()).field_72448_b, 10.0);
            if (checkDist > 1) {
                for (int i = 1; i < checkDist + 1; ++i) {
                    BlockState above2 = entity.field_70170_p.func_180495_p(entity.func_233580_cy_().func_177981_b(i));
                    if (!above2.func_224755_d((IBlockReader)entity.field_70170_p, entity.func_233580_cy_().func_177981_b(i + 2), Direction.DOWN)) continue;
                    return true;
                }
            }
        }
        return (above = entity.field_70170_p.func_180495_p(entity.func_233580_cy_().func_177984_a())).func_224755_d((IBlockReader)entity.field_70170_p, entity.func_233580_cy_().func_177981_b(2), Direction.DOWN);
    }

    public static boolean hasBlockInFace(LivingEntity entity) {
        Direction dir;
        Vector3d end;
        Vector3d start = entity.func_213303_ch().func_72441_c(0.0, (double)entity.func_70047_e(), 0.0);
        BlockRayTraceResult result = entity.field_70170_p.func_217299_a(new RayTraceContext(start, end = start.func_72441_c((double)(dir = entity.func_174811_aO()).func_82601_c(), 0.0, (double)dir.func_82599_e()), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, null));
        return result != null && result.func_216346_c() != RayTraceResult.Type.MISS;
    }

    public static int getFrontWallHeight(LivingEntity entity) {
        BlockPos start = entity.func_233580_cy_();
        BlockPos check = start.func_177971_a(entity.func_174811_aO().func_176730_m());
        Direction dir = entity.func_174811_aO().func_176734_d();
        int blocks = 0;
        for (int i = 0; i < 4; ++i) {
            BlockPos pos = check.func_177981_b(i);
            BlockState state = entity.field_70170_p.func_180495_p(pos);
            if (!state.func_224755_d((IBlockReader)entity.field_70170_p, pos, dir)) continue;
            ++blocks;
        }
        return blocks;
    }
}

