/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.entities.ai;

import javax.annotation.Nullable;
import net.minecraft.entity.MobEntity;
import net.minecraft.potion.Effect;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.init.ModEffects;

public class NPCPhaseManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final MobEntity entity;
    private NPCPhase<?> currentPhase;
    private NPCPhase<?> previousPhase;

    public NPCPhaseManager(MobEntity entity) {
        this.entity = entity;
    }

    public void setPhase(NPCPhase<?> phase) {
        if (this.currentPhase == null || !phase.equals(this.currentPhase)) {
            if (this.currentPhase != null) {
                this.currentPhase.stopPhase();
            }
            this.previousPhase = this.currentPhase;
            this.currentPhase = phase;
            this.currentPhase.startPhase();
            LOGGER.debug("Switched {}'s phase to: {}", (Object)this.entity.func_145748_c_().getString(), (Object)this.currentPhase.toString());
        }
    }

    public void tick() {
        if (this.entity.func_70644_a((Effect)ModEffects.IN_EVENT.get())) {
            return;
        }
        if (this.currentPhase != null) {
            this.currentPhase.tick();
        }
    }

    @Nullable
    public NPCPhase<?> getPreviousPhase() {
        return this.previousPhase;
    }

    @Nullable
    public NPCPhase<?> getCurrentPhase() {
        return this.currentPhase;
    }

    @Nullable
    public boolean isCurrentPhase(NPCPhase<?> phase) {
        return this.currentPhase.equals(phase);
    }
}

