/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.entities.revenge;

import net.minecraft.entity.LivingEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import xyz.pixelatedw.mineminenomi.api.damagesource.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.entities.revenge.IRevengeCheck;

public class PhysicalHitRevengeCheck
implements IRevengeCheck {
    private final int revengeGain;
    private float prevHealth;
    private int hitCount;

    public PhysicalHitRevengeCheck(int revengeGain) {
        this.revengeGain = revengeGain;
    }

    @Override
    public boolean check(LivingEntity entity) {
        if (this.prevHealth == 0.0f) {
            this.prevHealth = entity.func_110143_aJ();
        }
        boolean isPhysical = false;
        DamageSource source = entity.func_189748_bU();
        if (source != null) {
            isPhysical |= source instanceof EntityDamageSource && source.field_76373_n.equals("player");
            isPhysical |= source instanceof AbilityDamageSource && ((AbilityDamageSource)source).isPhysical();
        }
        if (isPhysical && entity.func_110143_aJ() < this.prevHealth) {
            ++this.hitCount;
            this.prevHealth = entity.func_110143_aJ();
            return true;
        }
        return false;
    }

    @Override
    public void resetMarkers() {
        this.prevHealth = 0.0f;
        this.hitCount = 0;
    }

    @Override
    public int revengeMeterGain() {
        return this.revengeGain;
    }

    public int getHits() {
        return this.hitCount;
    }
}

