/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.interactions;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class Interaction
extends ForgeRegistryEntry<Interaction> {
    private ITextComponent title = StringTextComponent.field_240750_d_;
    private ITextComponent message = StringTextComponent.field_240750_d_;
    private RegistryObject<Interaction>[] interactions;
    private InteractionTrigger triggerAction;
    private final Random random = new Random();

    public Interaction() {
    }

    public Interaction(ITextComponent title) {
        this.title = title;
    }

    public ITextComponent getTitle() {
        return this.title;
    }

    public void setMessage(ITextComponent message) {
        this.message = message;
    }

    public ITextComponent getMessage() {
        return this.message;
    }

    public void setInteractions(RegistryObject<Interaction> ... interactions) {
        this.interactions = interactions;
    }

    public RegistryObject<Interaction>[] getInteractions() {
        return this.interactions;
    }

    public boolean hasTriggerAction() {
        return this.triggerAction != null;
    }

    public void setTriggerAction(InteractionTrigger trigger) {
        this.triggerAction = trigger;
    }

    public InteractionTrigger getTriggerAction() {
        return this.triggerAction;
    }

    public Random getRandom() {
        return this.random;
    }

    public InteractionResult trigger(PlayerEntity player, LivingEntity entity) {
        return this.triggerAction.trigger(player, entity);
    }

    public static enum InteractionResultType {
        CLOSE_DIALOGUE,
        CONTINUE,
        NEXT;

    }

    public static class InteractionResult {
        @Nullable
        private Interaction nextInteraction;
        private InteractionResultType type;

        public InteractionResult(@Nullable Interaction next, InteractionResultType type) {
            this.nextInteraction = next;
            this.type = type;
        }

        public static InteractionResult continueInteraction() {
            return new InteractionResult(null, InteractionResultType.CONTINUE);
        }

        public static InteractionResult next(Interaction next) {
            return new InteractionResult(next, InteractionResultType.NEXT);
        }

        public static InteractionResult close() {
            return new InteractionResult(null, InteractionResultType.CLOSE_DIALOGUE);
        }

        @Nullable
        public Interaction getNextInteraction() {
            return this.nextInteraction;
        }

        public InteractionResultType getType() {
            return this.type;
        }
    }

    @FunctionalInterface
    public static interface InteractionTrigger {
        public InteractionResult trigger(PlayerEntity var1, LivingEntity var2);
    }
}

