/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.morph;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.pixelatedw.mineminenomi.api.morph.MorphModel;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.renderers.morphs.ZoanMorphRenderer;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public abstract class MorphInfo
extends ForgeRegistryEntry<MorphInfo> {
    @Nullable
    public AkumaNoMiItem getDevilFruit() {
        return null;
    }

    @Deprecated
    public abstract String getForm();

    @OnlyIn(value=Dist.CLIENT)
    public abstract MorphModel getModel();

    public boolean isActive(LivingEntity entity) {
        IDevilFruit props = DevilFruitCapability.get(entity);
        boolean check = props.getCurrentMorph().isPresent() && props.hasMorphActive(this);
        boolean legacyCheck = props.getZoanPoint().equalsIgnoreCase(this.getForm());
        return check || legacyCheck;
    }

    public abstract String getDisplayName();

    @Nullable
    public ResourceLocation getTexture(LivingEntity entity) {
        return this.getTexture();
    }

    @Nullable
    public ResourceLocation getTexture() {
        if (this.getDevilFruit() != null) {
            return new ResourceLocation("mineminenomi", "textures/models/zoanmorph/" + WyHelper.getResourceName(this.getForm()) + ".png");
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public IRenderFactory getRendererFactory(LivingEntity entity) {
        return this.getRendererFactory();
    }

    @OnlyIn(value=Dist.CLIENT)
    public IRenderFactory getRendererFactory() {
        return new ZoanMorphRenderer.Factory(this, this.hasCulling());
    }

    public boolean isPartial() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderFirstPersonHand() {
        return this.getModel() != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderFirstPersonLeg() {
        return this.shouldRenderFirstPersonHand();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void preRenderCallback(LivingEntity entity, MatrixStack matrixStack, float partialTickTime) {
    }

    @Nullable
    public Map<Pose, EntitySize> getSizes() {
        return null;
    }

    public double getEyeHeight() {
        return 0.0;
    }

    public float getShadowSize() {
        return -1.0f;
    }

    public boolean canMount() {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasCulling() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean hasEqualDepthTest() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getCameraZoom(LivingEntity entity) {
        return 0.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public double getCameraHeight(LivingEntity entity) {
        return 0.0;
    }
}

