/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.poi;

import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.poi.TrackedNPC;
import xyz.pixelatedw.mineminenomi.entities.mobs.NotoriousEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18nInteractions;

public class NewsEntry {
    private static final String[] PIRATE_NEWS = new String[]{ModI18nInteractions.PIRATE_NEWS_1_MESSAGE, ModI18nInteractions.PIRATE_NEWS_2_MESSAGE, ModI18nInteractions.PIRATE_NEWS_3_MESSAGE, ModI18nInteractions.PIRATE_NEWS_4_MESSAGE, ModI18nInteractions.PIRATE_NEWS_5_MESSAGE, ModI18nInteractions.PIRATE_NEWS_6_MESSAGE, ModI18nInteractions.PIRATE_NEWS_7_MESSAGE};
    private static final String[] MARINE_NEWS = new String[]{ModI18nInteractions.MARINE_NEWS_1_MESSAGE, ModI18nInteractions.MARINE_NEWS_2_MESSAGE, ModI18nInteractions.MARINE_NEWS_3_MESSAGE, ModI18nInteractions.MARINE_NEWS_4_MESSAGE, ModI18nInteractions.MARINE_NEWS_5_MESSAGE, ModI18nInteractions.MARINE_NEWS_6_MESSAGE};
    private final TrackedNPC tracked;
    private TranslationTextComponent message;

    private NewsEntry(TrackedNPC tracked) {
        this.tracked = tracked;
    }

    public static NewsEntry createNewsFor(TrackedNPC tracked, World world) {
        NewsEntry entry = new NewsEntry(tracked);
        NotoriousEntity entity = tracked.createTrackedMob(world);
        if (tracked.isPirate()) {
            long bounty = tracked.getBounty();
            int kills = 100 + tracked.getRandom().nextInt(255);
            int razed = 2 + tracked.getRandom().nextInt(10);
            int newsId = tracked.getRandom().nextInt(PIRATE_NEWS.length);
            Object[] args = new Object[]{entity.func_145748_c_().getString()};
            switch (newsId) {
                case 0: 
                case 2: 
                case 6: {
                    args = new Object[]{entity.func_145748_c_().getString(), razed};
                    break;
                }
                case 1: 
                case 3: {
                    args = new Object[]{entity.func_145748_c_().getString(), bounty};
                    break;
                }
                case 5: {
                    args = new Object[]{entity.func_145748_c_().getString(), kills};
                    break;
                }
            }
            entry.message = new TranslationTextComponent(PIRATE_NEWS[newsId], args);
        } else if (tracked.isMarine()) {
            int arrests = 50 + tracked.getRandom().nextInt(200);
            int razed = 2 + tracked.getRandom().nextInt(10);
            int newsId = tracked.getRandom().nextInt(MARINE_NEWS.length);
            Object[] args = new Object[]{entity.func_145748_c_().getString()};
            switch (newsId) {
                case 0: 
                case 3: 
                case 4: {
                    args = new Object[]{entity.func_145748_c_().getString(), razed};
                    break;
                }
                case 1: 
                case 2: {
                    args = new Object[]{entity.func_145748_c_().getString(), arrests};
                    break;
                }
            }
            entry.message = new TranslationTextComponent(MARINE_NEWS[newsId], args);
        }
        return entry;
    }

    public TranslationTextComponent getMessage() {
        return this.message;
    }
}

