/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.util;

import xyz.pixelatedw.mineminenomi.api.util.TPSDelta;

public class Interval {
    protected int interval;
    protected float tick = 0.0f;
    private boolean trackTPS = false;

    public Interval(int interval) {
        this.interval = interval;
    }

    public static Interval startAtZero(int interval) {
        return new Interval(interval);
    }

    public static Interval startAtMax(int interval) {
        Interval intervalObj = new Interval(interval);
        intervalObj.tick = interval;
        return intervalObj;
    }

    public <T> T trackTPS() {
        this.trackTPS = true;
        return (T)this;
    }

    public boolean canTick() {
        this.tick = this.trackTPS ? (this.tick -= TPSDelta.INSTANCE.getDeltaTime()) : (this.tick -= 1.0f);
        if (this.tick <= 0.0f) {
            this.tick = this.interval;
            return true;
        }
        return false;
    }

    public void restartIntervalToZero() {
        this.tick = 0.0f;
    }

    public void restartIntervalToMax() {
        this.tick = this.interval;
    }

    public int getTick() {
        return Math.round(this.tick);
    }

    public static class Mutable
    extends Interval {
        public Mutable(int interval) {
            super(interval);
        }

        public void setInterval(int interval) {
            this.interval = interval;
            this.restartIntervalToMax();
        }
    }
}

