/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.blocks;

import java.util.Random;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.ForgeHooks;
import xyz.pixelatedw.mineminenomi.api.helpers.BlocksHelper;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModItems;

public class TangerineCropsBlock
extends DoublePlantBlock
implements IGrowable {
    public static final IntegerProperty AGE = BlocksHelper.AGE_4;

    public TangerineCropsBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200946_b().func_200947_a(SoundType.field_185850_c));
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return this.getBlock().func_185473_a(world, pos, state);
    }

    public ItemStack func_185473_a(IBlockReader level, BlockPos pos, BlockState state) {
        return new ItemStack((IItemProvider)ModItems.TANGERINE.get());
    }

    protected boolean func_200014_a_(BlockState state, IBlockReader level, BlockPos pos) {
        return state.func_203425_a(Blocks.field_150458_ak);
    }

    public ActionResultType func_225533_a_(BlockState state, World level, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        if (hand == Hand.OFF_HAND) {
            return ActionResultType.PASS;
        }
        int age = (Integer)state.func_177229_b((Property)AGE);
        boolean isFullyGrown = age == this.getMaxAge();
        ItemStack handItemStack = player.func_184586_b(hand);
        if (!isFullyGrown && handItemStack.func_77973_b().equals(Items.field_196106_bc)) {
            return ActionResultType.PASS;
        }
        if (isFullyGrown && handItemStack.func_190926_b()) {
            BlockState bottomState = level.func_180495_p(pos.func_177977_b());
            BlockState aboveState = level.func_180495_p(pos.func_177984_a());
            this.dropFruit(level, pos, state);
            if (!bottomState.func_196958_f() && bottomState.func_177230_c() == ModBlocks.TANGERINE_CROP.get()) {
                this.dropFruit(level, pos.func_177977_b(), bottomState);
            } else if (!aboveState.func_196958_f() && aboveState.func_177230_c() == ModBlocks.TANGERINE_CROP.get()) {
                this.dropFruit(level, pos.func_177984_a(), aboveState);
            }
            return ActionResultType.func_233537_a_((boolean)level.field_72995_K);
        }
        return super.func_225533_a_(state, level, pos, player, hand, hit);
    }

    private void dropFruit(World level, BlockPos pos, BlockState state) {
        int fruits = 1 + level.field_73012_v.nextInt(2);
        TangerineCropsBlock.func_180635_a((World)level, (BlockPos)pos, (ItemStack)new ItemStack((IItemProvider)ModItems.TANGERINE.get(), fruits));
        level.func_184133_a((PlayerEntity)null, pos, SoundEvents.field_219693_lB, SoundCategory.BLOCKS, 1.0f, 1.2f + level.field_73012_v.nextFloat() * 0.4f);
        level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(2)), 2);
    }

    public int getMaxAge() {
        return 4;
    }

    public boolean func_149653_t(BlockState state) {
        return (Integer)state.func_177229_b((Property)AGE) < this.getMaxAge();
    }

    public void func_225542_b_(BlockState state, ServerWorld level, BlockPos pos, Random random) {
        boolean canGrowThisTick;
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        int age = (Integer)state.func_177229_b((Property)AGE);
        boolean bl = canGrowThisTick = random.nextInt(25) == 0;
        if (age < this.getMaxAge() && level.func_226659_b_(pos.func_177984_a(), 0) >= 9 && ForgeHooks.onCropsGrowPre((World)level, (BlockPos)pos, (BlockState)state, (boolean)canGrowThisTick)) {
            BlockState bottomState = level.func_180495_p(pos.func_177977_b());
            BlockState aboveState = level.func_180495_p(pos.func_177984_a());
            this.grow((World)level, pos, state);
            if (!bottomState.func_196958_f() && bottomState.func_177230_c() == ModBlocks.TANGERINE_CROP.get()) {
                this.grow((World)level, pos.func_177977_b(), bottomState);
            } else if (!aboveState.func_196958_f() && aboveState.func_177230_c() == ModBlocks.TANGERINE_CROP.get()) {
                this.grow((World)level, pos.func_177984_a(), aboveState);
            }
            ForgeHooks.onCropsGrowPost((World)level, (BlockPos)pos, (BlockState)state);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{AGE});
    }

    public boolean func_176473_a(IBlockReader pLevel, BlockPos pPos, BlockState pState, boolean pIsClient) {
        return (Integer)pState.func_177229_b((Property)AGE) < this.getMaxAge();
    }

    public boolean func_180670_a(World pLevel, Random pRand, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void func_225535_a_(ServerWorld level, Random rand, BlockPos pos, BlockState state) {
        BlockState bottomState = level.func_180495_p(pos.func_177977_b());
        BlockState aboveState = level.func_180495_p(pos.func_177984_a());
        this.grow((World)level, pos, state);
        if (!bottomState.func_196958_f() && bottomState.func_177230_c() == ModBlocks.TANGERINE_CROP.get()) {
            this.grow((World)level, pos.func_177977_b(), bottomState);
        } else if (!aboveState.func_196958_f() && aboveState.func_177230_c() == ModBlocks.TANGERINE_CROP.get()) {
            this.grow((World)level, pos.func_177984_a(), aboveState);
        }
    }

    private void grow(World level, BlockPos pos, BlockState state) {
        int age = Math.min(this.getMaxAge(), (Integer)state.func_177229_b((Property)AGE) + 1);
        level.func_180501_a(pos, (BlockState)state.func_206870_a((Property)AGE, (Comparable)Integer.valueOf(age)), 2);
    }
}

