/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.blocks.tileentities;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.init.ModTileEntities;

public class CustomSpawnerTileEntity
extends TileEntity
implements ITickableTileEntity {
    private EntityType entityToSpawn = EntityType.field_200784_X;
    private int spawnLimit = 5;
    private int playerDistance = 100;
    private ArrayList<UUID> spawnedEntities = new ArrayList();

    public CustomSpawnerTileEntity() {
        super((TileEntityType)ModTileEntities.CUSTOM_SPAWNER.get());
    }

    public CustomSpawnerTileEntity setSpawnerMob(EntityType toSpawn) {
        this.entityToSpawn = toSpawn;
        this.func_70296_d();
        return this;
    }

    public CustomSpawnerTileEntity setSpawnerLimit(int limit) {
        this.spawnLimit = limit;
        this.func_70296_d();
        return this;
    }

    public CustomSpawnerTileEntity setPlayerDistance(int distance) {
        this.playerDistance = distance;
        this.func_70296_d();
        return this;
    }

    private boolean isActivated() {
        BlockPos blockpos = this.func_174877_v();
        return this.func_145831_w().func_217358_a((double)blockpos.func_177958_n() + 0.5, (double)blockpos.func_177956_o() + 0.5, (double)blockpos.func_177952_p() + 0.5, (double)this.playerDistance);
    }

    public void func_73660_a() {
        if (this.field_145850_b == null) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 5L == 0L) {
            if (this.isActivated()) {
                if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == Blocks.field_150350_a) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
                }
                if (this.spawnedEntities.size() > 0) {
                    int alive = 0;
                    for (UUID spawnUUID : this.spawnedEntities) {
                        Entity target = ((ServerWorld)this.field_145850_b).func_217461_a(spawnUUID);
                        if (target == null || !target.func_70089_S()) continue;
                        ++alive;
                    }
                    if (CommonConfig.INSTANCE.getDestroySpawner() && alive == 0) {
                        this.field_145850_b.func_175656_a(this.field_174879_c, Blocks.field_150350_a.func_176223_P());
                    }
                }
                if (this.entityToSpawn != null && this.spawnedEntities.size() < this.spawnLimit) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_74757_a("isSpawned", true);
                    LivingEntity newSpawn = (LivingEntity)this.entityToSpawn.func_220342_a((ServerWorld)this.field_145850_b, nbt, (ITextComponent)null, (PlayerEntity)null, this.field_174879_c.func_177984_a(), SpawnReason.STRUCTURE, false, false);
                    if (newSpawn != null) {
                        double r1 = (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * 2.0 + 0.5;
                        double r2 = (this.field_145850_b.field_73012_v.nextDouble() - this.field_145850_b.field_73012_v.nextDouble()) * 2.0 + 0.5;
                        BlockPos newPos = this.func_174877_v().func_177963_a(r1, 0.0, r2);
                        newSpawn.func_70012_b((double)newPos.func_177958_n(), (double)newPos.func_177956_o(), (double)newPos.func_177952_p(), 0.0f, 0.0f);
                        this.spawnedEntities.add(newSpawn.func_110124_au());
                        this.func_70296_d();
                    }
                }
            } else if (this.spawnedEntities.size() > 0) {
                for (UUID spawnUUID : this.spawnedEntities) {
                    Entity target = ((ServerWorld)this.field_145850_b).func_217461_a(spawnUUID);
                    if (target == null || !target.func_70089_S()) continue;
                    target.func_70106_y();
                }
                this.spawnedEntities.clear();
                this.func_70296_d();
            }
        }
    }

    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.spawnLimit = nbt.func_74762_e("spawnLimit");
        this.playerDistance = nbt.func_74762_e("playerDistance");
        if (this.playerDistance <= 0) {
            this.playerDistance = 30;
        }
        this.entityToSpawn = EntityType.func_220327_a((String)nbt.func_74779_i("entityToSpawn")).orElse(EntityType.field_200784_X);
        ListNBT spawnedEntities = nbt.func_150295_c("spawns", 10);
        for (int i = 0; i < spawnedEntities.size(); ++i) {
            CompoundNBT nbtEntity = spawnedEntities.func_150305_b(i);
            UUID nbtUUID = nbtEntity.func_186857_a("uuid");
            this.spawnedEntities.add(nbtUUID);
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("spawnLimit", this.spawnLimit);
        nbt.func_74768_a("playerDistance", this.playerDistance);
        nbt.func_74778_a("entityToSpawn", EntityType.func_200718_a((EntityType)this.entityToSpawn).toString());
        ListNBT spawnedEntities = new ListNBT();
        for (UUID uuid : this.spawnedEntities) {
            CompoundNBT nbtEntity = new CompoundNBT();
            nbtEntity.func_186854_a("uuid", uuid);
            spawnedEntities.add((Object)nbtEntity);
        }
        nbt.func_218657_a("spawns", (INBT)spawnedEntities);
        return nbt;
    }
}

