/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FourWayBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeArena;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.enums.CanvasSize;
import xyz.pixelatedw.mineminenomi.api.helpers.ChallengesHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.BlockPilePart;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.FlagPolePart;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.HayDummyPart;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.SimpleBasePart;
import xyz.pixelatedw.mineminenomi.challenges.arenas.parts.StairsPart;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MarineSmallBaseSimpleArena
extends ChallengeArena {
    public static final MarineSmallBaseSimpleArena INSTANCE = new MarineSmallBaseSimpleArena();
    private static final int ARENA_XZ_SIZE_RADIUS = 30;
    private static final int ARENA_Y_SIZE_RADIUS = 50;
    private static final int ARENA_XZ_SIZE = 60;

    private MarineSmallBaseSimpleArena() {
        super(ArenaStyle.SIMPLE);
    }

    @Override
    public Set<BlockPos> buildArena(InProgressChallenge challenge) {
        HashSet blocks = Sets.newHashSet();
        int bottomLayerOffset = 49;
        BlockPos bottomLayer = challenge.getArenaPos().func_185334_h().func_177979_c(49);
        BlockPos groundLayer = bottomLayer.func_177981_b(18);
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177984_a(), 60, 17, 60, Blocks.field_150348_b.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), bottomLayer.func_177981_b(17), 60, 1, 60, Blocks.field_150322_A.func_176223_P(), 0, null));
        int extraOffset1 = (int)WyHelper.randomWithRange(challenge.getShard().field_73012_v, -10, 10);
        int extraOffset2 = (int)WyHelper.randomWithRange(challenge.getShard().field_73012_v, -7, 7);
        int extraOffset3 = (int)WyHelper.randomWithRange(challenge.getShard().field_73012_v, -5, 5);
        boolean blocksVsDummies = challenge.getRNG().nextBoolean();
        BlockPos neCorner = groundLayer.func_177964_d(15).func_177965_g(15);
        if (blocksVsDummies) {
            blocks.addAll(new BlockPilePart(challenge, Blocks.field_150407_cf.func_176223_P()).buildPart(challenge.getShard(), neCorner.func_177982_a(extraOffset3, 0, extraOffset3)));
            blocks.addAll(new BlockPilePart(challenge, Blocks.field_150407_cf.func_176223_P()).buildPart(challenge.getShard(), neCorner.func_177982_a(extraOffset2, 0, extraOffset2)));
        } else {
            blocks.addAll(new HayDummyPart(challenge).buildPart(challenge.getShard(), neCorner));
            blocks.addAll(new HayDummyPart(challenge).buildPart(challenge.getShard(), neCorner.func_177964_d(5)));
            blocks.addAll(new HayDummyPart(challenge).buildPart(challenge.getShard(), neCorner.func_177964_d(10)));
        }
        BlockPos swCorner = groundLayer.func_177970_e(15).func_177985_f(15);
        blocks.addAll(new BlockPilePart(challenge, Blocks.field_150407_cf.func_176223_P()).buildPart(challenge.getShard(), swCorner.func_177982_a(extraOffset1, 0, extraOffset1)));
        blocks.addAll(new BlockPilePart(challenge, Blocks.field_150407_cf.func_176223_P()).buildPart(challenge.getShard(), swCorner.func_177982_a(extraOffset2, 0, extraOffset2)));
        BlockPos seCorner = groundLayer.func_177970_e(10).func_177965_g(20);
        if (!blocksVsDummies) {
            blocks.addAll(new HayDummyPart(challenge).buildPart(challenge.getShard(), seCorner));
            blocks.addAll(new HayDummyPart(challenge).buildPart(challenge.getShard(), seCorner.func_177964_d(5)));
            blocks.addAll(new HayDummyPart(challenge).buildPart(challenge.getShard(), seCorner.func_177964_d(10)));
        }
        int wallHeight = 5;
        int wallWidth = 5;
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), groundLayer.func_177965_g(26), 5, 5, 60, Blocks.field_196696_di.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), groundLayer.func_177985_f(26), 5, 5, 60, Blocks.field_196696_di.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), groundLayer.func_177964_d(26), 60, 5, 5, Blocks.field_196696_di.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.createCenteredFilledCube((World)challenge.getShard(), groundLayer.func_177970_e(26), 60, 5, 5, Blocks.field_196696_di.func_176223_P(), 0, null));
        BlockPos wallLayer = groundLayer.func_177981_b(5);
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), wallLayer.func_177965_g(28).func_177964_d(29), wallLayer.func_177965_g(28).func_177970_e(28), Blocks.field_196696_di.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), wallLayer.func_177965_g(23).func_177964_d(24), wallLayer.func_177965_g(23).func_177970_e(23), Blocks.field_196696_di.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), wallLayer.func_177985_f(29).func_177964_d(29), wallLayer.func_177985_f(29).func_177970_e(28), Blocks.field_196696_di.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), wallLayer.func_177985_f(24).func_177964_d(24), wallLayer.func_177985_f(24).func_177970_e(23), Blocks.field_196696_di.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), wallLayer.func_177970_e(28).func_177965_g(28), wallLayer.func_177970_e(28).func_177985_f(29), Blocks.field_196696_di.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), wallLayer.func_177970_e(23).func_177965_g(23), wallLayer.func_177970_e(23).func_177985_f(24), Blocks.field_196696_di.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), wallLayer.func_177964_d(29).func_177965_g(28), wallLayer.func_177964_d(29).func_177985_f(29), Blocks.field_196696_di.func_176223_P(), 0, null));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), wallLayer.func_177964_d(24).func_177965_g(23), wallLayer.func_177964_d(24).func_177985_f(23), Blocks.field_196696_di.func_176223_P(), 0, null));
        boolean flag1Set = challenge.getRNG().nextBoolean();
        if (flag1Set) {
            BlockPos flag1Pos = wallLayer.func_177984_a().func_177965_g(23).func_177964_d(24);
            blocks.addAll(new FlagPolePart(challenge, 5, CanvasSize.MEDIUM, ModValues.MARINE).buildPart(challenge.getShard(), flag1Pos));
        } else {
            BlockPos flag2Pos = wallLayer.func_177984_a().func_177970_e(23).func_177985_f(24);
            blocks.addAll(new FlagPolePart(challenge, 5, CanvasSize.MEDIUM, ModValues.MARINE).buildPart(challenge.getShard(), flag2Pos));
        }
        BlockPos stairs1Pos = groundLayer.func_177981_b(4).func_177970_e(23).func_177965_g(24);
        BlockPos stairs1Top = stairs1Pos.func_177984_a().func_177976_e().func_177978_c();
        blocks.addAll(new StairsPart(challenge, 3, 5, Blocks.field_150390_bg, Blocks.field_196696_di, Direction.WEST).buildPart(challenge.getShard(), stairs1Pos));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), stairs1Top, stairs1Top.func_177964_d(2), Blocks.field_150350_a.func_176223_P(), 0, null));
        BlockPos stairs2Pos = groundLayer.func_177981_b(4).func_177964_d(24).func_177985_f(24);
        BlockPos stairs2Top = stairs2Pos.func_177984_a().func_177968_d();
        blocks.addAll(new StairsPart(challenge, 3, 5, Blocks.field_150390_bg, Blocks.field_196696_di, Direction.EAST).buildPart(challenge.getShard(), stairs2Pos));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), stairs2Top, stairs2Top.func_177970_e(2), Blocks.field_150350_a.func_176223_P(), 0, null));
        BlockState ironBarsState = (BlockState)((BlockState)Blocks.field_150411_aY.func_176223_P().func_206870_a((Property)FourWayBlock.field_196411_b, (Comparable)Boolean.valueOf(true))).func_206870_a((Property)FourWayBlock.field_196414_y, (Comparable)Boolean.valueOf(true));
        int westDistance = (int)WyHelper.randomWithRange(challenge.getShard().field_73012_v, -5, 20);
        int cage2Spread = (int)WyHelper.randomWithRange(challenge.getShard().field_73012_v, 5, 15);
        int cage3Spread = (int)WyHelper.randomWithRange(challenge.getShard().field_73012_v, 3, 10);
        BlockPos cage1Pos = groundLayer.func_177985_f(westDistance).func_177970_e(24);
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), cage1Pos.func_177977_b(), cage1Pos.func_177977_b().func_177982_a(4, 4, 1), Blocks.field_196858_iR.func_176223_P(), 3, null));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), cage1Pos.func_177978_c().func_177974_f(), cage1Pos.func_177978_c().func_177974_f().func_177982_a(2, 2, 1), Blocks.field_150350_a.func_176223_P(), 3, null));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), cage1Pos.func_177978_c().func_177974_f(), cage1Pos.func_177978_c().func_177974_f().func_177982_a(2, 2, 0), ironBarsState, 3, null));
        BlockPos cage2Pos = cage1Pos.func_177965_g(cage2Spread);
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), cage2Pos.func_177977_b(), cage2Pos.func_177977_b().func_177982_a(4, 4, 1), Blocks.field_196858_iR.func_176223_P(), 3, null));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), cage2Pos.func_177978_c().func_177974_f(), cage2Pos.func_177978_c().func_177974_f().func_177982_a(2, 2, 1), Blocks.field_150350_a.func_176223_P(), 3, null));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), cage2Pos.func_177978_c().func_177974_f(), cage2Pos.func_177978_c().func_177974_f().func_177982_a(2, 2, 0), ironBarsState, 3, null));
        BlockPos cage3Pos = cage2Pos.func_177965_g(cage3Spread);
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), cage3Pos.func_177977_b(), cage3Pos.func_177977_b().func_177982_a(4, 4, 1), Blocks.field_196858_iR.func_176223_P(), 3, null));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), cage3Pos.func_177978_c().func_177974_f(), cage3Pos.func_177978_c().func_177974_f().func_177982_a(2, 2, 1), Blocks.field_150350_a.func_176223_P(), 3, null));
        blocks.addAll(StructuresHelper.fillCube((World)challenge.getShard(), cage3Pos.func_177978_c().func_177974_f(), cage3Pos.func_177978_c().func_177974_f().func_177982_a(2, 2, 0), ironBarsState, 3, null));
        blocks.addAll(new SimpleBasePart(challenge).buildPart(challenge.getShard(), challenge.getArenaPos()));
        return blocks;
    }

    @Override
    public MutableBoundingBox getArenaLimits() {
        return new MutableBoundingBox(-30, -50, -30, 30, 50, 30);
    }

    public static ChallengeArena.SpawnPosition getChallengerSpawnPos(int posId, InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() + 15 - (posId + 1), challenge.getArenaPos().func_177956_o() - 30, challenge.getArenaPos().func_177952_p() + 15);
        return new ChallengeArena.SpawnPosition(pos, 135.0f, 0.0f);
    }

    public static ChallengeArena.SpawnPosition[] getEnemySpawnPos(InProgressChallenge challenge) {
        BlockPos pos = new BlockPos(challenge.getArenaPos().func_177958_n() - 15, challenge.getArenaPos().func_177956_o() - 30, challenge.getArenaPos().func_177952_p() - 15);
        return ChallengesHelper.get4DefaultSpawnPoints(pos, 140.0f);
    }
}

