/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas.parts;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.gen.IWorldGenerationReader;
import net.minecraft.world.gen.feature.BaseTreeFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Features;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaPart;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class JungleBorderPart
extends ArenaPart {
    private final int arenaSizeRadius;

    public JungleBorderPart(InProgressChallenge challenge, int arenaSizeRadius) {
        super(challenge);
        this.arenaSizeRadius = arenaSizeRadius;
    }

    @Override
    public Set<BlockPos> buildPart(ServerWorld world, BlockPos spawnPos) {
        BlockPos pos;
        int randZ;
        int randX;
        double z;
        double x;
        double phi;
        int circleLayer;
        int i;
        HashSet blocks = Sets.newHashSet();
        for (i = 0; i < 4; ++i) {
            circleLayer = 4 + 2 * i;
            for (phi = 0.0; phi <= Math.PI * 2; phi += 0.09817477042468103) {
                x = (double)(this.arenaSizeRadius - circleLayer) * Math.cos(phi) + WyHelper.randomDouble() / 5.0;
                z = (double)(this.arenaSizeRadius - circleLayer) * Math.sin(phi) + WyHelper.randomDouble() / 5.0;
                randX = (int)WyHelper.randomWithRange(world.field_73012_v, -5, 5);
                randZ = (int)WyHelper.randomWithRange(world.field_73012_v, -5, 5);
                pos = spawnPos.func_177963_a(x + (double)randX, 0.0, z + (double)randZ);
                boolean isSmallTree = world.field_73012_v.nextBoolean();
                ConfiguredFeature feature = isSmallTree ? Features.field_243868_bN : Features.field_243871_bQ;
                int maxHeight = isSmallTree ? 15 : 25;
                maxHeight += world.field_73012_v.nextInt(maxHeight / 2);
                blocks.addAll(this.spawnTree(world, pos, feature, maxHeight));
            }
        }
        for (i = 0; i < 6; ++i) {
            circleLayer = 4 + 3 * i;
            for (phi = 0.0; phi <= Math.PI * 2; phi += 0.04908738521234052) {
                x = (double)(this.arenaSizeRadius - circleLayer) * Math.cos(phi) + WyHelper.randomDouble() / 5.0;
                z = (double)(this.arenaSizeRadius - circleLayer) * Math.sin(phi) + WyHelper.randomDouble() / 5.0;
                randX = (int)WyHelper.randomWithRange(world.field_73012_v, -2, 2);
                randZ = (int)WyHelper.randomWithRange(world.field_73012_v, -2, 2);
                pos = spawnPos.func_177963_a(x + (double)randX, 0.0, z + (double)randZ);
                blocks.addAll(this.spawnTree(world, pos, Features.field_243876_bV, 1));
            }
        }
        return blocks;
    }

    private Set<BlockPos> spawnTree(ServerWorld world, BlockPos spawnPos, ConfiguredFeature<?, ?> feature, int maxHeight) {
        if (!(feature.field_222738_b instanceof BaseTreeFeatureConfig)) {
            return new HashSet<BlockPos>();
        }
        HashSet trunkBlocks = new HashSet();
        HashSet foliageBlocks = new HashSet();
        HashSet decoratorBlocks = new HashSet();
        MutableBoundingBox bb = this.getChallenge().getArena().getArenaLimits();
        BaseTreeFeatureConfig config = (BaseTreeFeatureConfig)feature.field_222738_b;
        int trunkHeight = config.field_236678_g_.func_236917_a_(world.field_73012_v);
        int foliageHeight = config.field_236677_f_.func_230374_a_(world.field_73012_v, trunkHeight, config);
        int k = trunkHeight - foliageHeight;
        int foliageRadius = config.field_236677_f_.func_230376_a_(world.field_73012_v, k);
        int minHeight = 5;
        if (maxHeight >= trunkHeight || maxHeight >= minHeight) {
            List list = config.field_236678_g_.func_230382_a_((IWorldGenerationReader)world, world.field_73012_v, maxHeight, spawnPos, trunkBlocks, bb, config);
            list.forEach(foliage -> config.field_236677_f_.func_236752_a_((IWorldGenerationReader)world, world.field_73012_v, config, maxHeight, foliage, foliageHeight, foliageRadius, foliageBlocks, bb));
        }
        if (!(trunkBlocks.isEmpty() || foliageBlocks.isEmpty() || config.field_227370_o_.isEmpty())) {
            ArrayList trunkList = Lists.newArrayList(trunkBlocks);
            ArrayList foliageList = Lists.newArrayList(foliageBlocks);
            trunkList.sort(Comparator.comparingInt(Vector3i::func_177956_o));
            foliageList.sort(Comparator.comparingInt(Vector3i::func_177956_o));
            config.field_227370_o_.forEach(decorator -> decorator.func_225576_a_((ISeedReader)world, world.field_73012_v, trunkList, foliageList, decoratorBlocks, bb));
        }
        HashSet<BlockPos> treeBlocks = new HashSet<BlockPos>();
        treeBlocks.addAll(trunkBlocks);
        treeBlocks.addAll(foliageBlocks);
        treeBlocks.addAll(decoratorBlocks);
        return treeBlocks;
    }
}

