/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.challenges.arenas.parts;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaPart;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;

public class StairsPart
extends ArenaPart {
    private final int width;
    private final int height;
    private final BlockState stairsBlock;
    private final BlockState fillBlock;
    private final Direction direction;

    public StairsPart(InProgressChallenge challenge, int width, int height, Block stairsBlock, Block fillBlock, Direction direction) {
        super(challenge);
        this.width = width;
        this.height = height;
        this.stairsBlock = stairsBlock.func_176223_P();
        if (this.stairsBlock.func_235901_b_((Property)HorizontalBlock.field_185512_D)) {
            this.stairsBlock.func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)direction.func_176734_d());
        }
        this.fillBlock = fillBlock.func_176223_P();
        this.direction = direction;
    }

    @Override
    public Set<BlockPos> buildPart(ServerWorld world, BlockPos spawnPos) {
        HashSet<BlockPos> blocks = new HashSet<BlockPos>();
        int xOffset = this.direction.func_176730_m().func_177958_n();
        int zOffset = this.direction.func_176730_m().func_177952_p();
        for (int i = 1; i < 1 + this.width; ++i) {
            int stairsRowY = 0;
            for (int row = 1; row <= this.height; ++row) {
                for (int j = 1; j <= row; ++j) {
                    BlockPos pos2;
                    if (j == row) {
                        pos2 = spawnPos.func_177982_a(xOffset * j, -stairsRowY, zOffset * j).func_177982_a(zOffset * i, 0, xOffset * i);
                        if (!AbilityHelper.placeBlockIfAllowed((World)world, pos2, this.stairsBlock, 0, null)) continue;
                        blocks.add(pos2);
                        continue;
                    }
                    pos2 = spawnPos.func_177982_a(xOffset * j, -stairsRowY, zOffset * j).func_177982_a(zOffset * i, 0, xOffset * i);
                    if (!AbilityHelper.placeBlockIfAllowed((World)world, pos2, this.fillBlock, 0, null)) continue;
                    blocks.add(pos2);
                }
                ++stairsRowY;
            }
        }
        return blocks;
    }
}

