/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.commands.AbilityArgument;
import xyz.pixelatedw.mineminenomi.api.commands.AbilityGroupArgument;
import xyz.pixelatedw.mineminenomi.api.enums.AbilityCommandGroup;
import xyz.pixelatedw.mineminenomi.commands.Requires;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.events.abilities.AbilityValidationEvents;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.integrations.perms.WyPermissions;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyDebug;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class AbilityCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder, boolean isDedicated) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"ability").requires(Requires.hasEitherPermission(2, WyPermissions.ABILITY_COMMAND_RESET_COOLDOWN, WyPermissions.ABILITY_COMMAND));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"give").requires(Requires.hasPermission(2, WyPermissions.ABILITY_COMMAND))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"ability", (ArgumentType)AbilityArgument.ability()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> AbilityCommand.addAbility((CommandContext<CommandSource>)context, AbilityArgument.getAbility(context, "ability"), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))).executes(context -> AbilityCommand.addAbility((CommandContext<CommandSource>)context, AbilityArgument.getAbility(context, "ability"), AbilityCommand.getDefaultCollection((CommandContext<CommandSource>)context)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"remove").requires(Requires.hasPermission(2, WyPermissions.ABILITY_COMMAND))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"ability", (ArgumentType)new AbilityArgument()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> AbilityCommand.removeAbility((CommandContext<CommandSource>)context, AbilityArgument.getAbility(context, "ability"), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))).executes(context -> AbilityCommand.removeAbility((CommandContext<CommandSource>)context, AbilityArgument.getAbility(context, "ability"), AbilityCommand.getDefaultCollection((CommandContext<CommandSource>)context)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"unlock_group").requires(Requires.hasPermission(2, WyPermissions.ABILITY_COMMAND))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"group", AbilityGroupArgument.abilityGroup()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> AbilityCommand.abilityGroup((CommandContext<CommandSource>)context, (AbilityCommandGroup)((Object)((Object)context.getArgument("group", AbilityCommandGroup.class))), 1, EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))).executes(context -> AbilityCommand.abilityGroup((CommandContext<CommandSource>)context, (AbilityCommandGroup)((Object)((Object)context.getArgument("group", AbilityCommandGroup.class))), 1, AbilityCommand.getDefaultCollection((CommandContext<CommandSource>)context)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"lock_group").requires(Requires.hasPermission(2, WyPermissions.ABILITY_COMMAND))).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"group", AbilityGroupArgument.abilityGroup()).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> AbilityCommand.abilityGroup((CommandContext<CommandSource>)context, (AbilityCommandGroup)((Object)((Object)context.getArgument("group", AbilityCommandGroup.class))), -1, EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))).executes(context -> AbilityCommand.abilityGroup((CommandContext<CommandSource>)context, (AbilityCommandGroup)((Object)((Object)context.getArgument("group", AbilityCommandGroup.class))), -1, AbilityCommand.getDefaultCollection((CommandContext<CommandSource>)context)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"reset_cooldown").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> AbilityCommand.resetCooldown((CommandContext<CommandSource>)context, EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))).executes(context -> AbilityCommand.resetCooldown((CommandContext<CommandSource>)context, AbilityCommand.getDefaultCollection((CommandContext<CommandSource>)context))));
        if (CommonConfig.INSTANCE.hasAwakeningsEnabled()) {
            builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"awaken").requires(Requires.hasPermission(2, WyPermissions.ABILITY_COMMAND))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> AbilityCommand.awakeFruit((CommandContext<CommandSource>)context, EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))).executes(context -> AbilityCommand.awakeFruit((CommandContext<CommandSource>)context, AbilityCommand.getDefaultCollection((CommandContext<CommandSource>)context))));
        }
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static int awakeFruit(CommandContext<CommandSource> context, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            IDevilFruit props;
            props.setAwakenedFruit(!(props = DevilFruitCapability.get((LivingEntity)player)).hasAwakenedFruit());
            AbilityValidationEvents.checkForPossibleFruitAbilities((LivingEntity)player);
            WyNetwork.sendTo(new SSyncDevilFruitPacket(player.func_145782_y(), props), (PlayerEntity)player);
        }
        return 1;
    }

    private static int abilityGroup(CommandContext<CommandSource> context, AbilityCommandGroup group, int op, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
            for (AbilityCore core : group.getAbilities()) {
                if (op == 1) {
                    abilityProps.addUnlockedAbility(core, AbilityUnlock.COMMAND);
                    continue;
                }
                abilityProps.removeUnlockedAbility(core);
            }
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), abilityProps), (PlayerEntity)player);
        }
        return 1;
    }

    private static Collection<ServerPlayerEntity> getDefaultCollection(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return Lists.newArrayList((Object[])new ServerPlayerEntity[]{((CommandSource)context.getSource()).func_197035_h()});
    }

    private static int resetCooldown(CommandContext<CommandSource> context, Collection<ServerPlayerEntity> players) {
        for (ServerPlayerEntity player : players) {
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
            for (IAbility ability : props.getEquippedAbilities()) {
                if (ability == null) continue;
                ability.getComponent(ModAbilityKeys.COOLDOWN).ifPresent(c -> c.stopCooldown((LivingEntity)player));
                if (ability instanceof Ability && !((Ability)ability).isNew && ((Ability)ability).isOnCooldown()) {
                    ((Ability)ability).stopCooldown((PlayerEntity)player);
                }
                ability.getComponent(ModAbilityKeys.STACK).ifPresent(stackComp -> stackComp.revertStacksToDefault((LivingEntity)player, ability));
            }
            hakiProps.setHakiOveruse(0);
        }
        return 1;
    }

    private static int addAbility(CommandContext<CommandSource> context, AbilityCore core, Collection<ServerPlayerEntity> targets) {
        for (ServerPlayerEntity player : targets) {
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            props.addUnlockedAbility(core, AbilityUnlock.COMMAND);
            if (WyDebug.isDebug()) {
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "" + TextFormatting.ITALIC + "[DEBUG] " + core.getLocalizedName().getString() + " unlocked for " + player.func_200200_C_().getString()), Util.field_240973_b_);
            }
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
        }
        return 1;
    }

    private static int removeAbility(CommandContext<CommandSource> context, AbilityCore ability, Collection<ServerPlayerEntity> targets) {
        for (ServerPlayerEntity player : targets) {
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            props.removeUnlockedAbility(ability);
            if (WyDebug.isDebug()) {
                player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "" + TextFormatting.ITALIC + "[DEBUG] " + ability.getUnlocalizedName() + " removed for " + player.func_200200_C_().getString()), Util.field_240973_b_);
            }
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
        }
        return 1;
    }
}

