/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.commands.Requires;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.integrations.perms.WyPermissions;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class DorikiCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"doriki").requires(Requires.hasPermission(2, WyPermissions.DORIKI_COMMAND));
        int min = -CommonConfig.INSTANCE.getDorikiLimit();
        int max = CommonConfig.INSTANCE.getDorikiLimit();
        builder.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)min, (int)max)).executes(context -> DorikiCommand.alterDoriki((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), DorikiCommand.getDefaultCollection((CommandContext<CommandSource>)context)))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197093_b()).executes(context -> DorikiCommand.alterDoriki((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"amount"), EntityArgument.func_197097_b((CommandContext)context, (String)"targets")))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static Collection<Entity> getDefaultCollection(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return Lists.newArrayList((Object[])new Entity[]{((CommandSource)context.getSource()).func_197035_h()});
    }

    private static int alterDoriki(CommandContext<CommandSource> context, int amount, Collection<? extends Entity> targets) throws CommandSyntaxException {
        for (Entity entity : targets) {
            LivingEntity livingTarget;
            IEntityStats entityStatsProps;
            if (!(entity instanceof LivingEntity) || !(entityStatsProps = EntityStatsCapability.get(livingTarget = (LivingEntity)entity)).alterDoriki(amount, StatChangeSource.COMMAND) || !(livingTarget instanceof ServerPlayerEntity)) continue;
            ServerPlayerEntity playerTarget = (ServerPlayerEntity)livingTarget;
            WyNetwork.sendTo(new SSyncEntityStatsPacket(playerTarget.func_145782_y(), entityStatsProps), (PlayerEntity)playerTarget);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "" + (amount > 0 ? "+" : "") + amount + " doriki for " + entity.func_145748_c_().getString()), true);
        }
        return 1;
    }
}

