/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.commands.Requires;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.integrations.perms.WyPermissions;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class ExtolCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"extol").requires(Requires.hasPermission(2, WyPermissions.EXTOL_COMMAND));
        builder.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)LongArgumentType.longArg((long)-999999999L, (long)999999999L)).executes(context -> ExtolCommand.alterExtol((CommandContext<CommandSource>)context, LongArgumentType.getLong((CommandContext)context, (String)"amount"), ExtolCommand.getDefaultCollection((CommandContext<CommandSource>)context)))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> ExtolCommand.alterExtol((CommandContext<CommandSource>)context, LongArgumentType.getLong((CommandContext)context, (String)"amount"), EntityArgument.func_197090_e((CommandContext)context, (String)"targets")))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static Collection<ServerPlayerEntity> getDefaultCollection(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return Lists.newArrayList((Object[])new ServerPlayerEntity[]{((CommandSource)context.getSource()).func_197035_h()});
    }

    private static int alterExtol(CommandContext<CommandSource> context, long amount, Collection<ServerPlayerEntity> targets) throws CommandSyntaxException {
        for (ServerPlayerEntity player : targets) {
            IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
            if (!entityStatsProps.alterExtol(amount, StatChangeSource.COMMAND)) continue;
            WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), entityStatsProps), (PlayerEntity)player);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "" + (amount > 0L ? "+" : "") + amount + " extol for " + player.func_145748_c_().getString()), true);
        }
        return 1;
    }
}

