/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import xyz.pixelatedw.mineminenomi.api.commands.HakiTypeArgument;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.enums.StatChangeSource;
import xyz.pixelatedw.mineminenomi.commands.Requires;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.integrations.perms.WyPermissions;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncHakiDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class HakiExpCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher, @Nullable LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"hakiexp").requires(Requires.hasPermission(2, WyPermissions.HAKIEXP_COMMAND));
        int max = CommonConfig.INSTANCE.getHakiExpLimit();
        builder.then(Commands.func_197056_a((String)"type", HakiTypeArgument.hakiType()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)(-max), (float)max)).executes(context -> HakiExpCommand.alterHakiExp((CommandContext<CommandSource>)context, (HakiType)((Object)((Object)context.getArgument("type", HakiType.class))), FloatArgumentType.getFloat((CommandContext)context, (String)"amount"), HakiExpCommand.getDefaultCollection((CommandContext<CommandSource>)context)))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> HakiExpCommand.alterHakiExp((CommandContext<CommandSource>)context, (HakiType)((Object)((Object)context.getArgument("type", HakiType.class))), FloatArgumentType.getFloat((CommandContext)context, (String)"amount"), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))));
        if (masterBuilder != null) {
            masterBuilder.then((ArgumentBuilder)builder);
        } else {
            dispatcher.register(builder);
        }
    }

    private static Collection<ServerPlayerEntity> getDefaultCollection(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return Lists.newArrayList((Object[])new ServerPlayerEntity[]{((CommandSource)context.getSource()).func_197035_h()});
    }

    private static int alterHakiExp(CommandContext<CommandSource> context, HakiType hakiType, float amount, Collection<ServerPlayerEntity> targets) throws CommandSyntaxException {
        for (ServerPlayerEntity player : targets) {
            IHakiData props = HakiDataCapability.get((LivingEntity)player);
            boolean flag = false;
            if (hakiType == HakiType.BUSOSHOKU) {
                flag = props.alterBusoshokuHakiExp(amount, StatChangeSource.COMMAND);
            } else if (hakiType == HakiType.KENBUNSHOKU) {
                flag = props.alterKenbunshokuHakiExp(amount, StatChangeSource.COMMAND);
            } else if (hakiType == HakiType.HAOSHOKU) {
                flag |= props.alterBusoshokuHakiExp(amount, StatChangeSource.COMMAND);
                flag |= props.alterKenbunshokuHakiExp(amount, StatChangeSource.COMMAND);
            }
            if (!flag) continue;
            WyNetwork.sendTo(new SSyncHakiDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "" + (amount > 0.0f ? "+" : "") + amount + " haki exp for " + player.func_145748_c_().getString()), true);
        }
        return 1;
    }
}

