/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.ryuallosaurus.AllosaurusHeavyPointAbility;
import xyz.pixelatedw.mineminenomi.abilities.ryuallosaurus.AncientBiteAbility;
import xyz.pixelatedw.mineminenomi.abilities.ryuallosaurus.AncientTailSpinAbility;
import xyz.pixelatedw.mineminenomi.abilities.zoumammoth.AncientStompAbility;
import xyz.pixelatedw.mineminenomi.abilities.zoumammoth.AncientSweepAbility;
import xyz.pixelatedw.mineminenomi.abilities.zoumammoth.AncientTrunkShotAbility;
import xyz.pixelatedw.mineminenomi.abilities.zoumammoth.MammothGuardPointAbility;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCore;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityType;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.abilities.IAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.components.BonusOperation;
import xyz.pixelatedw.mineminenomi.api.abilities.components.ContinuousComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.components.CooldownComponent;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncAbilityDataPacket;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SEquipAbilityPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class TestCommand {
    private static AbilityCore<?>[] abilityTestsSet;
    private static UUID abilityTester;
    public static boolean runAbilityTests;
    private static boolean isRunningAbilityTest;
    private static long abilityTestTimer;
    private static int abilityTestIndex;
    private static int abilityTestsErrors;
    private static final HashMap<AbilityCore<?>, IPreTestHook> PRE_TEST_HOOKS;

    private static IPreTestHook requiresMorph(AbilityCore<?> morph) {
        return (entity, ability) -> {
            IAbility abl = TestCommand.setAbilityInSlot(entity, morph, 1);
            abl.use(entity);
        };
    }

    public static void register(LiteralArgumentBuilder<CommandSource> masterBuilder) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"test").requires(source -> source.func_197034_c(0));
        builder.then(Commands.func_197057_a((String)"particles").executes(ctx -> TestCommand.testParticles((CommandContext<CommandSource>)ctx, ((CommandSource)ctx.getSource()).func_197035_h())));
        builder.then(Commands.func_197057_a((String)"abilities").executes(ctx -> TestCommand.testNewAbilityCores((CommandContext<CommandSource>)ctx, ((CommandSource)ctx.getSource()).func_197035_h())));
        builder.then(Commands.func_197057_a((String)"missing_stats").executes(ctx -> TestCommand.testMissingStatDescriptions((CommandContext<CommandSource>)ctx, ((CommandSource)ctx.getSource()).func_197035_h())));
        builder.then(Commands.func_197057_a((String)"unported_abilities").executes(ctx -> TestCommand.testUnportedAbilities((CommandContext<CommandSource>)ctx, ((CommandSource)ctx.getSource()).func_197035_h())));
        masterBuilder.then((ArgumentBuilder)builder);
    }

    private static int testUnportedAbilities(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (AbilityCore core : ModRegistries.ABILITIES.getValues()) {
            Object abl = core.createAbility();
            if (!(abl instanceof Ability) || ((Ability)abl).isNew) continue;
            sb.append("\u00a76" + core.toString() + "\u00a7r\n");
            ++count;
        }
        player.func_145747_a((ITextComponent)new StringTextComponent(sb.toString()), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent(count + " unported abilities"), Util.field_240973_b_);
        float portingPercent = (1.0f - (float)count / (float)ModRegistries.ABILITIES.getValues().size()) * 100.0f;
        player.func_145747_a((ITextComponent)new StringTextComponent("Porting Progress: " + portingPercent + "%"), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent("\u00a72Test Completed"), Util.field_240973_b_);
        return 1;
    }

    private static int testMissingStatDescriptions(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        StringBuilder sb = new StringBuilder();
        int count = 0;
        for (AbilityCore core : ModRegistries.ABILITIES.getValues()) {
            long advancedLines = core.getDescription().stream().filter(line -> !line.isAdvanced()).count();
            if (advancedLines > 0L) continue;
            sb.append("\u00a76" + core.toString() + "\u00a7r\n");
            ++count;
        }
        player.func_145747_a((ITextComponent)new StringTextComponent(sb.toString()), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent(count + " abilities with missing advanced descriptions"), Util.field_240973_b_);
        player.func_145747_a((ITextComponent)new StringTextComponent("\u00a72Test Completed"), Util.field_240973_b_);
        return 1;
    }

    private static int testNewAbilityCores(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        Collection entries = ModRegistries.ABILITIES.getValues();
        EntityStatsCapability.get((LivingEntity)player).setDoriki(10000.0);
        HakiDataCapability.get((LivingEntity)player).setBusoshokuHakiExp(100.0f);
        HakiDataCapability.get((LivingEntity)player).setKenbunshokuHakiExp(100.0f);
        abilityTestsSet = entries.toArray(new AbilityCore[entries.size()]);
        abilityTester = player.func_110124_au();
        runAbilityTests = true;
        isRunningAbilityTest = false;
        abilityTestIndex = 0;
        return 1;
    }

    public static void runAllAbilityTests(LivingEntity entity) {
        block8: {
            if (!runAbilityTests || entity.field_70170_p.field_72995_K) {
                return;
            }
            if (!(entity instanceof PlayerEntity) || !abilityTester.equals(entity.func_110124_au())) {
                return;
            }
            if (isRunningAbilityTest) {
                ++abilityTestTimer;
                return;
            }
            AbilityCore<?> core = abilityTestsSet[abilityTestIndex];
            try {
                IAbilityData props = AbilityDataCapability.get(entity);
                props.clearUnlockedAbilities();
                props.clearEquippedAbilities();
                if (entity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity player = (ServerPlayerEntity)entity;
                    WyNetwork.sendToAllTrackingAndSelf(new SSyncAbilityDataPacket(player.func_145782_y(), props), (Entity)player);
                }
                System.out.println("Executing #" + abilityTestIndex + ": " + core.getUnlocalizedName());
                IAbility abl = TestCommand.setAbilityInSlot(entity, core, 0);
                if (abl == null) {
                    TestCommand.nextAbilityTest(entity, null);
                    return;
                }
                isRunningAbilityTest = true;
                TestCommand.runAbilityTest(entity, abl);
                if (abilityTestIndex >= abilityTestsSet.length) {
                    entity.func_145747_a((ITextComponent)new StringTextComponent("\u00a72Test Completed"), Util.field_240973_b_);
                    runAbilityTests = false;
                    return;
                }
            }
            catch (Exception e) {
                TestCommand.nextAbilityTest(entity, null);
                ++abilityTestsErrors;
                if (e instanceof FileNotFoundException) break block8;
                e.printStackTrace();
            }
        }
    }

    @Nullable
    private static IAbility setAbilityInSlot(LivingEntity entity, AbilityCore<?> core, int slot) {
        Object abl = core.createAbility();
        if (abl == null) {
            return null;
        }
        if (core.getType() == AbilityType.PASSIVE) {
            return null;
        }
        IAbilityData props = AbilityDataCapability.get(entity);
        props.addUnlockedAbility(abl.getCore(), AbilityUnlock.COMMAND);
        props.setEquippedAbility(slot, (IAbility)abl);
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity player = (ServerPlayerEntity)entity;
            WyNetwork.sendToAllTrackingAndSelf(new SEquipAbilityPacket(player.func_145782_y(), slot, abl.getCore()), (Entity)player);
        }
        return abl;
    }

    private static void runAbilityTest(LivingEntity entity, IAbility iability) {
        abilityTestTimer = 0L;
        if (iability instanceof Ability) {
            Optional<ContinuousComponent> contOpt;
            Ability ability = (Ability)iability;
            IPreTestHook hook = PRE_TEST_HOOKS.get(iability.getCore());
            if (hook != null) {
                hook.run(entity, ability);
            }
            ability.use(entity);
            Optional<CooldownComponent> cooldownOpt = iability.getComponent(ModAbilityKeys.COOLDOWN);
            if (cooldownOpt.isPresent()) {
                CooldownComponent comp = cooldownOpt.get();
                comp.getBonusManager().addBonus(UUID.fromString("05d6189f-d191-4c30-b5df-173fb1896e2d"), "Cooldown Test", BonusOperation.MUL, 0.01f);
                comp.addEndEvent(1000, (e, a) -> TestCommand.nextAbilityTest(entity, ability.getCore()));
            }
            if ((contOpt = iability.getComponent(ModAbilityKeys.CONTINUOUS)).isPresent()) {
                ContinuousComponent comp = contOpt.get();
                comp.addTickEvent(1000, (e, a) -> {
                    if (abilityTestTimer > 20L) {
                        comp.stopContinuity(entity);
                    }
                });
            }
            ability.addTickEvent((e, a) -> {
                if (!ability.isContinuous() && !ability.isCharging() && abilityTestTimer > 40L) {
                    TestCommand.nextAbilityTest(entity, ability.getCore());
                }
            });
        }
    }

    private static void nextAbilityTest(LivingEntity entity, @Nullable AbilityCore<?> core) {
        isRunningAbilityTest = false;
        ++abilityTestIndex;
    }

    private static int testParticles(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        HashMap<String, Double> times = new HashMap<String, Double>();
        Collection effects = ModRegistries.PARTICLE_EFFECTS.getValues();
        for (ParticleEffect effect : effects) {
            long now = System.nanoTime();
            WyHelper.spawnParticleEffect(effect, (Entity)player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            double end = (double)(System.nanoTime() - now) / 1000000.0;
            String[] split = ((Object)((Object)effect)).getClass().getCanonicalName().split("\\.");
            times.put(split[split.length - 1], end);
        }
        String[] severities = new String[]{"\u00a77", "\u00a7e", "\u00a74", "\u00a75"};
        StringBuilder sb = new StringBuilder();
        int errs = 0;
        for (Map.Entry time : times.entrySet()) {
            if (!((Double)time.getValue() > 10.0)) continue;
            String severity = severities[(int)Math.min((long)(severities.length - 1), Math.round((Double)time.getValue() / 100.0 * (double)severities.length))];
            sb.append("\u00a76" + (String)time.getKey() + "\u00a7r took " + severity + time.getValue() + "ms\u00a7r\n");
            ++errs;
        }
        if (errs > 0) {
            player.func_145747_a((ITextComponent)new StringTextComponent(sb.toString()), Util.field_240973_b_);
        } else {
            player.func_145747_a((ITextComponent)new StringTextComponent("\u00a72Test Completed"), Util.field_240973_b_);
        }
        return 0;
    }

    static {
        runAbilityTests = false;
        isRunningAbilityTest = false;
        abilityTestTimer = 0L;
        abilityTestIndex = 0;
        abilityTestsErrors = 0;
        PRE_TEST_HOOKS = new HashMap();
        PRE_TEST_HOOKS.put(AncientBiteAbility.INSTANCE, TestCommand.requiresMorph(AllosaurusHeavyPointAbility.INSTANCE));
        PRE_TEST_HOOKS.put(AncientTailSpinAbility.INSTANCE, TestCommand.requiresMorph(AllosaurusHeavyPointAbility.INSTANCE));
        PRE_TEST_HOOKS.put(AncientStompAbility.INSTANCE, TestCommand.requiresMorph(MammothGuardPointAbility.INSTANCE));
        PRE_TEST_HOOKS.put(AncientSweepAbility.INSTANCE, TestCommand.requiresMorph(MammothGuardPointAbility.INSTANCE));
        PRE_TEST_HOOKS.put(AncientTrunkShotAbility.INSTANCE, TestCommand.requiresMorph(MammothGuardPointAbility.INSTANCE));
    }

    @FunctionalInterface
    private static interface IPreTestHook {
        public void run(LivingEntity var1, IAbility var2);
    }
}

