/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.config.options;

import javax.annotation.Nullable;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyRegistry;

public abstract class ConfigOption<T> {
    private ForgeConfigSpec.ConfigValue<T> value;
    protected T defaultValue;
    private String defaultTitle;
    @Nullable
    private String defaultDescription;
    private ITextComponent title;
    private ITextComponent description = StringTextComponent.field_240750_d_;

    public ConfigOption(T defaultValue, String optionName, @Nullable String optionDescription) {
        this.defaultValue = defaultValue;
        this.defaultTitle = optionName;
        optionName = WyHelper.getResourceName(optionName);
        this.title = new TranslationTextComponent(WyRegistry.registerName("gui.mineminenomi.config.option." + optionName, this.defaultTitle));
        if (optionDescription != null) {
            this.defaultDescription = optionDescription;
            this.description = new TranslationTextComponent(WyRegistry.registerName("gui.mineminenomi.config.option." + optionName + ".tooltip", optionDescription));
        }
    }

    protected abstract ForgeConfigSpec.ConfigValue<T> buildValue(ForgeConfigSpec.Builder var1);

    public ForgeConfigSpec.ConfigValue<T> createValue(ForgeConfigSpec.Builder builder) {
        this.value = this.buildValue(builder);
        return this.value;
    }

    public ForgeConfigSpec.ConfigValue<T> getValue() {
        return this.value;
    }

    public T get() {
        return (T)this.value.get();
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public String getTitle() {
        return this.defaultTitle;
    }

    @Nullable
    public String getDescription() {
        return this.defaultDescription;
    }

    public ITextComponent getTitleComponent() {
        return this.title;
    }

    @Nullable
    public ITextComponent getDescriptionComponent() {
        return this.description;
    }
}

