/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.challenges;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.registry.GameRegistry;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.challenges.ArenaStyle;
import xyz.pixelatedw.mineminenomi.api.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataBase;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;

public class ChallengesDataCapability {
    @CapabilityInject(value=IChallengesData.class)
    public static final Capability<IChallengesData> INSTANCE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IChallengesData.class, (Capability.IStorage)new Capability.IStorage<IChallengesData>(){

            public INBT writeNBT(Capability<IChallengesData> capability, IChallengesData instance, Direction side) {
                CompoundNBT props = new CompoundNBT();
                props.func_74757_a("isArenaDirty", instance.isArenaDirty());
                if (instance.getPreviousChallenge() != null) {
                    props.func_74778_a("previousChallenge", instance.getPreviousChallenge().getRegistryName().toString());
                    props.func_74778_a("previousArenaStyle", instance.getPreviousArenaStyle().name());
                    props.func_74778_a("previousArenaClass", instance.getPreviousArenaClass());
                }
                ListNBT challenges = new ListNBT();
                for (int i = 0; i < instance.getChallenges().size(); ++i) {
                    Challenge challenge = instance.getChallenges().get(i);
                    CompoundNBT nbtData = new CompoundNBT();
                    nbtData.func_74778_a("id", challenge.getCore().getRegistryName().toString());
                    challenge.save(nbtData);
                    challenges.add((Object)nbtData);
                }
                props.func_218657_a("challenges", (INBT)challenges);
                return props;
            }

            public void readNBT(Capability<IChallengesData> capability, IChallengesData instance, Direction side, INBT nbt) {
                CompoundNBT props = (CompoundNBT)nbt;
                instance.clearChallenges();
                try {
                    instance.markArenaDirty(props.func_74767_n("isArenaDirty"));
                    ChallengeCore previousChallenge = (ChallengeCore)ModRegistries.CHALLENGES.getValue(new ResourceLocation(props.func_74779_i("previousChallenge")));
                    ArenaStyle previousStyle = ArenaStyle.valueOf(props.func_74779_i("previousArenaStyle"));
                    String previousArenaClass = props.func_74779_i("previousArenaClass");
                    instance.setPreviousChallenge(previousChallenge, previousStyle, previousArenaClass);
                }
                catch (Exception previousChallenge) {
                    // empty catch block
                }
                ListNBT challenges = props.func_150295_c("challenges", 10);
                for (int i = 0; i < challenges.size(); ++i) {
                    try {
                        CompoundNBT nbtData = challenges.func_150305_b(i);
                        ChallengeCore core = (ChallengeCore)GameRegistry.findRegistry(ChallengeCore.class).getValue(new ResourceLocation(nbtData.func_74779_i("id")));
                        if (core == null) continue;
                        Object challenge = core.createChallenge();
                        ((Challenge)challenge).load(nbtData);
                        instance.addChallenge((Challenge)challenge);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }, ChallengesDataBase::new);
    }

    public static IChallengesData get(PlayerEntity entity) {
        IChallengesData data = (IChallengesData)entity.getCapability(INSTANCE, null).orElse((Object)new ChallengesDataBase());
        data.setOwner(entity);
        return data;
    }
}

