/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.entity.gcd;

import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.util.LazyOptional;
import org.apache.commons.lang3.tuple.ImmutablePair;
import xyz.pixelatedw.mineminenomi.data.entity.gcd.GCDBase;
import xyz.pixelatedw.mineminenomi.data.entity.gcd.IGCD;

public class GCDCapability {
    @CapabilityInject(value=IGCD.class)
    public static final Capability<IGCD> INSTANCE = null;

    public static void register() {
        CapabilityManager.INSTANCE.register(IGCD.class, (Capability.IStorage)new Capability.IStorage<IGCD>(){

            public INBT writeNBT(Capability<IGCD> capability, IGCD instance, Direction side) {
                CompoundNBT props = new CompoundNBT();
                props.func_74757_a("onGCD", instance.isOnGCD());
                return props;
            }

            public void readNBT(Capability<IGCD> capability, IGCD instance, Direction side, INBT nbt) {
                CompoundNBT props = (CompoundNBT)nbt;
                boolean onGCD = props.func_74767_n("onGCD");
                if (onGCD) {
                    instance.startGCD();
                }
            }
        }, () -> new GCDBase());
    }

    public static LazyOptional<IGCD> getLazy(LivingEntity entity) {
        LazyOptional lazyGCD = entity.getCapability(INSTANCE, null);
        lazyGCD.ifPresent(data -> data.setOwner(entity));
        return lazyGCD;
    }

    public static IGCD get(LivingEntity entity) {
        LazyOptional lazyGCD = entity.getCapability(INSTANCE, null);
        lazyGCD.ifPresent(data -> data.setOwner(entity));
        return (IGCD)lazyGCD.orElse(null);
    }

    public static ImmutablePair<Integer, Integer> getGCD(LivingEntity entity) {
        return GCDCapability.getLazy(entity).map(gcd -> ImmutablePair.of((Object)gcd.getCurrentGCD(), (Object)gcd.getDefaultGCD())).orElse(ImmutablePair.of(null, null));
    }

    public static boolean isOnGCD(LivingEntity entity) {
        return GCDCapability.getLazy(entity).map(gcd -> gcd.isOnGCD()).orElse(false);
    }

    public static void startGCD(LivingEntity entity) {
        GCDCapability.getLazy(entity).ifPresent(IGCD::startGCD);
    }

    public static void tickGCD(LivingEntity entity) {
        GCDCapability.getLazy(entity).ifPresent(IGCD::tickGCD);
    }
}

