/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.functions;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.api.DFEncyclopediaEntry;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModLootTypes;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SetFruitClueFunction
extends LootFunction {
    protected SetFruitClueFunction(ILootCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        AkumaNoMiItem fruit = WyHelper.shuffle(new ArrayList<AkumaNoMiItem>(ModValues.DEVIL_FRUITS)).stream().findFirst().orElse(null);
        if (fruit != null) {
            DFEncyclopediaEntry template = fruit.getRandomElements((IWorld)context.func_202879_g());
            Optional<Object> shape = Optional.empty();
            Optional<Object> baseColor = Optional.empty();
            Optional<Object> stemColor = Optional.empty();
            int maxRolls = 2;
            if (context.func_216032_b().nextInt(100) < 10) {
                maxRolls = 3;
            }
            int rolls = 1 + context.func_216032_b().nextInt(maxRolls);
            for (int i = 0; i < rolls; ++i) {
                int rand = context.func_216032_b().nextInt(3);
                if (rand == 0) {
                    shape = template.getShape();
                    continue;
                }
                if (rand == 1) {
                    baseColor = template.getBaseColor();
                    continue;
                }
                stemColor = template.getStemColor();
            }
            String key = fruit.getFruitKey();
            CompoundNBT nbt = stack.func_190925_c("fruitClues");
            nbt.func_74778_a("key", key);
            if (shape.isPresent()) {
                nbt.func_74768_a("shape", ((Integer)shape.get()).intValue());
            }
            if (baseColor.isPresent()) {
                nbt.func_74768_a("baseColor", ((Color)baseColor.get()).getRGB());
            }
            if (stemColor.isPresent()) {
                nbt.func_74768_a("stemColor", ((Color)stemColor.get()).getRGB());
            }
            stack.func_200302_a((ITextComponent)new TranslationTextComponent(ModI18n.ITEM_FRUIT_CLUE));
            stack.func_190920_e(1);
        }
        return stack;
    }

    public LootFunctionType func_230425_b_() {
        return ModLootTypes.FRUIT_CLUE;
    }

    public static LootFunction.Builder<?> builder() {
        return SetFruitClueFunction.func_215860_a(condition -> new SetFruitClueFunction((ILootCondition[])condition));
    }

    public static class Serializer
    extends LootFunction.Serializer<SetFruitClueFunction> {
        public void serialize(JsonObject object, SetFruitClueFunction functionClazz, JsonSerializationContext serializationContext) {
            super.func_230424_a_(object, (LootFunction)functionClazz, serializationContext);
        }

        public SetFruitClueFunction deserialize(JsonObject object, JsonDeserializationContext deserializationContext, ILootCondition[] conditionsIn) {
            return new SetFruitClueFunction(conditionsIn);
        }
    }
}

