/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.functions;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootFunction;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.conditions.ILootCondition;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xyz.pixelatedw.mineminenomi.api.ModRegistries;
import xyz.pixelatedw.mineminenomi.api.challenges.ChallengeCore;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.init.ModLootTypes;

public class UnlockChallengesFunction
extends LootFunction {
    private ChallengeCore<?>[] unlocks;

    protected UnlockChallengesFunction(ILootCondition[] conditions, ChallengeCore<?>[] unlocks) {
        super(conditions);
        this.unlocks = unlocks;
    }

    protected ItemStack func_215859_a(ItemStack stack, LootContext context) {
        Entity entity = (Entity)context.func_216031_c(LootParameters.field_216281_a);
        if (entity != null && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            IChallengesData props = ChallengesDataCapability.get(player);
            for (ChallengeCore<?> core : this.unlocks) {
                if (core == null) continue;
                props.addChallenge(core);
            }
            stack.func_200302_a((ITextComponent)new StringTextComponent("_rewards"));
            stack.func_196082_o().func_74768_a("_unlocksAmount", this.unlocks.length);
            ListNBT unlocksNbt = new ListNBT();
            for (ChallengeCore<?> core : this.unlocks) {
                if (core == null) continue;
                StringNBT stringNbt = StringNBT.func_229705_a_((String)core.getLocalizedTitle().getString());
                unlocksNbt.add((Object)stringNbt);
            }
            stack.func_196082_o().func_218657_a("_unlocks", (INBT)unlocksNbt);
        }
        return stack;
    }

    public LootFunctionType func_230425_b_() {
        return ModLootTypes.UNLOCK_CHALLENGES;
    }

    public static LootFunction.Builder<?> builder(ChallengeCore<?> ... unlocks) {
        return UnlockChallengesFunction.func_215860_a(condition -> new UnlockChallengesFunction((ILootCondition[])condition, unlocks));
    }

    public static class Serializer
    extends LootFunction.Serializer<UnlockChallengesFunction> {
        public void serialize(JsonObject object, UnlockChallengesFunction func, JsonSerializationContext context) {
            super.func_230424_a_(object, (LootFunction)func, context);
            JsonArray unlocks = new JsonArray();
            for (ChallengeCore core : func.unlocks) {
                if (core == null) continue;
                unlocks.add(core.getRegistryName().toString());
            }
            object.add("unlocks", (JsonElement)unlocks);
        }

        public UnlockChallengesFunction deserialize(JsonObject object, JsonDeserializationContext context, ILootCondition[] cond) {
            JsonArray unlocksJson = JSONUtils.func_151213_a((JsonObject)object, (String)"unlocks", (JsonArray)new JsonArray());
            ChallengeCore[] unlocksId = new ChallengeCore[unlocksJson.size()];
            for (int i = 0; i < unlocksId.length; ++i) {
                ResourceLocation id = new ResourceLocation(JSONUtils.func_151206_a((JsonElement)unlocksJson.get(i), (String)("unlocks[" + i + "]")));
                unlocksId[i] = (ChallengeCore)ModRegistries.CHALLENGES.getValue(id);
            }
            return new UnlockChallengesFunction(cond, unlocksId);
        }
    }
}

