/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.data.world;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import xyz.pixelatedw.mineminenomi.api.OneFruitEntry;
import xyz.pixelatedw.mineminenomi.api.events.onefruit.LostDevilFruitEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.config.AbilitiesConfig;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;

public class OFPWWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "mineminenomi-ofpw";
    private List<OneFruitEntry> oneFruit = new ArrayList<OneFruitEntry>();

    public OFPWWorldData() {
        super(IDENTIFIER);
    }

    @Nullable
    public static OFPWWorldData get() {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            return (OFPWWorldData)ServerLifecycleHooks.getCurrentServer().func_241755_D_().func_217481_x().func_215752_a(OFPWWorldData::new, IDENTIFIER);
        }
        return null;
    }

    public CompoundNBT func_189551_b(CompoundNBT nbt) {
        if (!((CommonConfig.OneFruitPerWorldLogic)AbilitiesConfig.ONE_FRUIT_PER_WORLD.get()).equals(CommonConfig.OneFruitPerWorldLogic.NONE)) {
            ListNBT oneFruitList = new ListNBT();
            if (this.oneFruit.size() > 0) {
                for (OneFruitEntry entry : this.oneFruit) {
                    CompoundNBT entryNBT = entry.save();
                    oneFruitList.add((Object)entryNBT);
                }
            }
            nbt.func_218657_a("oneFruitList", (INBT)oneFruitList);
        }
        return nbt;
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT oneFruit = nbt.func_150295_c("oneFruitList", 10);
        this.oneFruit.clear();
        for (int i = 0; i < oneFruit.size(); ++i) {
            CompoundNBT entryNBT = oneFruit.func_150305_b(i);
            OneFruitEntry entry = OneFruitEntry.from(entryNBT);
            this.oneFruit.add(entry);
        }
    }

    public List<OneFruitEntry> getOneFruitEntries() {
        return this.oneFruit;
    }

    @Nullable
    public OneFruitEntry getOneFruitEntry(ResourceLocation key) {
        Optional<OneFruitEntry> oneFruit = this.oneFruit.stream().filter(entry -> entry.getKey().equals((Object)key)).findFirst();
        if (oneFruit.isPresent()) {
            return oneFruit.get();
        }
        return null;
    }

    public boolean isFruitAvailable(AkumaNoMiItem item) {
        return this.isFruitAvailable(item.getRegistryName());
    }

    public boolean isFruitAvailable(ResourceLocation id) {
        Optional<OneFruitEntry> oneFruitEntry = this.oneFruit.stream().filter(entry -> entry.getKey().equals((Object)id)).findFirst();
        if (!oneFruitEntry.isPresent()) {
            return true;
        }
        return oneFruitEntry.isPresent() && oneFruitEntry.get().getStatus() == OneFruitEntry.Status.LOST;
    }

    public boolean isFruitInWorld(ResourceLocation key) {
        return this.oneFruit.stream().anyMatch(entry -> entry.getKey().equals((Object)key) && entry.getStatus() != OneFruitEntry.Status.LOST);
    }

    public boolean isFruitInUse(ResourceLocation key) {
        return this.oneFruit.stream().anyMatch(entry -> entry.getKey().equals((Object)key) && entry.getStatus() == OneFruitEntry.Status.IN_USE);
    }

    public boolean isFruitDuped(ResourceLocation key, UUID uuid) {
        return this.oneFruit.stream().anyMatch(entry -> {
            boolean keyCheck = entry.getKey().equals((Object)key) && entry.getStatus() != OneFruitEntry.Status.LOST;
            boolean ownerCheck = entry.getOwner().isPresent() && !entry.getOwner().get().equals(uuid);
            return keyCheck && ownerCheck;
        });
    }

    private boolean addOneFruit(ResourceLocation key, @Nullable UUID uuid, OneFruitEntry.Status status) {
        return this.addOneFruit(key, uuid, status, null);
    }

    private boolean addOneFruit(ResourceLocation key, @Nullable UUID uuid, OneFruitEntry.Status status, @Nullable String message) {
        if (key == null || !CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return false;
        }
        if (this.isFruitInWorld(key)) {
            return false;
        }
        OneFruitEntry entry = new OneFruitEntry(key, uuid, status, message);
        this.oneFruit.add(entry);
        this.func_76185_a();
        return true;
    }

    public boolean updateOneFruit(ResourceLocation key, @Nullable UUID uuid, OneFruitEntry.Status status) {
        return this.updateOneFruit(key, uuid, status, null);
    }

    public boolean updateOneFruit(ResourceLocation key, @Nullable UUID uuid, OneFruitEntry.Status status, @Nullable String message) {
        return this.updateOneFruit(key, uuid, status, null, false);
    }

    public boolean updateOneFruit(ResourceLocation key, @Nullable UUID uuid, OneFruitEntry.Status status, @Nullable String message, boolean force) {
        if (key == null || !CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return false;
        }
        Optional<OneFruitEntry> oneFruit = this.oneFruit.stream().filter(entry -> entry.getKey().equals((Object)key)).findFirst();
        if (!oneFruit.isPresent()) {
            this.addOneFruit(key, uuid, status, message);
        } else {
            if (!force) {
                boolean sameOwner;
                boolean bl = sameOwner = oneFruit.get().getOwner().isPresent() && oneFruit.get().getOwner().get().equals(uuid);
                if (!(oneFruit.get().getStatus() != OneFruitEntry.Status.IN_USE || status == OneFruitEntry.Status.LOST && sameOwner)) {
                    return false;
                }
                if (oneFruit.get().getStatus() == OneFruitEntry.Status.INVENTORY && status == OneFruitEntry.Status.DROPPED && !sameOwner) {
                    return false;
                }
                if (oneFruit.get().getStatus() == OneFruitEntry.Status.INVENTORY && status == OneFruitEntry.Status.INVENTORY && !sameOwner) {
                    return false;
                }
                if (oneFruit.get().getStatus() == OneFruitEntry.Status.INVENTORY && status == OneFruitEntry.Status.IN_USE && !sameOwner) {
                    return false;
                }
            }
            if (!Strings.isNullOrEmpty((String)message)) {
                oneFruit.get().setStatusMessage(message);
            }
            oneFruit.get().update(uuid, status);
            this.func_76185_a();
        }
        return true;
    }

    public void lostOneFruit(ResourceLocation key, @Nullable LivingEntity entity, String message) {
        if (key == null || !CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return;
        }
        Optional<OneFruitEntry> oneFruit = this.oneFruit.stream().filter(entry -> entry.getKey().equals((Object)key)).findFirst();
        if (oneFruit.isPresent()) {
            oneFruit.get().setStatusMessage(message);
            oneFruit.get().update(entity != null ? entity.func_110124_au() : null, OneFruitEntry.Status.LOST);
            this.func_76185_a();
            LostDevilFruitEvent lostEvent = new LostDevilFruitEvent(entity, DevilFruitHelper.getDevilFruitItem(oneFruit.get().getKey()), message);
            MinecraftForge.EVENT_BUS.post((Event)lostEvent);
        }
    }

    public void forceUpdateOneFruit(ResourceLocation key) {
        if (key == null || !CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return;
        }
        Optional<OneFruitEntry> oneFruit = this.oneFruit.stream().filter(entry -> entry.getKey().equals((Object)key)).findFirst();
        if (oneFruit.isPresent()) {
            oneFruit.get().forceLastUpdateNow();
            this.func_76185_a();
        }
    }

    public void wipeOneFruitHistory(ResourceLocation key) {
        if (key == null || !CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            return;
        }
        Optional<OneFruitEntry> oneFruit = this.oneFruit.stream().filter(entry -> entry.getKey().equals((Object)key)).findFirst();
        if (oneFruit.isPresent()) {
            oneFruit.get().getHistory().clear();
            this.func_76185_a();
        }
    }
}

