/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEntities;

public class ChakramEntity
extends AbstractArrowEntity
implements IEntityAdditionalSpawnData {
    private ItemStack itemStack;
    private float attackDamage;
    private boolean dealtDamage;
    public int clientSideReturnTickCount;

    public ChakramEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public ChakramEntity(LivingEntity thrower, ItemStack stack) {
        super((EntityType)ModEntities.CHAKRAM.get(), thrower, thrower.field_70170_p);
        this.itemStack = stack.func_77946_l();
    }

    protected void func_70088_a() {
        super.func_70088_a();
    }

    public void func_70071_h_() {
        if (this.field_184552_b > 4) {
            this.dealtDamage = true;
        }
        Entity owner = this.func_234616_v_();
        if ((this.dealtDamage || this.func_203047_q()) && owner != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.field_70170_p.field_72995_K && this.field_70251_a == AbstractArrowEntity.PickupStatus.ALLOWED) {
                    this.func_70099_a(this.func_184550_j(), 0.1f);
                }
                this.func_70106_y();
            } else {
                if (owner instanceof MobEntity && this.func_70068_e(owner) < 3.5 && this.field_70173_aa > 10) {
                    this.func_70106_y();
                }
                this.func_203045_n(true);
                Vector3d vector3d = new Vector3d(owner.func_226277_ct_() - this.func_226277_ct_(), owner.func_226280_cw_() - this.func_226278_cu_(), owner.func_226281_cx_() - this.func_226281_cx_());
                this.func_226288_n_(this.func_226277_ct_(), this.func_226278_cu_() + vector3d.field_72448_b * 0.015, this.func_226281_cx_());
                if (this.field_70170_p.field_72995_K) {
                    this.field_70137_T = this.func_226278_cu_();
                }
                double d0 = 0.1;
                AbilityHelper.setDeltaMovement((Entity)this, this.func_213322_ci().func_186678_a(0.95).func_178787_e(vector3d.func_72432_b().func_186678_a(d0)));
                ++this.clientSideReturnTickCount;
            }
        }
        if (!this.func_189652_ae() && !this.func_203047_q()) {
            Vector3d vector3d4 = this.func_213322_ci();
            this.func_213293_j(vector3d4.field_72450_a, vector3d4.field_72448_b + (double)0.04f, vector3d4.field_72449_c);
        }
        super.func_70071_h_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.func_234616_v_();
        if (entity != null && entity.func_70089_S()) {
            if (entity instanceof ServerPlayerEntity && !entity.func_175149_v()) {
                return true;
            }
            return !entity.func_175149_v();
        }
        return false;
    }

    public ItemStack func_184550_j() {
        return this.itemStack.func_77946_l();
    }

    public ItemStack getItemUsed() {
        return this.itemStack;
    }

    public void setAttackDamage(float damage) {
        this.attackDamage = damage;
    }

    @Nullable
    protected EntityRayTraceResult func_213866_a(Vector3d pStartVec, Vector3d pEndVec) {
        return this.dealtDamage ? null : super.func_213866_a(pStartVec, pEndVec);
    }

    protected void func_213868_a(EntityRayTraceResult pResult) {
        Entity entity1;
        Entity entity = pResult.func_216348_a();
        float damage = this.attackDamage;
        if (entity instanceof LivingEntity && !entity.field_70170_p.field_72995_K) {
            LivingEntity livingentity = (LivingEntity)entity;
            damage += EnchantmentHelper.func_152377_a((ItemStack)this.itemStack, (CreatureAttribute)livingentity.func_70668_bt());
        }
        DamageSource damagesource = DamageSource.func_203096_a((Entity)this, (Entity)((entity1 = this.func_234616_v_()) == null ? this : entity1));
        this.dealtDamage = true;
        SoundEvent soundevent = SoundEvents.field_203268_ij;
        if (entity.func_70097_a(damagesource, damage)) {
            if (entity.func_200600_R() == EntityType.field_200803_q) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.func_184548_a(livingentity1);
            }
        }
        AbilityHelper.setDeltaMovement((Entity)this, this.func_213322_ci().func_216372_d(-0.01, -0.1, -0.01));
        this.func_184185_a(soundevent, 1.0f, 1.5f);
    }

    protected SoundEvent func_213867_k() {
        return SoundEvents.field_203269_ik;
    }

    public void func_70100_b_(PlayerEntity pEntity) {
        Entity entity = this.func_234616_v_();
        if (entity == null || entity.func_110124_au() == pEntity.func_110124_au()) {
            super.func_70100_b_(pEntity);
        }
    }

    public void func_70037_a(CompoundNBT pCompound) {
        super.func_70037_a(pCompound);
        if (pCompound.func_150297_b("Item", 10)) {
            this.itemStack = ItemStack.func_199557_a((CompoundNBT)pCompound.func_74775_l("Item"));
        }
        this.dealtDamage = pCompound.func_74767_n("DealtDamage");
    }

    public void func_213281_b(CompoundNBT pCompound) {
        super.func_213281_b(pCompound);
        pCompound.func_218657_a("Item", (INBT)this.itemStack.func_77955_b(new CompoundNBT()));
        pCompound.func_74757_a("DealtDamage", this.dealtDamage);
    }

    public void func_225516_i_() {
        if (this.field_70251_a != AbstractArrowEntity.PickupStatus.ALLOWED) {
            super.func_225516_i_();
        }
    }

    protected float func_203044_p() {
        return 0.99f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double pX, double pY, double pZ) {
        return true;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeItemStack(this.itemStack, false);
        buffer.writeInt(this.func_234616_v_() != null ? this.func_234616_v_().func_145782_y() : -1);
    }

    public void readSpawnData(PacketBuffer data) {
        this.itemStack = data.func_150791_c();
        int ownerId = data.readInt();
        if (ownerId >= 0) {
            this.func_212361_a(this.field_70170_p.func_73045_a(ownerId));
        }
    }
}

