/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import java.util.function.Predicate;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.OneTwoJangoAbility;
import xyz.pixelatedw.mineminenomi.api.challenges.InProgressChallenge;
import xyz.pixelatedw.mineminenomi.api.challenges.OPBossEntity;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhase;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ClimbOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.TauntTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ThrowChakramsGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.OneTwoJangoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiImbuingWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.GeppoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.KamieWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.SoruWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.phases.SimplePhase;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModNPCGroups;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.weapons.ChakramItem;

public class JangoEntity
extends OPBossEntity<JangoEntity> {
    private NPCPhase<JangoEntity> standardPhase = new SimplePhase<JangoEntity>("Standard Phase", this);
    private NPCPhase<JangoEntity> tauntPhase = new SimplePhase<JangoEntity>("Taunt Phase", this);

    public JangoEntity(EntityType type, World world) {
        super(type, world);
    }

    public JangoEntity(InProgressChallenge challenge) {
        super((EntityType)ModEntities.JANGO.get(), challenge);
    }

    @Override
    public void initBoss() {
        ItemStack headStack = ((Item)ModArmors.WIDE_BRIM_HAT.get()).func_190903_i();
        headStack.func_190925_c("display").func_74768_a("color", 3364244);
        this.func_184201_a(EquipmentSlotType.HEAD, headStack);
        this.func_184201_a(EquipmentSlotType.MAINHAND, ((ChakramItem)ModWeapons.CHAKRAM.get()).func_190903_i());
        if (this.isDifficultyHardOrAbove()) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, ((ChakramItem)ModWeapons.CHAKRAM.get()).func_190903_i());
        }
    }

    @Override
    public void initStats() {
        ExtendedWorldData worldData = ExtendedWorldData.get();
        this.entityStats.setFaction(ModValues.PIRATE);
        this.entityStats.setRace(ModValues.HUMAN);
        worldData.addTemporaryCrewMember(ModNPCGroups.BLACK_CAT_PIRATES, (LivingEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new ClimbOutOfHoleGoal((MobEntity)this));
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.entityStats.setDoriki(1000.0);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(40.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(4.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(4.0);
        } else {
            this.entityStats.setDoriki(10000.0);
            this.hakiCapability.setBusoshokuHakiExp(100.0f);
            this.hakiCapability.setKenbunshokuHakiExp(100.0f);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.PUNCH_DAMAGE.get()).func_111128_a(3.0);
            this.func_110148_a(Attributes.field_233823_f_).func_111128_a(3.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(5.0);
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a(250.0);
            this.func_110148_a(Attributes.field_233826_i_).func_111128_a(20.0);
            this.func_110148_a(Attributes.field_233827_j_).func_111128_a(4.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(10.0);
            this.func_110148_a(Attributes.field_233825_h_).func_111128_a(6.0);
        }
    }

    @Override
    public void initGoals() {
        MobsHelper.addBasicNPCGoals(this);
        OneTwoJangoWrapperGoal oneTwoJangoWrapper = new OneTwoJangoWrapperGoal((MobEntity)this);
        this.standardPhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
        this.standardPhase.addGoal(1, oneTwoJangoWrapper);
        Predicate<LivingEntity> canDash = entity -> !((OneTwoJangoAbility)oneTwoJangoWrapper.getAbility()).isCharging();
        this.getPhaseManager().setPhase(this.standardPhase);
        if (this.getChallengeInfo().isDifficultyStandard()) {
            this.standardPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 400.0f, 1.5f).setCanUseTest(canDash));
            this.standardPhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 450.0f, 2.0f).setCanUseTest(canDash));
            this.standardPhase.addGoal(2, new ThrowChakramsGoal((MobEntity)this, 200));
            ((OneTwoJangoAbility)oneTwoJangoWrapper.getAbility()).setAffectSelf(true);
        } else {
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new BusoshokuHakiImbuingWrapperGoal((MobEntity)this));
            this.standardPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 200.0f, 2.5f).setCanUseTest(canDash));
            this.standardPhase.addGoal(0, new DashDodgeTargetGoal((MobEntity)this, 250.0f, 2.5f).setCanUseTest(canDash));
            this.standardPhase.addGoal(1, new SoruWrapperGoal((MobEntity)this));
            this.standardPhase.addGoal(1, new GeppoWrapperGoal((MobEntity)this));
            this.standardPhase.addGoal(1, new KamieWrapperGoal((MobEntity)this));
            this.standardPhase.addGoal(2, new ThrowChakramsGoal((MobEntity)this, 100));
            this.tauntPhase.addGoal(0, new TauntTargetGoal((MobEntity)this));
            this.tauntPhase.addGoal(0, new DashDodgeProjectilesGoal((MobEntity)this, 20.0f, 4.0f));
            this.tauntPhase.addGoal(0, new KamieWrapperGoal((MobEntity)this));
            this.tauntPhase.addGoal(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true).setMoveTowardsTarget(false));
            this.tauntPhase.addGoal(1, new DashDodgeTargetGoal((MobEntity)this, 60.0f, 4.0f));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 60.0).func_233815_a_(Attributes.field_233821_d_, (double)0.31f).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233818_a_, 150.0).func_233815_a_(Attributes.field_233825_h_, 5.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.func_70638_az().func_70089_S() && this.isDifficultyHardOrAbove()) {
            if (this.standardPhase.isActive(this) && this.func_70638_az().func_70644_a((Effect)ModEffects.UNCONSCIOUS.get()) && GoalUtil.hasHealthAbovePercentage((LivingEntity)this, 70.0)) {
                this.getPhaseManager().setPhase(this.tauntPhase);
            } else if (this.tauntPhase.isActive(this) && !this.func_70638_az().func_70644_a((Effect)ModEffects.UNCONSCIOUS.get())) {
                this.getPhaseManager().setPhase(this.standardPhase);
            }
        }
    }
}

