/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.GoroProjectiles;
import xyz.pixelatedw.mineminenomi.renderers.entities.LightningBallEntityRenderer;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class LightningDischargeEntity
extends Entity {
    public List<LightningBallEntityRenderer.LightningRendererPropieties> entities = new ArrayList<LightningBallEntityRenderer.LightningRendererPropieties>();
    protected static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> ALIVE_TICKS = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> LIGHTNING_LENGTH = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> LIGHTNING_DENSITY = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> LIGHTNING_DETAIL = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> ALPHA = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> RENDER_MODE = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> OUTLINE_COLOR = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> OUTLINE_ALPHA = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> IS_SPLIT = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> UPDATE_RATE = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> SKIP_SEGMENTS = EntityDataManager.func_187226_a(LightningDischargeEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Color DEFAULT_COLOR = WyHelper.hexToRGB("#F0EC7155");

    public LightningDischargeEntity(World worldIn) {
        super((EntityType)GoroProjectiles.LIGHTNING_BALL.get(), worldIn);
    }

    public LightningDischargeEntity(EntityType entityType, World world) {
        super(entityType, world);
        this.field_70158_ak = true;
    }

    public LightningDischargeEntity(Entity entity, double posX, double posY, double posZ, float rotationYaw, float rotationPitch) {
        this((EntityType)GoroProjectiles.LIGHTNING_BALL.get(), entity.field_70170_p);
        this.setOwner(entity.func_110124_au());
        this.func_70012_b(posX, posY, posZ, rotationYaw, rotationPitch);
    }

    public long getSeed() {
        return new Random().nextLong();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.getOwnerId().isPresent()) {
            this.func_70106_y();
            return;
        }
        if (this.getAliveTicks() > 0 && this.field_70173_aa >= this.getAliveTicks()) {
            this.func_70106_y();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0 * Entity.func_184183_bd();
        return distance < d0 * d0;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, Optional.empty());
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.2f));
        this.field_70180_af.func_187214_a(ALIVE_TICKS, (Object)-1);
        this.field_70180_af.func_187214_a(LIGHTNING_LENGTH, (Object)Float.valueOf(1.0f));
        this.field_70180_af.func_187214_a(LIGHTNING_DENSITY, (Object)8);
        this.field_70180_af.func_187214_a(LIGHTNING_DETAIL, (Object)6);
        this.field_70180_af.func_187214_a(IS_SPLIT, (Object)false);
        this.field_70180_af.func_187214_a(UPDATE_RATE, (Object)5);
        this.field_70180_af.func_187214_a(SKIP_SEGMENTS, (Object)0);
        this.field_70180_af.func_187214_a(COLOR, (Object)DEFAULT_COLOR.getRGB());
        this.field_70180_af.func_187214_a(ALPHA, (Object)77);
        this.field_70180_af.func_187214_a(OUTLINE_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(OUTLINE_ALPHA, (Object)0);
        this.field_70180_af.func_187214_a(RENDER_MODE, (Object)0);
    }

    protected void func_70037_a(CompoundNBT compound) {
    }

    protected void func_213281_b(CompoundNBT compound) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void setSkipSegments(int skip) {
        this.field_70180_af.func_187227_b(SKIP_SEGMENTS, (Object)skip);
    }

    public void setOwner(@Nullable UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.ofNullable(uuid));
    }

    public void setUpdateRate(int updateRate) {
        this.field_70180_af.func_187227_b(UPDATE_RATE, (Object)updateRate);
    }

    public void setSplit() {
        this.field_70180_af.func_187227_b(IS_SPLIT, (Object)true);
    }

    public void setRenderTransparent() {
        this.field_70180_af.func_187227_b(RENDER_MODE, (Object)1);
    }

    public void setDetails(int detail) {
        this.field_70180_af.func_187227_b(LIGHTNING_DETAIL, (Object)detail);
    }

    public void setDensity(int density) {
        this.field_70180_af.func_187227_b(LIGHTNING_DENSITY, (Object)density);
    }

    public void setSize(float size) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(size));
    }

    public void setColor(Color color) {
        this.field_70180_af.func_187227_b(COLOR, (Object)color.getRGB());
        this.field_70180_af.func_187227_b(ALPHA, (Object)color.getAlpha());
    }

    public void setOutlineColor(Color color) {
        this.field_70180_af.func_187227_b(OUTLINE_COLOR, (Object)color.getRGB());
        this.field_70180_af.func_187227_b(OUTLINE_ALPHA, (Object)color.getAlpha());
    }

    public void setLightningLength(float size) {
        this.field_70180_af.func_187227_b(LIGHTNING_LENGTH, (Object)Float.valueOf(size));
    }

    public int getSkipSegmnets() {
        return (Integer)this.field_70180_af.func_187225_a(SKIP_SEGMENTS);
    }

    public Optional<UUID> getOwnerId() {
        return (Optional)this.field_70180_af.func_187225_a(OWNER);
    }

    public int getUpdateRate() {
        return (Integer)this.field_70180_af.func_187225_a(UPDATE_RATE);
    }

    public boolean isSplit() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SPLIT);
    }

    public boolean isRenderingTransparent() {
        return (Integer)this.field_70180_af.func_187225_a(RENDER_MODE) == 1;
    }

    public int getDetails() {
        return (Integer)this.field_70180_af.func_187225_a(LIGHTNING_DETAIL);
    }

    public int getDensity() {
        return (Integer)this.field_70180_af.func_187225_a(LIGHTNING_DENSITY);
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public int getColor() {
        return (Integer)this.field_70180_af.func_187225_a(COLOR);
    }

    public int getOutlineColor() {
        return (Integer)this.field_70180_af.func_187225_a(OUTLINE_COLOR);
    }

    public int getAlpha() {
        return (Integer)this.field_70180_af.func_187225_a(ALPHA);
    }

    public int getOutlineAlpha() {
        return (Integer)this.field_70180_af.func_187225_a(OUTLINE_ALPHA);
    }

    public float getLightningLength() {
        return ((Float)this.field_70180_af.func_187225_a(LIGHTNING_LENGTH)).floatValue();
    }

    public int getAliveTicks() {
        return (Integer)this.field_70180_af.func_187225_a(ALIVE_TICKS);
    }

    public void setAliveTicks(int ticks) {
        this.field_70180_af.func_187227_b(ALIVE_TICKS, (Object)(ticks > 0 ? ticks + this.field_70173_aa : ticks));
    }
}

