/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityCategory;
import xyz.pixelatedw.mineminenomi.api.enums.NetType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.effects.CaughtInNetEffect;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.NetItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NetEntity
extends ThrowableEntity
implements IEntityAdditionalSpawnData {
    private static final int NET_TIME = 1200;
    private Optional<LivingEntity> thrower = Optional.empty();
    private NetItem netItem;
    private NetType type = NetType.NORMAL;

    public NetEntity(EntityType type, World world) {
        super(type, world);
    }

    private NetEntity(EntityType type, World world, @Nullable LivingEntity thrower, NetItem netItem) {
        super(type, world);
        this.thrower = Optional.ofNullable(thrower);
        this.netItem = netItem;
        this.type = netItem.getNetType();
    }

    public static NetEntity createNormalNet(World world, @Nullable LivingEntity thrower) {
        return new NetEntity((EntityType)ModEntities.ROPE_NET.get(), world, thrower, (NetItem)ModItems.ROPE_NET.get());
    }

    public static NetEntity createKairosekiNet(World world, @Nullable LivingEntity thrower) {
        return new NetEntity((EntityType)ModEntities.KAIROSEKI_NET.get(), world, thrower, (NetItem)ModItems.KAIROSEKI_NET.get());
    }

    public static NetEntity createFromItem(World world, @Nullable LivingEntity thrower, NetItem netItem) {
        NetEntity netEntity = null;
        switch (netItem.getNetType()) {
            case KAIROSEKI: {
                netEntity = NetEntity.createKairosekiNet(world, thrower);
                break;
            }
            default: {
                netEntity = NetEntity.createNormalNet(world, thrower);
            }
        }
        return netEntity;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70027_ad()) {
                this.func_70106_y();
            }
            Vector3i radius = new Vector3i(this.func_174813_aQ().func_216364_b() / 2.0, this.func_174813_aQ().func_216360_c() / 2.0, this.func_174813_aQ().func_216362_d() / 2.0);
            List entityList = WyHelper.getNearbyEntities(this.func_213303_ch(), (IWorld)this.field_70170_p, (double)radius.func_177958_n(), radius.func_177956_o(), radius.func_177952_p(), this.canHitEntity(), Entity.class);
            Entity entityTarget = entityList.stream().findAny().orElse(null);
            if (entityTarget != null) {
                this.func_213868_a(new EntityRayTraceResult(entityTarget));
            }
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        if (!this.func_70089_S()) {
            return;
        }
        if (this.field_70170_p.field_72995_K || this.netItem == null) {
            return;
        }
        if (result.func_216348_a() instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)result.func_216348_a();
            boolean hpCheck = false;
            switch (this.getNetType()) {
                case KAIROSEKI: {
                    hpCheck = living.func_110143_aJ() < 100.0f || (double)living.func_110143_aJ() < WyHelper.percentage(40.0, living.func_110138_aP());
                    break;
                }
                case NORMAL: {
                    hpCheck = living.func_110143_aJ() < 50.0f || (double)living.func_110143_aJ() < WyHelper.percentage(20.0, living.func_110138_aP());
                    break;
                }
            }
            if (!hpCheck) {
                this.destroyAndDropItem(this.func_233580_cy_());
                return;
            }
            if (AbilityHelper.isLogiaBlocking((Entity)this, living) || AbilityHelper.isShieldBlocking(living)) {
                this.destroyAndDropItem(this.func_233580_cy_());
                return;
            }
            for (EffectInstance effectInst : living.func_70651_bq()) {
                if (!(effectInst.func_188419_a() instanceof CaughtInNetEffect)) continue;
                this.destroyAndDropItem(this.func_233580_cy_());
                return;
            }
            living.func_195064_c(new EffectInstance((Effect)this.netItem.getEffect(), 1200, 0));
            this.func_70106_y();
        } else if (result.func_216348_a() instanceof AbilityProjectileEntity) {
            AbilityProjectileEntity projectile = (AbilityProjectileEntity)result.func_216348_a();
            if (this.getNetType() == NetType.KAIROSEKI) {
                boolean isProjectileOfDF = false;
                if (projectile.getParent() != null && projectile.getParent().getCategory() == AbilityCategory.DEVIL_FRUITS) {
                    isProjectileOfDF = true;
                }
                if (isProjectileOfDF) {
                    projectile.func_70106_y();
                    return;
                }
            }
            if (projectile.getDamage() > 5.0f) {
                this.func_70106_y();
            }
        }
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        super.func_230299_a_(result);
        if (this.field_70170_p.field_72995_K || this.netItem == null) {
            return;
        }
        this.destroyAndDropItem(result.func_216350_a());
    }

    protected boolean func_230298_a_(Entity target) {
        if (target instanceof AbilityProjectileEntity) {
            return true;
        }
        return super.func_230298_a_(target);
    }

    private Predicate<Entity> canHitEntity() {
        return target -> target != this;
    }

    private void destroyAndDropItem(BlockPos dropPos) {
        boolean canDrop = true;
        if (this.thrower.isPresent() && this.thrower.get() instanceof PlayerEntity) {
            boolean bl = canDrop = !((PlayerEntity)this.thrower.get()).field_71075_bZ.field_75098_d;
        }
        if (canDrop) {
            ItemEntity itemEntity = new ItemEntity(this.field_70170_p, (double)dropPos.func_177958_n(), (double)(dropPos.func_177956_o() + 1), (double)dropPos.func_177952_p(), this.netItem.func_190903_i());
            this.field_70170_p.func_217376_c((Entity)itemEntity);
        }
        this.func_70106_y();
    }

    public boolean func_241845_aY() {
        return true;
    }

    protected float func_70185_h() {
        return 0.03f;
    }

    public NetType getNetType() {
        return this.type;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.type.ordinal());
    }

    public void readSpawnData(PacketBuffer buffer) {
        int typeId = buffer.readInt();
        this.type = NetType.values()[typeId];
    }
}

