/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.registries.ForgeRegistries;
import xyz.pixelatedw.mineminenomi.api.abilities.Ability;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEntities;

public class PhysicalBodyEntity
extends OPEntity {
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(PhysicalBodyEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private Ability parentAbility = null;

    public PhysicalBodyEntity(EntityType type, World world) {
        super(type, world);
    }

    public PhysicalBodyEntity(World world) {
        this((EntityType)ModEntities.PHYSICAL_BODY.get(), world);
    }

    public void setParentAbility(Ability ability) {
        this.parentAbility = ability;
    }

    public void setOwner(LivingEntity owner) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(owner.func_110124_au()));
        IEntityStats entityStats = EntityStatsCapability.get((LivingEntity)this);
        IEntityStats ownerStats = EntityStatsCapability.get(owner);
        entityStats.setFaction(ownerStats.getFaction());
        entityStats.setRace(ownerStats.getRace());
        ForgeRegistries.ATTRIBUTES.forEach(attr -> {
            if (owner.func_110148_a(attr) != null && this.func_110148_a((Attribute)attr) != null) {
                double val = owner.func_110148_a(attr).func_111125_b();
                this.func_110148_a((Attribute)attr).func_111128_a(val);
            }
        });
        this.func_70606_j(owner.func_110143_aJ());
    }

    @Nullable
    public UUID getOwnerUUID() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? (UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get() : null;
    }

    @Nullable
    public PlayerEntity getOwner() {
        UUID uuid = this.getOwnerUUID();
        if (uuid != null) {
            return this.field_70170_p.func_217371_b(uuid);
        }
        return null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        PlayerEntity owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        owner.func_70097_a(ModDamageSource.OUT_OF_BODY, amount);
        this.func_70606_j(owner.func_110143_aJ());
        return false;
    }

    public void func_70645_a(DamageSource cause) {
        PlayerEntity owner = this.getOwner();
        if (owner == null) {
            return;
        }
        owner.func_70097_a(ModDamageSource.OUT_OF_BODY, owner.func_110138_aP());
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            IAbilityData abilityProps;
            Ability parentAbilityInstance;
            PlayerEntity owner = this.getOwner();
            boolean hasParentAbilityActive = false;
            if (owner != null && (parentAbilityInstance = (abilityProps = AbilityDataCapability.get((LivingEntity)owner)).getEquippedAbility(this.parentAbility)) != null && parentAbilityInstance.isContinuous()) {
                hasParentAbilityActive = true;
                if ((AbilityHelper.isAffectedByWater((LivingEntity)this) || this.func_184218_aH()) && this.getOwner() != null) {
                    parentAbilityInstance.getComponent(ModAbilityKeys.CONTINUOUS).get().stopContinuity((LivingEntity)this.getOwner());
                }
            }
            if (owner == null || !owner.func_70089_S() || this.parentAbility == null || !hasParentAbilityActive) {
                this.func_70106_y();
                return;
            }
        }
        super.func_70071_h_();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, Optional.empty());
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233818_a_, 100.0).func_233815_a_(Attributes.field_233820_c_, 1.0);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_70180_af.func_187225_a(OWNER) != null) {
            compound.func_74778_a("OwnerUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("OwnerUUID"))));
    }

    @Override
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

