/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.util.PriorityEventPool;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.renderers.ArenaSkybox;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class SphereEntity
extends Entity
implements IEntityAdditionalSpawnData {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("mineminenomi", "textures/skyboxes/default.png");
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(SphereEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    @Nullable
    private LivingEntity spawner;
    private Vector3d oldPos;
    private ResourceLocation[] textures = new ResourceLocation[]{DEFAULT_TEXTURE};
    private Color color = Color.WHITE;
    private int animationSpeed = 1;
    private int detailLevel = 8;
    private boolean hasSpawner;
    private boolean isFullWrapping;
    private boolean move = false;
    @OnlyIn(value=Dist.CLIENT)
    private ArenaSkybox cachedSkybox;
    private final PriorityEventPool<ITickEvent> tickEvents = new PriorityEventPool();

    public SphereEntity(EntityType<? extends Entity> type, World world) {
        super(type, world);
    }

    public SphereEntity(World world) {
        this((EntityType<? extends Entity>)((EntityType)ModEntities.SPHERE.get()), world);
    }

    public SphereEntity(World world, LivingEntity spawner) {
        this((EntityType<? extends Entity>)((EntityType)ModEntities.SPHERE.get()), world);
        this.spawner = spawner;
        this.hasSpawner = true;
        this.func_70107_b(spawner.func_226277_ct_(), spawner.func_226278_cu_(), spawner.func_226281_cx_());
    }

    public void setTexture(boolean isFullWrapping, ResourceLocation ... textures) {
        this.textures = textures;
        this.isFullWrapping = isFullWrapping;
    }

    public ResourceLocation[] getTexture() {
        return this.textures;
    }

    public boolean isFullWrapping() {
        return this.isFullWrapping;
    }

    public void setAnimationSpeed(int animationSpeed) {
        this.animationSpeed = animationSpeed;
    }

    public int getAnimationSpeed() {
        return this.animationSpeed;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public void setRadius(float radius) {
        this.func_184212_Q().func_187227_b(RADIUS, (Object)Float.valueOf(radius));
    }

    public float getRadius() {
        return ((Float)this.func_184212_Q().func_187225_a(RADIUS)).floatValue();
    }

    public void setDetailLevel(int detail) {
        this.detailLevel = detail;
    }

    public int getDetailLevel() {
        return this.detailLevel;
    }

    public void addTickEvent(ITickEvent event) {
        this.tickEvents.addEvent(event);
    }

    @OnlyIn(value=Dist.CLIENT)
    public ArenaSkybox getSkybox() {
        if (this.cachedSkybox == null) {
            this.cachedSkybox = new ArenaSkybox();
            this.cachedSkybox.setTexture(this.isFullWrapping, this.textures);
            this.cachedSkybox.setAnimationSpeed(this.animationSpeed);
            this.cachedSkybox.setColor(this.color);
            this.cachedSkybox.setDetailLevel(this.detailLevel);
        }
        this.cachedSkybox.setRadius(this.getRadius());
        return this.cachedSkybox;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(RADIUS, (Object)Float.valueOf(1.0f));
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.oldPos == null) {
            this.oldPos = super.func_213303_ch();
        }
        if (!this.move) {
            if (!super.func_213303_ch().equals((Object)this.oldPos)) {
                super.func_70107_b(this.oldPos.field_72450_a, this.oldPos.field_72448_b, this.oldPos.field_72449_c);
            }
        } else {
            this.oldPos = super.func_213303_ch();
            this.move = false;
        }
        if (this.field_70173_aa % 20 == 0) {
            if (this.hasSpawner && (this.spawner == null || !this.spawner.func_70089_S())) {
                this.func_70106_y();
                return;
            }
            this.tickEvents.dispatch(event -> event.tick(this));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_145770_h(double pX, double pY, double pZ) {
        return true;
    }

    protected void func_213281_b(CompoundNBT tag) {
        tag.func_74757_a("hasSpawner", this.hasSpawner);
        tag.func_74768_a("textures", this.textures.length);
        for (int i = 0; i < this.textures.length; ++i) {
            tag.func_74778_a("texture" + i, this.textures[i].toString());
        }
        tag.func_74757_a("isFullWrapping", this.isFullWrapping);
        tag.func_74768_a("animationSpeed", this.animationSpeed);
        tag.func_74768_a("rgb", this.color.getRGB());
        tag.func_74768_a("alpha", this.color.getAlpha());
        tag.func_74776_a("radius", ((Float)this.func_184212_Q().func_187225_a(RADIUS)).floatValue());
        tag.func_74768_a("detailLevel", this.detailLevel);
        tag.func_74757_a("move", this.move);
    }

    protected void func_70037_a(CompoundNBT tag) {
        this.hasSpawner = tag.func_74767_n("hasSpawner");
        int texs = tag.func_74762_e("textures");
        this.textures = new ResourceLocation[texs];
        for (int i = 0; i < texs; ++i) {
            ResourceLocation tex = ResourceLocation.func_208304_a((String)tag.func_74779_i("texture" + i));
            this.textures[i] = tex != null ? tex : DEFAULT_TEXTURE;
        }
        this.isFullWrapping = tag.func_74767_n("isFullWrapping");
        this.animationSpeed = tag.func_74762_e("animationSpeed");
        this.color = WyHelper.intToRGB(tag.func_74762_e("rgb"), tag.func_74762_e("alpha"));
        this.func_184212_Q().func_187227_b(RADIUS, (Object)Float.valueOf(tag.func_74760_g("radius")));
        this.detailLevel = tag.func_74762_e("detailLevel");
        this.move = tag.func_74767_n("move");
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.textures.length);
        for (int i = 0; i < this.textures.length; ++i) {
            buffer.func_192572_a(this.textures[i]);
        }
        buffer.writeBoolean(this.isFullWrapping);
        buffer.writeInt(this.animationSpeed);
        buffer.writeInt(this.color.getRGB());
        buffer.writeInt(this.color.getAlpha());
        buffer.writeInt(this.detailLevel);
        buffer.writeBoolean(this.move);
    }

    public void readSpawnData(PacketBuffer buffer) {
        int textures = buffer.readInt();
        this.textures = new ResourceLocation[textures];
        for (int i = 0; i < textures; ++i) {
            this.textures[i] = buffer.func_192575_l();
        }
        this.isFullWrapping = buffer.readBoolean();
        this.animationSpeed = buffer.readInt();
        int rgb = buffer.readInt();
        int alpha = buffer.readInt();
        this.color = WyHelper.intToRGB(rgb, alpha);
        this.detailLevel = buffer.readInt();
        this.move = buffer.readBoolean();
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @FunctionalInterface
    public static interface ITickEvent {
        public void tick(SphereEntity var1);
    }
}

