/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LilyPadBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.Pose;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncStrikerCrewPacket;
import xyz.pixelatedw.mineminenomi.particles.data.SimpleParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyNetwork;

public class StrikerEntity
extends Entity {
    private static final DataParameter<Float> FUEL = EntityDataManager.func_187226_a(StrikerEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final float MAX_FUEL = 100.0f;
    private static final float SPEED = 0.07f;
    private static final float BACKWARDS_SPEED = -0.014f;
    private static final float TURN_SPEED = 0.5f;
    private static final byte HURT_EVENT = 100;
    private static final AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private float deltaRotation;
    private int lerpSteps;
    private double lerpX;
    private double lerpY;
    private double lerpZ;
    private double lerpYRot;
    private double lerpXRot;
    private double waterLevel;
    private Status status;
    private Status oldStatus;
    private double lastYd;
    private float invFriction;
    private float landFriction;
    @Nullable
    private UUID lastRiderUUID;
    @Nullable
    private PlayerEntity lastRider;
    private float damage;
    private int hurtTime;
    @Nullable
    private Crew crew;

    public StrikerEntity(World level) {
        super((EntityType)ModEntities.STRIKER.get(), level);
        this.field_70156_m = true;
    }

    public StrikerEntity(EntityType<?> type, World level) {
        super(type, level);
        this.field_70156_m = true;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(FUEL, (Object)Float.valueOf(0.0f));
    }

    public float getEyeHeightForge(Pose pose, EntitySize size) {
        return size.field_220316_b;
    }

    public boolean func_241849_j(Entity entity) {
        return StrikerEntity.canVehicleCollide(this, entity);
    }

    public static boolean canVehicleCollide(Entity vehicle, Entity entity) {
        return (entity.func_241845_aY() || entity.func_70104_M()) && !vehicle.func_184223_x(entity);
    }

    public boolean func_241845_aY() {
        return true;
    }

    public boolean func_70104_M() {
        return true;
    }

    public boolean func_70067_L() {
        return this.func_70089_S();
    }

    public boolean shouldRiderSit() {
        return this.func_184179_bs() == null || !(this.func_184179_bs() instanceof LivingEntity) || !this.isMeraUser((LivingEntity)this.func_184179_bs());
    }

    protected boolean func_225502_at_() {
        return false;
    }

    public double func_70042_X() {
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof LivingEntity && this.isMeraUser((LivingEntity)this.func_184179_bs())) {
            return 0.7;
        }
        return 0.15;
    }

    public Direction func_184172_bi() {
        return this.func_174811_aO().func_176746_e();
    }

    private void tickLerp() {
        if (this.func_184186_bw()) {
            this.lerpSteps = 0;
            this.func_213312_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
        }
        if (this.lerpSteps > 0) {
            double d0 = this.func_226277_ct_() + (this.lerpX - this.func_226277_ct_()) / (double)this.lerpSteps;
            double d1 = this.func_226278_cu_() + (this.lerpY - this.func_226278_cu_()) / (double)this.lerpSteps;
            double d2 = this.func_226281_cx_() + (this.lerpZ - this.func_226281_cx_()) / (double)this.lerpSteps;
            double d3 = MathHelper.func_76138_g((double)(this.lerpYRot - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.lerpSteps);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.lerpXRot - (double)this.field_70125_A) / (double)this.lerpSteps);
            --this.lerpSteps;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
    }

    public void func_70071_h_() {
        this.oldStatus = this.status;
        this.status = this.getStatus();
        super.func_70071_h_();
        this.tickLerp();
        if (!(this.func_184179_bs() == null || this.lastRiderUUID != null && this.lastRiderUUID.equals(this.func_184179_bs().func_110124_au()))) {
            this.lastRiderUUID = this.func_184179_bs().func_110124_au();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.consumeFuel();
        }
        if (this.getHurtTime() > 0) {
            this.setHurtTime(this.getHurtTime() - 1);
        }
        if (this.getDamage() > 0.0f) {
            this.setDamage(this.getDamage() - 1.0f);
        }
        if (this.func_184186_bw()) {
            this.invFriction = 0.05f;
            double gravity = this.func_189652_ae() ? 0.0 : (double)-0.04f;
            double d2 = 0.0;
            if (this.oldStatus == Status.IN_AIR && this.status != Status.IN_AIR && this.status != Status.ON_LAND) {
                this.waterLevel = this.func_226283_e_(1.0);
                this.func_70107_b(this.func_226277_ct_(), (double)(this.getWaterLevelAbove() - this.func_213302_cg()) + 0.101, this.func_226281_cx_());
                AbilityHelper.setDeltaMovement(this, this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0));
                this.lastYd = 0.0;
                this.status = Status.IN_WATER;
            } else if (this.status == Status.IN_WATER) {
                d2 = (this.waterLevel - this.func_226278_cu_()) / (double)this.func_213302_cg();
                this.invFriction = 0.9f;
            } else if (this.status == Status.UNDER_FLOWING_WATER) {
                gravity = -7.0E-4;
                this.invFriction = 0.9f;
            } else if (this.status == Status.UNDER_WATER) {
                d2 = 0.01f;
                this.invFriction = 0.45f;
            } else if (this.status == Status.IN_AIR) {
                this.invFriction = 0.9f;
            } else if (this.status == Status.ON_LAND) {
                this.invFriction = this.landFriction;
                if (this.func_184179_bs() instanceof PlayerEntity) {
                    this.landFriction /= 2.0f;
                }
            }
            Vector3d motion = this.func_213322_ci();
            AbilityHelper.setDeltaMovement(this, motion.field_72450_a * (double)this.invFriction, motion.field_72448_b + gravity, motion.field_72449_c * (double)this.invFriction);
            this.deltaRotation *= this.invFriction;
            if (d2 > 0.0) {
                motion = this.func_213322_ci();
                AbilityHelper.setDeltaMovement(this, motion.field_72450_a, (motion.field_72448_b + d2 * 0.061) * 0.75, motion.field_72449_c);
            }
            if (this.func_184179_bs() != null && this.func_184179_bs() instanceof LivingEntity && this.hasFuel((LivingEntity)this.func_184179_bs())) {
                this.controlVehicle();
            }
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        } else {
            AbilityHelper.setDeltaMovement(this, Vector3d.field_186680_a);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 100: {
                this.hurtTime = 10;
            }
        }
        super.func_70103_a(id);
    }

    private void consumeFuel() {
        Entity passanger = this.func_184179_bs();
        if (passanger != null && passanger instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)passanger;
            if (this.isMeraUser((LivingEntity)player)) {
                return;
            }
            float speed = 0.0f;
            if (player.field_191988_bg > 0.0f) {
                speed = 0.07f;
            } else if (player.field_191988_bg < 0.0f) {
                speed = -0.014f;
            }
            float fuel = this.getFuel() - Math.abs(speed / 4.0f);
            fuel = MathHelper.func_76131_a((float)fuel, (float)0.0f, (float)100.0f);
            this.setFuel(fuel);
        }
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float f = 0.0f;
            float f1 = (float)((this.field_70128_L ? (double)0.01f : this.func_70042_X()) + passenger.func_70033_W());
            if (this.func_184188_bt().size() > 1) {
                int i = this.func_184188_bt().indexOf(passenger);
                f = i == 0 ? 0.2f : -0.6f;
                if (passenger instanceof AnimalEntity) {
                    f = (float)((double)f + 0.2);
                }
            }
            Vector3d vector3d = new Vector3d((double)f, 0.0, 0.0).func_178785_b(-this.field_70177_z * ((float)Math.PI / 180) - 1.5707964f);
            passenger.func_70107_b(this.func_226277_ct_() + vector3d.field_72450_a, this.func_226278_cu_() + (double)f1, this.func_226281_cx_() + vector3d.field_72449_c);
            passenger.field_70177_z += this.deltaRotation;
            passenger.func_70034_d(passenger.func_70079_am() + this.deltaRotation);
            this.clampRotation(passenger);
            if (passenger instanceof AnimalEntity && this.func_184188_bt().size() > 1) {
                int j = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
                passenger.func_181013_g(((AnimalEntity)passenger).field_70761_aq + (float)j);
                passenger.func_70034_d(passenger.func_70079_am() + (float)j);
            }
        }
    }

    private Status getStatus() {
        Status status = this.isUnderwater();
        if (status != null) {
            this.waterLevel = this.func_174813_aQ().field_72337_e;
            return status;
        }
        if (this.checkInWater()) {
            return Status.IN_WATER;
        }
        float f = this.getGroundFriction();
        if (f > 0.0f) {
            this.landFriction = f;
            return Status.ON_LAND;
        }
        return Status.IN_AIR;
    }

    private void controlVehicle() {
        if (this.func_184207_aI()) {
            Entity passanger = this.func_184179_bs();
            if (passanger == null || !(passanger instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)passanger;
            if (player.field_70702_br > 0.0f) {
                this.deltaRotation -= 0.5f;
            } else if (player.field_70702_br < 0.0f) {
                this.deltaRotation += 0.5f;
            }
            this.field_70177_z += this.deltaRotation;
            float speed = 0.0f;
            if (player.field_191988_bg > 0.0f) {
                speed = 0.07f;
            } else if (player.field_191988_bg < 0.0f) {
                speed = -0.014f;
            }
            AbilityHelper.setDeltaMovement(this, this.func_213322_ci().func_72441_c((double)(MathHelper.func_76126_a((float)(-this.field_70177_z * ((float)Math.PI / 180))) * speed), 0.0, (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * speed)));
            if (this.isMeraUser((LivingEntity)player)) {
                for (int i = 0; i < 5; ++i) {
                    double offsetX = WyHelper.randomDouble() / 2.5;
                    double offsetY = WyHelper.randomDouble() / 4.0;
                    double offsetZ = WyHelper.randomDouble() / 2.5;
                    SimpleParticleData proj = new SimpleParticleData((ParticleType)ModParticleTypes.MERA.get());
                    proj.setLife(5);
                    proj.setSize(3.0f);
                    player.field_70170_p.func_195594_a((IParticleData)proj, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 0.5 + offsetY, this.func_226281_cx_() + offsetZ, 0.0, 0.0, 0.0);
                }
            }
            if (speed > 0.0f) {
                double yRot = MathHelper.func_76138_g((double)((double)this.field_70177_z * (Math.PI / 180))) + 0.8;
                double dist = 1.5;
                double xp = dist * Math.cos(yRot) - dist * Math.sin(yRot);
                double zp = dist * Math.cos(yRot) + dist * Math.sin(yRot);
                for (int i = 0; i < 20; ++i) {
                    double offsetX = WyHelper.randomDouble() / 2.5 - xp;
                    double offsetY = WyHelper.randomDouble() / 2.5;
                    double offsetZ = WyHelper.randomDouble() / 2.5 - zp;
                    SimpleParticleData proj = new SimpleParticleData((ParticleType)ModParticleTypes.MERA.get());
                    proj.setLife(10);
                    proj.setSize(4.0f);
                    proj.setMotion(-this.func_213322_ci().field_72450_a, -this.func_213322_ci().field_72448_b, -this.func_213322_ci().field_72449_c);
                    player.field_70170_p.func_195594_a((IParticleData)proj, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 0.5 + offsetY, this.func_226281_cx_() + offsetZ, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public ActionResultType func_184230_a(PlayerEntity player, Hand hand) {
        ItemStack heldItem = player.func_184614_ca();
        if (hand.equals((Object)Hand.OFF_HAND)) {
            return ActionResultType.PASS;
        }
        if (player.func_213453_ef() && !player.field_70170_p.field_72995_K) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.INFO_FUEL_LEFT, new Object[]{String.format("%.2f", Float.valueOf(this.getFuel())) + "%"}), Util.field_240973_b_);
            return ActionResultType.CONSUME;
        }
        if (heldItem != null && !heldItem.func_190926_b() && heldItem.func_77973_b().equals(((Block)ModBlocks.FLAME_DIAL.get()).func_199767_j()) && this.getFuel() < 100.0f) {
            while (this.getFuel() < 100.0f && !heldItem.func_190926_b()) {
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                this.setFuel(this.getFuel() + 25.0f);
            }
            return ActionResultType.CONSUME;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (player.func_184220_m((Entity)this)) {
                Crew crew = ExtendedWorldData.get().getCrewWithMember(player.func_110124_au());
                if (crew != null) {
                    this.crew = crew;
                    WyNetwork.sendToAllTracking(new SSyncStrikerCrewPacket(this, crew), this);
                }
                return ActionResultType.CONSUME;
            }
            return ActionResultType.PASS;
        }
        return ActionResultType.SUCCESS;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            boolean flag;
            this.field_70170_p.func_72960_a((Entity)this, (byte)100);
            this.setDamage(this.getDamage() + amount * 10.0f);
            this.func_70018_K();
            boolean bl = flag = source.func_76346_g() instanceof PlayerEntity && ((PlayerEntity)source.func_76346_g()).field_71075_bZ.field_75098_d;
            if (flag || this.getDamage() > 30.0f) {
                if (!flag && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
                    this.func_199701_a_(((Item)ModItems.STRIKER.get()).func_190903_i());
                }
                this.func_70106_y();
            }
            return true;
        }
        return true;
    }

    public void func_203002_i(boolean isDownwards) {
    }

    private boolean isMeraUser(LivingEntity entity) {
        IDevilFruit props = DevilFruitCapability.get(entity);
        return props.hasDevilFruit(ModAbilities.MERA_MERA_NO_MI);
    }

    private boolean hasFuel(LivingEntity entity) {
        return this.isMeraUser(entity) ? true : this.getFuel() > 0.0f;
    }

    public float getGroundFriction() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        AxisAlignedBB axisalignedbb1 = new AxisAlignedBB(axisalignedbb.field_72340_a, axisalignedbb.field_72338_b - 0.001, axisalignedbb.field_72339_c, axisalignedbb.field_72336_d, axisalignedbb.field_72338_b, axisalignedbb.field_72334_f);
        int i = MathHelper.func_76128_c((double)axisalignedbb1.field_72340_a) - 1;
        int j = MathHelper.func_76143_f((double)axisalignedbb1.field_72336_d) + 1;
        int k = MathHelper.func_76128_c((double)axisalignedbb1.field_72338_b) - 1;
        int l = MathHelper.func_76143_f((double)axisalignedbb1.field_72337_e) + 1;
        int i1 = MathHelper.func_76128_c((double)axisalignedbb1.field_72339_c) - 1;
        int j1 = MathHelper.func_76143_f((double)axisalignedbb1.field_72334_f) + 1;
        VoxelShape voxelshape = VoxelShapes.func_197881_a((AxisAlignedBB)axisalignedbb1);
        float f = 0.0f;
        int k1 = 0;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int l1 = i; l1 < j; ++l1) {
            for (int i2 = i1; i2 < j1; ++i2) {
                int j2 = (l1 != i && l1 != j - 1 ? 0 : 1) + (i2 != i1 && i2 != j1 - 1 ? 0 : 1);
                if (j2 == 2) continue;
                for (int k2 = k; k2 < l; ++k2) {
                    if (j2 > 0 && (k2 == k || k2 == l - 1)) continue;
                    blockpos$mutable.func_181079_c(l1, k2, i2);
                    BlockState blockstate = this.field_70170_p.func_180495_p((BlockPos)blockpos$mutable);
                    if (blockstate.func_177230_c() instanceof LilyPadBlock || !VoxelShapes.func_197879_c((VoxelShape)blockstate.func_196952_d((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable).func_197751_a((double)l1, (double)k2, (double)i2), (VoxelShape)voxelshape, (IBooleanFunction)IBooleanFunction.field_223238_i_)) continue;
                    f += blockstate.getSlipperiness((IWorldReader)this.field_70170_p, (BlockPos)blockpos$mutable, (Entity)this);
                    ++k1;
                }
            }
        }
        return f / (float)k1;
    }

    public float getWaterLevelAbove() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72337_e - this.lastYd));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        block0: for (int k1 = k; k1 < l; ++k1) {
            float f = 0.0f;
            for (int l1 = i; l1 < j; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(l1, k1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) {
                        f = Math.max(f, fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable));
                    }
                    if (f >= 1.0f) continue block0;
                }
            }
            if (!(f < 1.0f)) continue;
            return (float)blockpos$mutable.func_177956_o() + f;
        }
        return l + 1;
    }

    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a)) continue;
                    float f = (float)l1 + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable);
                    this.waterLevel = Math.max((double)f, this.waterLevel);
                    flag |= axisalignedbb.field_72338_b < (double)f;
                }
            }
        }
        return flag;
    }

    @Nullable
    private Status isUnderwater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        double d0 = axisalignedbb.field_72337_e + 0.001;
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72337_e);
        int l = MathHelper.func_76143_f((double)d0);
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (int k1 = i; k1 < j; ++k1) {
            for (int l1 = k; l1 < l; ++l1) {
                for (int i2 = i1; i2 < j1; ++i2) {
                    blockpos$mutable.func_181079_c(k1, l1, i2);
                    FluidState fluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$mutable);
                    if (!fluidstate.func_206884_a((ITag)FluidTags.field_206959_a) || !(d0 < (double)((float)blockpos$mutable.func_177956_o() + fluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$mutable)))) continue;
                    if (!fluidstate.func_206889_d()) {
                        return Status.UNDER_FLOWING_WATER;
                    }
                    flag = true;
                }
            }
        }
        return flag ? Status.UNDER_WATER : null;
    }

    public void func_70108_f(Entity entity) {
        if (entity instanceof StrikerEntity) {
            if (entity.func_174813_aQ().field_72338_b < this.func_174813_aQ().field_72337_e) {
                super.func_70108_f(entity);
            }
        } else if (entity.func_174813_aQ().field_72338_b <= this.func_174813_aQ().field_72338_b) {
            super.func_70108_f(entity);
        }
    }

    protected void clampRotation(Entity pEntityToUpdate) {
        pEntityToUpdate.func_181013_g(this.field_70177_z);
        float f = MathHelper.func_76142_g((float)(pEntityToUpdate.field_70177_z - this.field_70177_z));
        float f1 = MathHelper.func_76131_a((float)f, (float)-105.0f, (float)105.0f);
        pEntityToUpdate.field_70126_B += f1 - f;
        pEntityToUpdate.field_70177_z += f1 - f;
        pEntityToUpdate.func_70034_d(pEntityToUpdate.field_70177_z);
    }

    protected void func_145775_I() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        BlockPos blockpos = new BlockPos(axisalignedbb.field_72340_a + 0.001, axisalignedbb.field_72338_b + 0.001, axisalignedbb.field_72339_c + 0.001);
        BlockPos blockpos1 = new BlockPos(axisalignedbb.field_72336_d - 0.001, axisalignedbb.field_72337_e - 0.001, axisalignedbb.field_72334_f - 0.001);
        BlockPos.Mutable pos = new BlockPos.Mutable();
        if (this.field_70170_p.func_175707_a(blockpos, blockpos1)) {
            for (int i = blockpos.func_177958_n(); i <= blockpos1.func_177958_n(); ++i) {
                for (int j = blockpos.func_177956_o(); j <= blockpos1.func_177956_o(); ++j) {
                    for (int k = blockpos.func_177952_p(); k <= blockpos1.func_177952_p(); ++k) {
                        pos.func_181079_c(i, j, k);
                        BlockState state = this.field_70170_p.func_180495_p((BlockPos)pos);
                        if (state.func_177230_c() != Blocks.field_196651_dG) continue;
                        this.field_70170_p.func_225521_a_((BlockPos)pos, true, (Entity)this);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_184190_l(Entity entity) {
        this.clampRotation(entity);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return ((Item)ModItems.STRIKER.get()).func_199767_j().func_190903_i();
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        AxisAlignedBB aabb = super.func_184177_bl();
        aabb = aabb.func_72314_b(0.0, 3.0, 0.0);
        return aabb;
    }

    protected void func_70037_a(CompoundNBT nbt) {
        Crew crew;
        this.setFuel(nbt.func_74760_g("fuel"));
        if (nbt.func_186855_b("lastRiderId")) {
            this.lastRiderUUID = nbt.func_186857_a("lastRiderId");
        }
        if (nbt.func_150297_b("crew", 10) && (crew = Crew.from(nbt.func_74775_l("crew"))) != null) {
            this.crew = crew;
        }
    }

    protected void func_213281_b(CompoundNBT nbt) {
        nbt.func_74776_a("fuel", this.getFuel());
        if (this.getLastRiderId() != null) {
            nbt.func_186854_a("lastRiderId", this.getLastRiderId());
        }
        if (this.crew != null) {
            nbt.func_218657_a("crew", (INBT)this.crew.write());
        }
    }

    @Nullable
    public UUID getLastRiderId() {
        return this.lastRiderUUID;
    }

    @Nullable
    public PlayerEntity getLastRider() {
        if (this.lastRider == null && this.lastRiderUUID != null) {
            this.lastRider = this.field_70170_p.func_217371_b(this.lastRiderUUID);
        }
        return this.lastRider;
    }

    public void setFuel(float fuel) {
        this.field_70180_af.func_187227_b(FUEL, (Object)Float.valueOf(fuel));
    }

    public float getFuel() {
        return ((Float)this.field_70180_af.func_187225_a(FUEL)).floatValue();
    }

    public float getDamage() {
        return this.damage;
    }

    public void setDamage(float damage) {
        this.damage = damage;
    }

    public int getHurtTime() {
        return this.hurtTime;
    }

    public void setHurtTime(int hurtTime) {
        this.hurtTime = hurtTime;
    }

    @Nullable
    public Crew getCrew() {
        return this.crew;
    }

    public void setCrew(Crew crew) {
        this.crew = crew;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Status {
        IN_WATER,
        UNDER_WATER,
        UNDER_FLOWING_WATER,
        ON_LAND,
        IN_AIR;

    }
}

