/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.EndGatewayTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import xyz.pixelatedw.mineminenomi.abilities.WeaponThrowAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntities;

public class ThrowingWeaponEntity
extends AbilityProjectileEntity {
    private ItemStack itemStack = ItemStack.field_190927_a;
    private boolean isStuck;
    private float zRot;

    public ThrowingWeaponEntity(EntityType type, World world) {
        super(type, world);
    }

    public ThrowingWeaponEntity(World world, LivingEntity thrower) {
        this(world, thrower, thrower.func_184614_ca().func_77946_l());
    }

    public ThrowingWeaponEntity(World world, LivingEntity thrower, ItemStack stack) {
        super((EntityType)ModEntities.THROWING_WEAPON.get(), world, thrower, WeaponThrowAbility.INSTANCE);
        this.itemStack = stack;
        float damage = ItemsHelper.getItemDamage(this.itemStack);
        if (damage < 10.0f) {
            damage = 10.0f;
        }
        this.setDamage(damage);
        this.setMaxLife(1200);
        this.setAffectedByImbuing();
        this.setCanGetStuckInGround();
        this.setPassThroughEntities();
        this.setEntityCollisionSize(1.5, 1.0, 1.5);
        this.onBlockImpactEvent = this::onBlockImpactEvent;
    }

    @Override
    public void func_70071_h_() {
        VoxelShape voxelshape;
        BlockState blockstate;
        BlockPos blockpos;
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, arg_0 -> ((ThrowingWeaponEntity)this).func_230298_a_(arg_0));
        boolean flag = false;
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.BLOCK) {
            blockpos = ((BlockRayTraceResult)raytraceresult).func_216350_a();
            blockstate = this.field_70170_p.func_180495_p(blockpos);
            if (blockstate.func_203425_a(Blocks.field_150427_aO)) {
                this.func_181015_d(blockpos);
                flag = true;
            } else if (blockstate.func_203425_a(Blocks.field_185775_db)) {
                TileEntity tileentity = this.field_70170_p.func_175625_s(blockpos);
                if (tileentity instanceof EndGatewayTileEntity && EndGatewayTileEntity.func_242690_a((Entity)this)) {
                    ((EndGatewayTileEntity)tileentity).func_195496_a((Entity)this);
                }
                flag = true;
            }
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.ENTITY) {
            this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            AbilityHelper.setDeltaMovement((Entity)this, 0.0, 0.0, 0.0);
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.MISS && !flag && !ForgeEventFactory.onProjectileImpact((ThrowableEntity)this, (RayTraceResult)raytraceresult)) {
            this.onModHit(raytraceresult);
        }
        if (!(blockstate = this.field_70170_p.func_180495_p(blockpos = this.func_233580_cy_())).isAir((IBlockReader)this.field_70170_p, blockpos) && !(voxelshape = blockstate.func_196952_d((IBlockReader)this.field_70170_p, blockpos)).func_197766_b()) {
            Vector3d vector3d1 = this.func_213303_ch();
            for (AxisAlignedBB axisalignedbb : voxelshape.func_197756_d()) {
                if (!axisalignedbb.func_186670_a(blockpos).func_72318_a(vector3d1)) continue;
                this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 1.0, this.func_226281_cx_());
                this.isStuck = true;
                break;
            }
        }
        if (!this.isStuck) {
            this.zRot = this.field_70173_aa * 50 % 360;
            Vector3d motion = this.func_213322_ci();
            double motionX = motion.field_72450_a;
            double motionY = motion.field_72448_b;
            double motionZ = motion.field_72449_c;
            float horDist = MathHelper.func_76133_a((double)ThrowingWeaponEntity.func_213296_b((Vector3d)motion));
            double newPosX = this.func_226277_ct_() + motionX;
            double newPosY = this.func_226278_cu_() + motionY;
            double newPosZ = this.func_226281_cx_() + motionZ;
            this.field_70177_z = (float)(MathHelper.func_181159_b((double)motionX, (double)motionZ) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b((double)motionY, (double)horDist) * 57.2957763671875);
            this.field_70125_A = ThrowingWeaponEntity.func_234614_e_((float)this.field_70127_C, (float)this.field_70125_A);
            this.field_70177_z = ThrowingWeaponEntity.func_234614_e_((float)this.field_70126_B, (float)this.field_70177_z);
            AbilityHelper.setDeltaMovement((Entity)this, motion.func_186678_a((double)0.99f));
            motion = this.func_213322_ci();
            AbilityHelper.setDeltaMovement((Entity)this, motion.field_72450_a, motion.field_72448_b - (double)this.func_70185_h(), motion.field_72449_c);
            this.func_70107_b(newPosX, newPosY, newPosZ);
        } else {
            boolean shouldFall;
            this.tickDespawn();
            this.zRot = -170.0f;
            if (!this.field_70170_p.field_72995_K && (shouldFall = this.field_70170_p.func_226664_a_(new AxisAlignedBB(this.func_213303_ch(), this.func_213303_ch()).func_186662_g(0.5)))) {
                this.isStuck = false;
                Vector3d vector3d = this.func_213322_ci();
                AbilityHelper.setDeltaMovement((Entity)this, vector3d.func_216372_d((double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f), (double)(this.field_70146_Z.nextFloat() * 0.2f)));
            }
            if (!this.field_70170_p.field_72995_K) {
                AxisAlignedBB aabb = new AxisAlignedBB(this.func_233580_cy_()).func_72314_b(1.5, 1.5, 1.5);
                ArrayList nearbyLivings = new ArrayList();
                nearbyLivings.addAll(this.field_70170_p.func_175647_a(LivingEntity.class, aabb, null));
                for (LivingEntity living : nearbyLivings) {
                    boolean isOwner = this.func_234616_v_() != null && this.func_234616_v_().func_110124_au() == living.func_110124_au();
                    if (!isOwner || !ItemsHelper.giveItemStackToEntity(living, this.itemStack, EquipmentSlotType.MAINHAND)) continue;
                    this.func_70106_y();
                }
            }
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        this.isStuck = true;
    }

    public ItemStack getItem() {
        return this.itemStack;
    }

    @Override
    protected float func_70185_h() {
        return 0.05f;
    }

    public float getRotation() {
        return this.zRot;
    }

    @Override
    public void writeSpawnData(PacketBuffer buffer) {
        super.writeSpawnData(buffer);
        buffer.func_150788_a(this.itemStack);
    }

    @Override
    public void readSpawnData(PacketBuffer buffer) {
        super.readSpawnData(buffer);
        this.itemStack = buffer.func_150791_c();
    }
}

