/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.BlackLegPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.BrawlerPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.MinkPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.abilities.fishmankarate.FishmanPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.api.ServerOPBossInfo;
import xyz.pixelatedw.mineminenomi.api.entities.ai.NPCPhaseManager;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.poi.INotoriousTarget;
import xyz.pixelatedw.mineminenomi.api.poi.TrackedNPC;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.config.AbilitiesConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeProjectilesGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.DashDodgeTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.JumpOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.GapCloserGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.KnifeThrowingGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.blackleg.AntiMannerKickCourseWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.blackleg.ConcasseWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.blackleg.ExtraHachisWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.blackleg.PartyTableKickCourseWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.electro.EleclawWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.electro.ElectricalLunaWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.electro.ElectricalMissileWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.electro.ElectricalTempestaWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.KachiageHaisokuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.KarakusagawaraSeikenWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.MizuOsuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.MizuShuryudanWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.MurasameWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.SamehadaShoteiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.fishman.UchimizuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiFullbodyHardeningWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiInternalDestructionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.HaoshokuHakiInfusionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.KenbunshokuHakiFutureSightWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.GeppoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.KamieWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.RankyakuWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.ShiganWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.SoruWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.rokushiki.TekkaiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.KaenBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.KemuriBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.NemuriBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.RenpatsuNamariBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.SakuretsuSabotenBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.TetsuBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.sniper.TokuyoAburaBoshiWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.weapons.ModGunItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class NotoriousEntity
extends OPEntity
implements INotoriousTarget {
    private static final ResourceLocation[] STYLES = new ResourceLocation[]{ModValues.SWORDSMAN, ModValues.BRAWLER, ModValues.BLACK_LEG, ModValues.SNIPER};
    private static final ResourceLocation[] RACES = new ResourceLocation[]{ModValues.HUMAN, ModValues.FISHMAN};
    private static final Map<ResourceLocation, ArrayList<Supplier<? extends Item>>> MELEE_FACTION_WEAPONS = NotoriousEntity.createFactionWeaponsMap();
    private static final String[] PIRATE_NAMES = new String[]{"Allison", "Bellamy", "Benito", "Barrow", "Caesar", "Bonnet", "Burke", "Chivers", "Coward", "Derdrake", "Frowd", "Hands", "Julian", "Low", "Lyne", "Pargo", "Roberts", "Almeida", "Shih", "Abbas", "Willems", "Veale", "Lewis", "Hamlin", "Andreson", "Wittebol", "Worst"};
    private static final String[] PIRATE_PRE_TITLES = new String[]{"Tyrant", "Sir", "Don", "Iron Hand", "Boss", "Commander", "Black Arm", "Mountain"};
    private static final String[] PIRATE_POST_TITLES = new String[]{"the Hyena", "the Beheader", "the Cannibal", "the Mad", "the Mighty", "the Superior", "the Lonely", "the Sea Weasel"};
    private static final String[] MARINE_NAMES = new String[]{"Golden", "Goffe", "Griffin", "Hoar", "John", "Liddell", "Penniston", "Aregnaudeau", "Jennings", "Enriquez", "Day", "Crapo", "Burches", "Barnet", "Ashworth", "Wright", "Woolerly", "Ras", "Pardal", "Paine", "Morgan", "Mansfield", "Henley", "Essex", "Browne", "Bequel"};
    private final ServerOPBossInfo bossInfo = new ServerOPBossInfo(this.func_200201_e());
    private final NPCPhaseManager phaseManager = new NPCPhaseManager((MobEntity)this);
    private float difficulty;
    private boolean isTriggered;
    private TrackedNPC trackedData;
    private Random trackedRandom;

    private static Map<ResourceLocation, ArrayList<Supplier<? extends Item>>> createFactionWeaponsMap() {
        HashMap<ResourceLocation, ArrayList<Supplier<? extends Item>>> map = new HashMap<ResourceLocation, ArrayList<Supplier<? extends Item>>>();
        map.put(ModValues.PIRATE, MobsHelper.PIRATE_SWORDS);
        map.put(ModValues.MARINE, MobsHelper.MARINE_CAPTAIN_SWORDS);
        map.put(ModValues.BANDIT, MobsHelper.BANDIT_SWORDS);
        return map;
    }

    public NotoriousEntity(EntityType<?> type, World world, ResourceLocation faction) {
        this(type, world, faction, null);
    }

    public NotoriousEntity(EntityType<?> type, World world, ResourceLocation faction, @Nullable TrackedNPC trackedData) {
        super(type, world);
        if (world != null && !world.field_72995_K) {
            int fruitChance;
            boolean hasAdvancedHaki;
            if (trackedData != null) {
                this.trackedData = trackedData;
                this.trackedRandom = new Random(this.trackedData.getSeed());
                this.func_184221_a(trackedData.getUUID());
            } else {
                this.trackedRandom = this.field_70146_Z;
                this.func_184221_a(new UUID(this.trackedRandom.nextLong(), this.trackedRandom.nextLong()));
            }
            this.getEntityStats().setFaction(faction);
            if (trackedData != null) {
                this.getEntityStats().setFightingStyle(trackedData.getStyle());
                this.getEntityStats().setRace(trackedData.getRace());
            }
            this.setDetails();
            if (this.trackedRandom.nextFloat() < 0.5f) {
                if (this.trackedRandom.nextFloat() < 0.3f) {
                    this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.THREE_CIGARS.get()));
                } else {
                    this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack((IItemProvider)ModItems.CIGAR.get()));
                }
            }
            boolean isHardDifficulty = this.isAboveNormalDifficulty();
            this.setDoriki(6000.0 + WyHelper.randomWithRange(0, 2000) + (isHardDifficulty ? WyHelper.randomWithRange(0, 1000) : 0.0));
            this.setBelly(500.0 + WyHelper.randomWithRange(0, 100));
            if (faction.equals((Object)ModValues.PIRATE) || faction.equals((Object)ModValues.BANDIT)) {
                long bounty = 100000000 + this.field_70146_Z.nextInt(400000000);
                this.getEntityStats().setBounty(bounty);
            }
            AttributeHelper.updateToughnessAttribute((LivingEntity)this);
            this.func_110148_a((Attribute)ModAttributes.GCD.get()).func_111128_a(isHardDifficulty ? 20.0 : 40.0);
            this.func_110148_a((Attribute)ModAttributes.FAUX_PROTECTION.get()).func_111128_a(20.0);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(8.0);
            MobsHelper.addBasicNPCGoals(this);
            this.field_70714_bg.func_75776_a(0, (Goal)new JumpOutOfHoleGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new GapCloserGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(0, (Goal)new DashDodgeProjectilesGoal((MobEntity)this, 200.0f, 2.5f));
            this.field_70714_bg.func_75776_a(0, (Goal)new DashDodgeTargetGoal((MobEntity)this, 250.0f, 2.5f));
            this.field_70714_bg.func_75776_a(0, (Goal)new SprintTowardsTargetGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal(this, 1.0, true));
            if (this.getEntityStats().isBandit()) {
                this.field_70714_bg.func_75776_a(2, (Goal)new KnifeThrowingGoal(this).setAmount(3));
            }
            IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
            WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
            if (props.isHuman()) {
                goals.addEntry(() -> new SoruWrapperGoal((MobEntity)this), 10.0f);
                goals.addEntry(() -> new ShiganWrapperGoal((MobEntity)this), 10.0f);
                goals.addEntry(() -> new TekkaiWrapperGoal((MobEntity)this), 10.0f);
                goals.addEntry(() -> new RankyakuWrapperGoal((MobEntity)this), 10.0f);
                goals.addEntry(() -> new GeppoWrapperGoal((MobEntity)this), 10.0f);
                goals.addEntry(() -> new KamieWrapperGoal((MobEntity)this), 10.0f);
            } else if (props.isFishman()) {
                this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<FishmanPassiveBonusesAbility>((MobEntity)this, FishmanPassiveBonusesAbility.INSTANCE));
                goals.addEntry(() -> new KarakusagawaraSeikenWrapperGoal((MobEntity)this), 10.0f);
                goals.addEntry(() -> new KachiageHaisokuWrapperGoal((MobEntity)this), 10.0f);
                goals.addEntry(() -> new MurasameWrapperGoal((MobEntity)this), 10.0f);
                goals.addEntry(() -> new SamehadaShoteiWrapperGoal((MobEntity)this), 10.0f);
                goals.addEntry(() -> new MizuOsuWrapperGoal((MobEntity)this), 10.0f);
                if (isHardDifficulty || this.trackedRandom.nextInt(3) == 0) {
                    goals.addEntry(() -> new MizuShuryudanWrapperGoal((MobEntity)this), 10.0f);
                } else {
                    goals.addEntry(() -> new UchimizuWrapperGoal((MobEntity)this), 10.0f);
                }
            } else if (props.isMink()) {
                this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<MinkPassiveBonusesAbility>((MobEntity)this, MinkPassiveBonusesAbility.INSTANCE));
                goals.addEntry(() -> new EleclawWrapperGoal((MobEntity)this), 3.0f);
                goals.addEntry(() -> new ElectricalLunaWrapperGoal((MobEntity)this), 3.0f);
                goals.addEntry(() -> new ElectricalMissileWrapperGoal((MobEntity)this), 3.0f);
                goals.addEntry(() -> new ElectricalTempestaWrapperGoal((MobEntity)this), 3.0f);
            }
            int racialAbilities = 3 + this.trackedRandom.nextInt(3 + (isHardDifficulty ? 2 : 0));
            MobsHelper.getRandomizedGoals((MobEntity)this, racialAbilities, goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
            MobsHelper.addBusoshokuHaki((MobEntity)this, 100);
            boolean bl = hasAdvancedHaki = isHardDifficulty || this.trackedRandom.nextInt(3) == 0 || this.getDoriki() >= 8000.0;
            if (hasAdvancedHaki) {
                this.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiInternalDestructionWrapperGoal((MobEntity)this));
                this.field_70714_bg.func_75776_a(1, (Goal)new HaoshokuHakiInfusionWrapperGoal((MobEntity)this));
                this.field_70714_bg.func_75776_a(1, (Goal)new BusoshokuHakiFullbodyHardeningWrapperGoal((MobEntity)this));
                if (this.getDoriki() >= 7000.0 || this.trackedRandom.nextInt(3) == 0) {
                    this.field_70714_bg.func_75776_a(1, (Goal)new KenbunshokuHakiFutureSightWrapperGoal((MobEntity)this));
                }
            }
            if ((fruitChance = ((Integer)AbilitiesConfig.OPEN_WORLD_FRUIT_USERS.get()).intValue()) > 0 && this.trackedRandom.nextInt(100) <= fruitChance) {
                MobsHelper.getRandomDevilFruitAbilities((MobEntity)this).ifPresent(list -> list.forEach(goal -> this.field_70714_bg.func_75776_a(2, (Goal)goal)));
            }
        }
    }

    public static NotoriousEntity createMarine(EntityType<?> type, World world) {
        return new NotoriousEntity(type, world, ModValues.MARINE);
    }

    public static NotoriousEntity createPirate(EntityType<?> type, World world) {
        return new NotoriousEntity(type, world, ModValues.PIRATE);
    }

    public static NotoriousEntity createBandit(EntityType<?> type, World world) {
        return new NotoriousEntity(type, world, ModValues.BANDIT);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 50.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233818_a_, WyHelper.randomWithRange(200, 250)).func_233815_a_(Attributes.field_233826_i_, 20.0).func_233815_a_(Attributes.field_233827_j_, 10.0);
    }

    private void setCustomName(Random random) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
        if (props == null) {
            return;
        }
        if (props.isMarine()) {
            String name = MARINE_NAMES[random.nextInt(MARINE_NAMES.length)];
            this.func_200203_b((ITextComponent)new StringTextComponent("Vice Admiral " + name));
        } else if (random.nextInt(64) == 0) {
            if (random.nextBoolean()) {
                this.func_200203_b((ITextComponent)new StringTextComponent("Jack the Sparrow"));
            } else {
                this.func_200203_b((ITextComponent)new StringTextComponent("Captain Jack Sparrow"));
            }
        } else {
            String name = PIRATE_NAMES[random.nextInt(PIRATE_NAMES.length)];
            String prefix = "";
            String suffix = "";
            if (random.nextInt(3) == 0) {
                if (random.nextBoolean()) {
                    prefix = PIRATE_PRE_TITLES[random.nextInt(PIRATE_PRE_TITLES.length)] + " ";
                    if (random.nextInt(4) == 0) {
                        suffix = PIRATE_POST_TITLES[random.nextInt(PIRATE_POST_TITLES.length)];
                    }
                } else {
                    suffix = PIRATE_POST_TITLES[random.nextInt(PIRATE_POST_TITLES.length)];
                }
            } else {
                prefix = "Captain ";
            }
            this.func_200203_b((ITextComponent)new StringTextComponent(prefix + name + (suffix.isEmpty() ? "" : " " + suffix)));
        }
        this.bossInfo.func_186739_a(this.func_200201_e());
    }

    @Override
    public void func_70071_h_() {
        this.bossInfo.tick((LivingEntity)this);
        super.func_70071_h_();
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        if (this.bossInfo != null) {
            this.bossInfo.func_186760_a(player);
        }
        if (!this.isTriggered) {
            this.isTriggered = true;
        }
        this.bossInfo.func_186739_a(this.func_200201_e());
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        if (this.bossInfo != null) {
            this.bossInfo.func_186761_b(player);
        }
        if (this.isTriggered) {
            this.isTriggered = false;
        }
    }

    private void setDetails() {
        IEntityStats props = this.getEntityStats();
        this.setCustomName(this.trackedRandom);
        if (props.isPirate()) {
            this.setPirateDetails();
        } else if (props.isMarine()) {
            this.setMarineDetails();
        } else if (props.isBandit()) {
            this.setBanditDetails();
        }
        this.chooseTexture(this.trackedRandom);
        if (props.isSwordsman()) {
            this.setSwordsmanDetails();
        } else if (props.isBrawler()) {
            this.setBrawlerDetails();
        } else if (props.isBlackLeg()) {
            this.setBlackLegDetails();
        } else if (props.isSniper()) {
            this.setSniperDetails();
        }
    }

    private void setSwordsmanDetails() {
        float dualWeildChance;
        ItemStack randomSword = this.getRandomSword(this.trackedRandom, (List<Supplier<? extends Item>>)MELEE_FACTION_WEAPONS.get(this.getEntityStats().getFaction()));
        this.func_184201_a(EquipmentSlotType.MAINHAND, randomSword);
        float f = dualWeildChance = this.getEntityStats().isPirate() ? 0.4f : 0.2f;
        if (this.trackedRandom.nextFloat() < dualWeildChance) {
            this.func_184201_a(EquipmentSlotType.OFFHAND, randomSword.func_77946_l());
        }
        MobsHelper.addSwordsmanAbilities((MobEntity)this, 3 + this.trackedRandom.nextInt(3));
    }

    private void setBrawlerDetails() {
        this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<BrawlerPassiveBonusesAbility>((MobEntity)this, BrawlerPassiveBonusesAbility.INSTANCE));
        MobsHelper.addBrawlerAbilities((MobEntity)this, 3 + this.trackedRandom.nextInt(3));
        this.field_70714_bg.func_75776_a(3, (Goal)new ChargedPunchWrapperGoal((MobEntity)this));
    }

    private void setBlackLegDetails() {
        this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<BlackLegPassiveBonusesAbility>((MobEntity)this, BlackLegPassiveBonusesAbility.INSTANCE));
        WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
        goals.addEntry(() -> new PartyTableKickCourseWrapperGoal((MobEntity)this), 3.0f);
        goals.addEntry(() -> new AntiMannerKickCourseWrapperGoal((MobEntity)this), 3.0f);
        goals.addEntry(() -> new ConcasseWrapperGoal((MobEntity)this), 3.0f);
        goals.addEntry(() -> new ExtraHachisWrapperGoal((MobEntity)this), 3.0f);
        MobsHelper.getRandomizedGoals((MobEntity)this, 3 + this.trackedRandom.nextInt(3), goals).forEach(goal -> this.field_70714_bg.func_75776_a(3, goal));
    }

    private void setSniperDetails() {
        ItemStack randomWeapon = this.trackedRandom.nextBoolean() ? ((ModGunItem)ModWeapons.WALKER.get()).func_190903_i() : ((ModGunItem)ModWeapons.FLINTLOCK.get()).func_190903_i();
        this.func_184201_a(EquipmentSlotType.MAINHAND, randomWeapon);
        WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
        goals.addEntry(() -> new KaenBoshiWrapperGoal((MobEntity)this, 20), 3.0f);
        goals.addEntry(() -> new SakuretsuSabotenBoshiWrapperGoal((MobEntity)this), 3.0f);
        goals.addEntry(() -> new TokuyoAburaBoshiWrapperGoal((MobEntity)this, 20), 3.0f);
        goals.addEntry(() -> new TetsuBoshiWrapperGoal((MobEntity)this), 2.0f);
        goals.addEntry(() -> new RenpatsuNamariBoshiWrapperGoal((MobEntity)this, 60), 2.0f);
        goals.addEntry(() -> new KemuriBoshiWrapperGoal((MobEntity)this), 1.0f);
        goals.addEntry(() -> new NemuriBoshiWrapperGoal((MobEntity)this, 60), 1.0f);
        MobsHelper.getRandomizedGoals((MobEntity)this, 3 + this.trackedRandom.nextInt(3), goals).forEach(goal -> this.field_70714_bg.func_75776_a(3, goal));
    }

    private void setMarineDetails() {
        this.setTextures(MobsHelper.MARINE_VICE_ADMIRAL_TEXTURES);
        ItemStack marineCapeStack = new ItemStack((IItemProvider)ModArmors.MARINE_CAPTAIN_CAPE.get());
        marineCapeStack.func_190925_c("display").func_74768_a("color", MobsHelper.MARINE_BLUE_COLOR.getRGB());
        this.func_184201_a(EquipmentSlotType.CHEST, marineCapeStack);
    }

    private void setPirateDetails() {
        this.setTextures(MobsHelper.PIRATE_CAPTAINS_TEXTURES);
        if (this.trackedRandom.nextFloat() < 0.4f) {
            ItemStack pirateCapeStack = new ItemStack((IItemProvider)ModArmors.PIRATE_CAPTAIN_CAPE.get());
            this.func_184201_a(EquipmentSlotType.CHEST, pirateCapeStack);
        }
    }

    private void setBanditDetails() {
        this.setTextures(MobsHelper.BANDIT_TEXTURES);
    }

    @Override
    public Random getTrackedRandom() {
        return this.trackedRandom;
    }

    @Override
    @Nullable
    public TrackedNPC getTrackedData() {
        return this.trackedData;
    }
}

