/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.BlazeEntity;
import net.minecraft.entity.monster.GhastEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import xyz.pixelatedw.mineminenomi.abilities.CommandAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiFullBodyHardeningAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiHardeningAbility;
import xyz.pixelatedw.mineminenomi.api.entities.GoalMemories;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ICommandReceiver;
import xyz.pixelatedw.mineminenomi.api.entities.IGoalMemoriesEntity;
import xyz.pixelatedw.mineminenomi.api.enums.NPCCommand;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.data.entity.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ClimbOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.TameableHurtByTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.dugong.DugongCheerGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.dugong.DugongHappyGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.dugong.DugongRageGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.dugong.DugongRestGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.dugong.DugongTrainGoal;
import xyz.pixelatedw.mineminenomi.init.ModMemoryModuleTypes;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public abstract class AbstractDugongEntity
extends TameableEntity
implements ICommandReceiver,
IGoalMemoriesEntity {
    private static final Item[] FOOD = new Item[]{Items.field_151083_be, Items.field_151077_bg, Items.field_196102_ba, Items.field_179557_bn, Items.field_151157_am, Items.field_179559_bp, Items.field_196104_bb, Items.field_222066_kO, Items.field_203180_bP};
    private static final DataParameter<Byte> FLAGS = EntityDataManager.func_187226_a(AbstractDugongEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    private static final DataParameter<Integer> TRAINING_MODE = EntityDataManager.func_187226_a(AbstractDugongEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final GoalMemories goalMemories = new GoalMemories();
    private LivingEntity cheerTarget;
    private LivingEntity rageTarget;
    private long lastCommandTime;
    private LivingEntity lastCommandSender;
    private NPCCommand currentCommand = NPCCommand.IDLE;

    protected AbstractDugongEntity(EntityType<? extends TameableEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        CommandAbility.addCommandGoals((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new ClimbOutOfHoleGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new DugongRageGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new DugongHappyGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new DugongCheerGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new DugongRestGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new DugongTrainGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 6.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, AbstractDugongEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new TameableHurtByTargetGoal(this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(FLAGS, (Object)0);
        this.func_184212_Q().func_187214_a(TRAINING_MODE, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
    }

    protected SoundEvent func_184601_bQ(DamageSource pDamageSource) {
        return SoundEvents.field_203262_iB;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_203264_iD;
    }

    protected void func_180429_a(BlockPos pos, BlockState block) {
        this.func_184185_a(SoundEvents.field_203267_iG, 0.2f, 0.5f);
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? 0.6f + this.field_70146_Z.nextFloat() / 4.0f : 0.4f + this.field_70146_Z.nextFloat() / 4.0f;
    }

    private void broadcastAngerTarget(LivingEntity target) {
        this.getNearbyDugongs().forEach(other -> {
            if (other.func_152114_e(target)) {
                return;
            }
            other.setEnraged(target);
        });
    }

    private void broadcastCheeringTarget(LivingEntity target) {
        this.getNearbyDugongs().forEach(other -> {
            if (other.isEnraged() || GoalUtil.hasAliveTarget((MobEntity)other)) {
                return;
            }
            GoalUtil.lookAtEntity((MobEntity)other, (Entity)this);
            other.setCheering((LivingEntity)this);
        });
    }

    public List<AbstractDugongEntity> getNearbyDugongs() {
        if (this.hasMemoryValue((MemoryModuleType)ModMemoryModuleTypes.NEARBY_ADULT_DUGONGS.get())) {
            return (List)this.getMemory((MemoryModuleType)ModMemoryModuleTypes.NEARBY_ADULT_DUGONGS.get()).get();
        }
        List<AbstractDugongEntity> targets = WyHelper.getNearbyLiving(this.func_213303_ch(), (IWorld)this.field_70170_p, 16.0, AbstractDugongEntity.class::isInstance);
        targets.remove(this);
        this.setMemoryWithExpiry((MemoryModuleType)ModMemoryModuleTypes.NEARBY_ADULT_DUGONGS.get(), targets, 600L);
        return targets;
    }

    public void func_70619_bc() {
        this.goalMemories.tick();
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (this.func_70909_n() && this.func_152114_e((LivingEntity)player) && !player.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND) {
            ItemStack stack = player.func_184586_b(player.func_184600_cs() != null ? player.func_184600_cs() : Hand.MAIN_HAND);
            if (!stack.func_190926_b() && this.func_110143_aJ() < this.func_110138_aP() && this.func_70877_b(stack)) {
                stack.func_190918_g(1);
                this.func_70691_i(4.0f);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                return ActionResultType.SUCCESS;
            }
            if (stack.func_190926_b()) {
                this.func_233687_w_(!this.func_233685_eM_());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                return ActionResultType.SUCCESS;
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            // empty if block
        }
    }

    public void func_70636_d() {
        this.func_82168_bl();
        super.func_70636_d();
    }

    @Override
    public boolean canReceiveCommandFrom(LivingEntity commandSender) {
        return this.func_152114_e(commandSender);
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        boolean flag = super.func_70097_a(damageSource, amount);
        if (!flag) {
            return false;
        }
        Entity entity = damageSource.func_76346_g();
        if (!this.field_70170_p.field_72995_K && !this.func_70909_n() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            boolean hasEmptyHand = living.func_184586_b(living.func_184600_cs()).func_190926_b();
            if (hasEmptyHand) {
                if (living instanceof PlayerEntity) {
                    this.broadcastCheeringTarget(living);
                    PlayerEntity player = (PlayerEntity)living;
                    if (!this.isEnraged() && this.func_110143_aJ() < this.func_110138_aP() / 2.0f && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                        this.func_193101_c(player);
                    }
                }
            } else {
                this.setEnraged(living);
                this.broadcastAngerTarget(living);
            }
        }
        return true;
    }

    public boolean func_233685_eM_() {
        return super.func_233685_eM_();
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        LivingEntity targetTamer;
        if (target instanceof GhastEntity || target instanceof BlazeEntity) {
            return false;
        }
        LivingEntity entityTamer = MobsHelper.getTamer(target);
        return entityTamer == null || !(targetTamer = MobsHelper.getTamer(target)).equals((Object)entityTamer);
    }

    public void func_193101_c(PlayerEntity player) {
        super.func_193101_c(player);
        this.field_70699_by.func_75499_g();
        this.func_233687_w_(true);
        this.func_70624_b(null);
        this.broadcastCheeringTarget(null);
        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
    }

    public AgeableEntity func_241840_a(ServerWorld pServerLevel, AgeableEntity pMate) {
        return null;
    }

    public boolean func_70648_aU() {
        return true;
    }

    public boolean func_70877_b(ItemStack stack) {
        return Arrays.stream(FOOD).anyMatch(stack.func_77973_b()::equals);
    }

    public boolean hasHakiLearned() {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)this);
        boolean hasHardening = props.hasUnlockedAbility(BusoshokuHakiHardeningAbility.INSTANCE);
        boolean hasFullbody = props.hasUnlockedAbility(BusoshokuHakiFullBodyHardeningAbility.INSTANCE);
        return hasHardening || hasFullbody;
    }

    public boolean func_213397_c(double distance) {
        return !this.func_70909_n() && distance > 1024.0;
    }

    public boolean isTraining() {
        return (Integer)this.field_70180_af.func_187225_a(TRAINING_MODE) > 0;
    }

    public boolean isIdling() {
        return !this.isTraining() && !this.isResting() && !this.isCheering();
    }

    public TrainingMethod getTrainingMode() {
        return TrainingMethod.values()[(Integer)this.field_70180_af.func_187225_a(TRAINING_MODE) - 1];
    }

    public void stopTraining() {
        this.setTraining(0);
    }

    public void setTraining(int mode) {
        this.field_70180_af.func_187227_b(TRAINING_MODE, (Object)mode);
    }

    public void setCheering(@Nullable LivingEntity target) {
        boolean set = true;
        if (target == null || this.func_152114_e(target)) {
            set = false;
            target = null;
        }
        this.setFlag(0, set);
        this.cheerTarget = target;
    }

    public void setHappy(boolean flag) {
        this.setFlag(1, flag);
    }

    public void setResting(boolean flag) {
        this.setFlag(2, flag);
    }

    public void setEnraged(@Nullable LivingEntity attacker) {
        boolean set = true;
        if (attacker == null || this.func_152114_e(attacker)) {
            set = false;
            attacker = null;
        }
        this.setFlag(3, set);
        this.rageTarget = attacker;
    }

    private void setFlag(int flag, boolean set) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(FLAGS);
        if (set) {
            this.field_70180_af.func_187227_b(FLAGS, (Object)((byte)(b0 | 1 << flag)));
        } else {
            this.field_70180_af.func_187227_b(FLAGS, (Object)((byte)(b0 & ~(1 << flag))));
        }
    }

    private boolean getFlag(int id) {
        return ((Byte)this.field_70180_af.func_187225_a(FLAGS) & 1 << id) != 0;
    }

    public boolean isCheering() {
        return this.getFlag(0);
    }

    public boolean isHappy() {
        return this.getFlag(1);
    }

    public boolean isResting() {
        return this.getFlag(2);
    }

    public boolean isEnraged() {
        return this.getFlag(3);
    }

    public boolean isWandering() {
        return this.getFlag(4);
    }

    @Nullable
    public LivingEntity getCheerTarget() {
        return this.cheerTarget;
    }

    @Nullable
    public LivingEntity getRageTarget() {
        return this.rageTarget;
    }

    @Override
    public void setCurrentCommand(@Nullable LivingEntity commandSender, NPCCommand command) {
        this.lastCommandTime = this.field_70170_p.func_82737_E();
        this.lastCommandSender = commandSender;
        this.currentCommand = command;
    }

    @Override
    public NPCCommand getCurrentCommand() {
        return this.currentCommand;
    }

    @Override
    @Nullable
    public LivingEntity getLastCommandSender() {
        return this.lastCommandSender;
    }

    @Override
    public long getLastCommandTime() {
        return this.lastCommandTime;
    }

    @Override
    public GoalMemories getGoalMemories() {
        return this.goalMemories;
    }

    public static enum TrainingMethod {
        SHADOW_BOXING,
        PUSHUPS;

    }
}

