/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.JumpOutOfHoleGoal;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class BigDuckEntity
extends TameableEntity
implements IJumpingMount {
    private static final DataParameter<Boolean> IS_SADDLED = EntityDataManager.func_187226_a(BigDuckEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final String SADDLED_TAG = "isSaddled";
    private static final double TAME_CHANCE = 0.2;
    private static final Item[] SADDLES = new Item[]{Items.field_151141_av};
    private static final Item[] FOOD = new Item[]{Items.field_222112_pR, Items.field_185163_cU, Items.field_151081_bc, Items.field_151080_bb, Items.field_151014_N};
    private static final int QUACK_ANIM_CYCLE = 20;
    private static final byte QUACK_EVENT = 100;
    private float playerJumpPendingScale;
    private boolean isJumping;
    private double floating;
    private int clientQuackTick = 0;

    public BigDuckEntity(EntityType type, World world) {
        super(type, world);
        if (world != null && !world.field_72995_K) {
            this.func_110148_a((Attribute)ModAttributes.STEP_HEIGHT.get()).func_111128_a(1.0);
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233814_a_((Attribute)ModAttributes.FLOATING_TIME.get()).func_233814_a_(Attributes.field_233830_m_).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.27).func_233815_a_(Attributes.field_233818_a_, 25.0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new JumpOutOfHoleGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.2, false, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_222112_pR})));
        this.field_70714_bg.func_75776_a(3, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowParentGoal((AnimalEntity)this, 1.15));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(IS_SADDLED, (Object)false);
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a(SADDLED_TAG, ((Boolean)this.field_70180_af.func_187225_a(IS_SADDLED)).booleanValue());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.field_70180_af.func_187227_b(IS_SADDLED, (Object)nbt.func_74767_n(SADDLED_TAG));
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)ModSounds.BIG_DUCK_QUACK.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource pDamageSource) {
        return (SoundEvent)ModSounds.BIG_DUCK_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)ModSounds.BIG_DUCK_HURT.get();
    }

    protected void func_180429_a(BlockPos pos, BlockState block) {
        this.func_184185_a(SoundEvents.field_187538_aa, 0.2f, 0.5f);
    }

    protected float func_70599_aP() {
        return 0.8f;
    }

    protected float func_70647_i() {
        return this.func_70631_g_() ? 1.5f + this.field_70146_Z.nextFloat() / 3.0f : 1.0f + this.field_70146_Z.nextFloat() / 3.0f;
    }

    public void func_70642_aH() {
        this.field_70170_p.func_72960_a((Entity)this, (byte)100);
        super.func_70642_aH();
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.clientQuackTick > 0) {
            --this.clientQuackTick;
        }
        Vector3d vector3d = this.func_213322_ci();
        if (!this.field_70122_E && this.floating > 0.0) {
            if (vector3d.field_72448_b < 0.0) {
                AbilityHelper.setDeltaMovement((Entity)this, vector3d.func_216372_d(1.0, 0.6, 1.0));
            }
            this.field_70143_R = 0.0f;
            this.floating -= 1.0;
        } else if (this.field_70122_E && !this.isJumping()) {
            this.floating = this.func_233637_b_((Attribute)ModAttributes.FLOATING_TIME.get());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        switch (id) {
            case 100: {
                this.clientQuackTick = 20;
            }
        }
        super.func_70103_a(id);
    }

    public boolean func_225503_b_(float distance, float damage) {
        boolean dealDamage = damage > 0.0f && this.floating <= 0.0;
        this.floating = this.func_233637_b_((Attribute)ModAttributes.FLOATING_TIME.get());
        if (dealDamage) {
            return super.func_225503_b_(distance, damage);
        }
        return false;
    }

    protected void func_70665_d(DamageSource source, float amount) {
        this.field_70170_p.func_72960_a((Entity)this, (byte)100);
        super.func_70665_d(source, amount);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!player.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND) {
            ItemStack stack = player.func_184586_b(player.func_184600_cs() != null ? player.func_184600_cs() : Hand.MAIN_HAND);
            boolean isSaddle = Arrays.stream(SADDLES).anyMatch(stack.func_77973_b()::equals);
            if (!this.func_70909_n()) {
                if (!stack.func_190926_b() && this.func_70877_b(stack)) {
                    this.func_175505_a(player, stack);
                    double chance = this.field_70146_Z.nextDouble();
                    if (chance < 0.2 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)player)) {
                        this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                        this.func_193101_c(player);
                    }
                    return ActionResultType.SUCCESS;
                }
            } else {
                if (this.func_70877_b(stack) && this.func_110143_aJ() < this.func_110138_aP()) {
                    this.func_175505_a(player, stack);
                    this.func_70691_i(4.0f);
                    this.field_70170_p.func_72960_a((Entity)this, (byte)7);
                    return ActionResultType.SUCCESS;
                }
                if (isSaddle && !this.isSaddled() && !this.func_70631_g_()) {
                    this.setSaddled(true);
                    this.field_70170_p.func_217384_a((PlayerEntity)null, (Entity)this, SoundEvents.field_187726_cu, SoundCategory.PLAYERS, 0.5f, 1.0f);
                    this.func_175505_a(player, stack);
                    return ActionResultType.SUCCESS;
                }
                if ((!this.func_70877_b(stack) || this.func_70877_b(stack) && !this.func_204701_dC()) && player == this.func_70902_q() && !this.func_70631_g_()) {
                    player.func_184220_m((Entity)this);
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return super.func_230254_b_(player, hand);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld pLevel, DifficultyInstance pDifficulty, SpawnReason pReason, @Nullable ILivingEntityData pSpawnData, @Nullable CompoundNBT pDataTag) {
        if (pSpawnData == null) {
            pSpawnData = new AgeableEntity.AgeableData(0.2f);
        }
        this.func_110148_a(Attributes.field_233830_m_).func_111128_a(this.generateRandomJumpStrength());
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.generateRandomSpeed());
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.generateRandomHealth());
        double floatingTime = this.generateRandomFloatingTime();
        this.func_110148_a((Attribute)ModAttributes.FLOATING_TIME.get()).func_111128_a(floatingTime);
        this.floating = floatingTime;
        this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
        return super.func_213386_a(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        BigDuckEntity duck = (BigDuckEntity)((EntityType)ModEntities.BIG_DUCK.get()).func_200721_a((World)world);
        this.setOffspringAttributes(mate, duck);
        return duck;
    }

    protected void setOffspringAttributes(AgeableEntity mate, BigDuckEntity offspring) {
        double hp = this.func_233638_c_(Attributes.field_233818_a_) + mate.func_233638_c_(Attributes.field_233818_a_) + this.generateRandomHealth();
        offspring.func_110148_a(Attributes.field_233818_a_).func_111128_a(hp / 3.0);
        double jump = this.func_233638_c_(Attributes.field_233830_m_) + mate.func_233638_c_(Attributes.field_233830_m_) + this.generateRandomJumpStrength();
        offspring.func_110148_a(Attributes.field_233830_m_).func_111128_a(jump / 3.0);
        double speed = this.func_233638_c_(Attributes.field_233821_d_) + mate.func_233638_c_(Attributes.field_233821_d_) + this.generateRandomSpeed();
        offspring.func_110148_a(Attributes.field_233821_d_).func_111128_a(speed / 3.0);
        double floating = this.func_233638_c_((Attribute)ModAttributes.FLOATING_TIME.get()) + mate.func_233638_c_((Attribute)ModAttributes.FLOATING_TIME.get()) + this.generateRandomFloatingTime();
        offspring.func_110148_a((Attribute)ModAttributes.FLOATING_TIME.get()).func_111128_a(floating / 3.0);
    }

    protected double generateRandomJumpStrength() {
        return 0.6 + this.field_70146_Z.nextDouble() * 0.4;
    }

    protected double generateRandomSpeed() {
        return 0.28 + this.field_70146_Z.nextDouble() * 0.08;
    }

    protected double generateRandomHealth() {
        return 20.0 + this.field_70146_Z.nextDouble() * 10.0;
    }

    protected double generateRandomFloatingTime() {
        return 50.0 + WyHelper.randomDouble(this.field_70146_Z) * 0.5 * 30.0;
    }

    public void func_213352_e(Vector3d pTravelVector) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.isSaddled()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.5f;
                float f1 = livingentity.field_191988_bg;
                if (f1 <= 0.0f) {
                    f1 *= 0.25f;
                }
                if (this.playerJumpPendingScale > 0.0f && !this.isJumping() && this.field_70122_E) {
                    double d0 = this.func_233637_b_(Attributes.field_233830_m_) * (double)this.playerJumpPendingScale * (double)this.func_226269_ah_();
                    double d1 = this.func_70644_a(Effects.field_76430_j) ? d0 + (double)((float)(this.func_70660_b(Effects.field_76430_j).func_76458_c() + 1) * 0.1f) : d0;
                    Vector3d vector3d = this.func_213322_ci();
                    AbilityHelper.setDeltaMovement((Entity)this, vector3d.field_72450_a, d1, vector3d.field_72449_c);
                    this.setIsJumping(true);
                    this.field_70160_al = true;
                    ForgeHooks.onLivingJump((LivingEntity)this);
                    if (f1 > 0.0f) {
                        float f2 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        float f3 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
                        AbilityHelper.setDeltaMovement((Entity)this, this.func_213322_ci().func_72441_c((double)(-0.4f * f2 * this.playerJumpPendingScale), 0.0, (double)(0.4f * f3 * this.playerJumpPendingScale)));
                    }
                    this.playerJumpPendingScale = 0.0f;
                }
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_));
                    super.func_213352_e(new Vector3d((double)f, pTravelVector.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    AbilityHelper.setDeltaMovement((Entity)this, Vector3d.field_186680_a);
                }
                if (this.field_70122_E) {
                    this.playerJumpPendingScale = 0.0f;
                    this.setIsJumping(false);
                }
                this.func_233629_a_((LivingEntity)this, false);
            } else {
                super.func_213352_e(pTravelVector);
            }
        }
    }

    public boolean func_213397_c(double distance) {
        return !this.func_70909_n() && distance > 1024.0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_70877_b(ItemStack stack) {
        if (stack.func_190926_b()) return false;
        if (!Arrays.stream(FOOD).anyMatch(stack.func_77973_b()::equals)) return false;
        return true;
    }

    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() && this.isSaddled();
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    @Nullable
    public Entity func_184179_bs() {
        List list = this.func_184188_bt();
        return list.isEmpty() ? null : (Entity)list.get(0);
    }

    public double func_70042_X() {
        return 1.2;
    }

    public void setSaddled(boolean flag) {
        this.field_70180_af.func_187227_b(IS_SADDLED, (Object)flag);
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SADDLED);
    }

    public void func_110206_u(int jumpPower) {
        if (this.isSaddled()) {
            if (jumpPower < 0) {
                jumpPower = 0;
            }
            this.playerJumpPendingScale = jumpPower >= 90 ? 1.0f : 0.4f + 0.4f * (float)jumpPower / 90.0f;
        }
    }

    public void setIsJumping(boolean isJumping) {
        this.isJumping = isJumping;
    }

    public boolean isJumping() {
        return this.isJumping;
    }

    public boolean func_184776_b() {
        return this.isSaddled();
    }

    public void func_184775_b(int power) {
    }

    public void func_184777_r_() {
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getQuackAnimationProgress(float partialTicks) {
        return ((float)(20 - this.clientQuackTick) + partialTicks) / 20.0f;
    }
}

