/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.brawler.BrawlerPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.PunchRushAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.AbstractDugongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.WrestlingDugongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.DamageAbsorptionWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.PunchRushWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModValues;

public class BoxingDugongEntity
extends AbstractDugongEntity {
    public BoxingDugongEntity(EntityType type, World world) {
        this(type, world, false);
    }

    public BoxingDugongEntity(EntityType type, World world, boolean spawnAsKid) {
        super((EntityType<? extends TameableEntity>)type, world);
        if (world != null && !world.field_72995_K) {
            IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
            props.setFightingStyle(ModValues.BRAWLER);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(2.0);
            PunchRushWrapperGoal punchRushWrapper = new PunchRushWrapperGoal((MobEntity)this);
            ((PunchRushAbility)punchRushWrapper.getAbility()).setWaveDetails(10, 2);
            this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<BrawlerPassiveBonusesAbility>((MobEntity)this, BrawlerPassiveBonusesAbility.INSTANCE));
            this.field_70714_bg.func_75776_a(0, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
            this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal((CreatureEntity)this, 1.2f, true));
            this.field_70714_bg.func_75776_a(2, (Goal)new DamageAbsorptionWrapperGoal((MobEntity)this));
            WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
            goals.addEntry(() -> punchRushWrapper, 1.0f);
            goals.addEntry(() -> new HakaiHoWrapperGoal((MobEntity)this), 1.0f);
            MobsHelper.getRandomizedGoals((MobEntity)this, 2, goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
            if (!spawnAsKid) {
                MobsHelper.addBusoshokuHaki((MobEntity)this, 10);
            }
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MonsterEntity.class, true, true));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, WrestlingDugongEntity.class, true, false));
        }
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233819_b_, 40.0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld level, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        if (spawnData == null) {
            spawnData = new AgeableEntity.AgeableData(0.2f);
        }
        this.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.generateRandomHealth());
        this.func_110148_a(Attributes.field_233826_i_).func_111128_a(this.generateRandomArmor());
        this.func_110148_a(Attributes.field_233823_f_).func_111128_a(this.generateRandomAttack());
        this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.generateRandomSpeed());
        this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
        return super.func_213386_a(level, difficulty, reason, spawnData, dataTag);
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity mate) {
        BoxingDugongEntity offspring = new BoxingDugongEntity((EntityType)ModEntities.BOXING_DUGONG.get(), (World)world, true);
        this.setOffspringAttributes(mate, offspring);
        if (this.hasHakiLearned() && mate instanceof AbstractDugongEntity && ((AbstractDugongEntity)mate).hasHakiLearned()) {
            MobsHelper.addBusoshokuHaki((MobEntity)offspring, 80);
        }
        return offspring;
    }

    protected void setOffspringAttributes(AgeableEntity mate, BoxingDugongEntity offspring) {
        double hp = this.func_233638_c_(Attributes.field_233818_a_) + mate.func_233638_c_(Attributes.field_233818_a_) + this.generateRandomHealth();
        offspring.func_110148_a(Attributes.field_233818_a_).func_111128_a(hp / 3.0);
        double armor = this.func_233638_c_(Attributes.field_233826_i_) + mate.func_233638_c_(Attributes.field_233826_i_) + this.generateRandomArmor();
        offspring.func_110148_a(Attributes.field_233826_i_).func_111128_a(armor / 3.0);
        double speed = this.func_233638_c_(Attributes.field_233821_d_) + mate.func_233638_c_(Attributes.field_233821_d_) + this.generateRandomSpeed();
        offspring.func_110148_a(Attributes.field_233821_d_).func_111128_a(speed / 3.0);
        double damage = this.func_233638_c_(Attributes.field_233823_f_) + mate.func_233638_c_(Attributes.field_233823_f_) + this.generateRandomAttack();
        offspring.func_110148_a(Attributes.field_233823_f_).func_111128_a(damage / 3.0);
    }

    protected double generateRandomHealth() {
        return 60.0 + this.field_70146_Z.nextDouble() * 20.0;
    }

    protected double generateRandomArmor() {
        return 2.0 + this.field_70146_Z.nextDouble() * 4.0;
    }

    protected double generateRandomSpeed() {
        return 0.28 + this.field_70146_Z.nextDouble() * 0.06;
    }

    protected double generateRandomAttack() {
        return 7.0 + this.field_70146_Z.nextDouble() * 3.0;
    }
}

