/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.abilities.brawler.BrawlerPassiveBonusesAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.MobsHelper;
import xyz.pixelatedw.mineminenomi.api.util.WeightedList;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.animals.AbstractDugongEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.ImprovedMeleeAttackGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.SprintTowardsTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.TameableHurtByTargetGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.AlwaysActiveAbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.ChargedPunchWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.HakaiHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.brawler.JishinHoWrapperGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.commands.AttackCommandGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.commands.FollowCommandGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.commands.GuardCommandGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.commands.StayCommandGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.dugong.DugongRageGoal;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.dugong.DugongTrainGoal;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class WanderingDugongEntity
extends AbstractDugongEntity
implements IEntityAdditionalSpawnData {
    private int headScarId = 0;
    private int chestScarId = 0;
    private int armsScarId = 0;
    private int tailScarId = 0;

    public WanderingDugongEntity(EntityType type, World world) {
        super((EntityType<? extends TameableEntity>)type, world);
        if (world != null && !world.field_72995_K) {
            this.headScarId = this.field_70146_Z.nextInt(MobsHelper.DUGONG_HEAD_SCARS_TEXTURES.length);
            this.chestScarId = this.field_70146_Z.nextInt(MobsHelper.DUGONG_CHEST_SCARS_TEXTURES.length);
            this.armsScarId = this.field_70146_Z.nextBoolean() ? this.field_70146_Z.nextInt(MobsHelper.DUGONG_ARMS_SCARS_TEXTURES.length) : -1;
            this.tailScarId = this.field_70146_Z.nextBoolean() ? this.field_70146_Z.nextInt(MobsHelper.DUGONG_TAIL_SCARS_TEXTURES.length) : -1;
            IEntityStats props = EntityStatsCapability.get((LivingEntity)this);
            props.setFightingStyle(ModValues.BRAWLER);
            this.func_110148_a((Attribute)ModAttributes.TOUGHNESS.get()).func_111128_a(4.0);
            this.func_70606_j((float)this.func_110148_a(Attributes.field_233818_a_).func_111126_e());
            this.field_70714_bg.func_75776_a(0, new AlwaysActiveAbilityWrapperGoal<BrawlerPassiveBonusesAbility>((MobEntity)this, BrawlerPassiveBonusesAbility.INSTANCE));
            this.field_70714_bg.func_75776_a(0, (Goal)new SprintTowardsTargetGoal((MobEntity)this));
            this.field_70714_bg.func_75776_a(1, (Goal)new ImprovedMeleeAttackGoal((CreatureEntity)this, 1.2f, true));
            Predicate<LivingEntity> dugongCheck = target -> {
                if (target instanceof AbstractDugongEntity) {
                    return target instanceof WanderingDugongEntity;
                }
                return true;
            };
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true, true));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, OPEntity.class, true, true));
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CreatureEntity.class, 10, true, true, dugongCheck));
            WeightedList<Supplier<Goal>> goals = new WeightedList<Supplier<Goal>>(new Object[0]);
            goals.addEntry(() -> new HakaiHoWrapperGoal((MobEntity)this), 3.0f);
            goals.addEntry(() -> new JishinHoWrapperGoal((MobEntity)this), 2.0f);
            goals.addEntry(() -> new ChargedPunchWrapperGoal((MobEntity)this), 2.0f);
            MobsHelper.getRandomizedGoals((MobEntity)this, 2, goals).forEach(goal -> this.field_70714_bg.func_75776_a(2, goal));
            MobsHelper.addBusoshokuHaki((MobEntity)this, 70);
        }
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, new StayCommandGoal<WanderingDugongEntity>(this));
        this.field_70714_bg.func_75776_a(0, new FollowCommandGoal<WanderingDugongEntity>(this));
        this.field_70714_bg.func_75776_a(0, new GuardCommandGoal<WanderingDugongEntity>(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(0, (Goal)new DugongRageGoal(this));
        this.field_70714_bg.func_75776_a(0, (Goal)new DugongTrainGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.0, 6.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, AbstractDugongEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, new AttackCommandGoal<WanderingDugongEntity>(this));
        this.field_70715_bh.func_75776_a(0, new StayCommandGoal<WanderingDugongEntity>(this));
        this.field_70715_bh.func_75776_a(0, new FollowCommandGoal<WanderingDugongEntity>(this));
        this.field_70715_bh.func_75776_a(0, new GuardCommandGoal<WanderingDugongEntity>(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new TameableHurtByTargetGoal(this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return OPEntity.createAttributes().func_233815_a_(Attributes.field_233823_f_, 10.0).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233821_d_, 0.3).func_233815_a_(Attributes.field_233818_a_, WyHelper.randomWithRange(60, 100)).func_233815_a_(Attributes.field_233826_i_, WyHelper.randomWithRange(4, 8));
    }

    @Override
    public void func_193101_c(PlayerEntity player) {
        if (this.field_70146_Z.nextInt(64) == 0) {
            super.func_193101_c(player);
        }
    }

    public int getHeadScarId() {
        return this.headScarId;
    }

    public int getChestScarId() {
        return this.chestScarId;
    }

    public int getArmsScarId() {
        return this.armsScarId;
    }

    public int getTailScarId() {
        return this.tailScarId;
    }

    @Override
    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        return null;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.headScarId);
        buffer.writeInt(this.chestScarId);
        buffer.writeInt(this.armsScarId);
        buffer.writeInt(this.tailScarId);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.headScarId = buffer.readInt();
        this.chestScarId = buffer.readInt();
        this.armsScarId = buffer.readInt();
        this.tailScarId = buffer.readInt();
    }
}

