/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals;

import com.google.common.base.Predicates;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEntityPredicates;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class JumpOverProjectilesGoal
extends TickedGoal<MobEntity> {
    private static final float CHECK_AREA = 60.0f;
    private float cooldown;
    private float jumpHeight;
    private ProjectileEntity projectileTarget;
    private int hits;
    private int triggerHits = 3;
    private double previousDistance = 0.0;
    private Predicate<LivingEntity> canUseTest = Predicates.alwaysTrue();

    public JumpOverProjectilesGoal(MobEntity entity, float cooldown, float jumpHeight) {
        super(entity);
        this.cooldown = cooldown;
        this.jumpHeight = jumpHeight;
    }

    public boolean func_75250_a() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        if (!this.hasTimePassedSinceLastEnd(this.cooldown)) {
            return false;
        }
        if (!AbilityHelper.canUseMomentumAbilities((LivingEntity)this.entity)) {
            return false;
        }
        List<ProjectileEntity> projectiles = WyHelper.getNearbyEntities(this.entity.func_213303_ch(), (IWorld)this.entity.field_70170_p, 60.0, null, ProjectileEntity.class);
        for (ProjectileEntity proj : projectiles) {
            boolean isEnemyProjectile = ModEntityPredicates.getEnemyFactions((LivingEntity)this.entity).test(proj.func_234616_v_());
            if (!isEnemyProjectile) continue;
            this.projectileTarget = proj;
            double distance = proj.func_70068_e((Entity)this.entity);
            if (this.previousDistance == 0.0) {
                this.previousDistance = distance;
            }
            if (!(distance < this.previousDistance)) break;
            ++this.hits;
            this.previousDistance = distance;
            break;
        }
        if (this.hits < this.triggerHits) {
            return false;
        }
        if (this.projectileTarget == null) {
            return false;
        }
        return this.canUseTest.test((LivingEntity)this.entity);
    }

    public boolean func_75253_b() {
        return false;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        GoalUtil.lookAtEntity(this.entity, (Entity)this.projectileTarget);
        Vector3d lookVec = this.entity.func_70040_Z().func_216372_d(3.0, 0.0, 3.0);
        AbilityHelper.setDeltaMovement((Entity)this.entity, lookVec.field_72450_a, this.jumpHeight, lookVec.field_72449_c);
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.hits = 0;
        this.previousDistance = 0.0;
    }

    public void setCanUseTest(Predicate<LivingEntity> test) {
        this.canUseTest = test;
    }
}

