/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals;

import java.util.EnumSet;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.api.util.Interval;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RandomWalkingAroundTargetGoal
extends TickedGoal<CreatureEntity> {
    private LivingEntity target;
    private BlockPos targetPos;
    private double speed;
    private int ticksRunning;
    private final int defaultRunningTicks;
    private Interval restBetweenRuns;
    private int minDistance = 20;
    private int maxDistance = 30;

    public RandomWalkingAroundTargetGoal(CreatureEntity entity, double speed, int ticksRunning, int restBetweenRuns) {
        super(entity);
        this.speed = speed;
        this.ticksRunning = ticksRunning;
        this.defaultRunningTicks = ticksRunning;
        this.restBetweenRuns = Interval.startAtZero(restBetweenRuns);
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public RandomWalkingAroundTargetGoal setRunningDistance(int min, int max) {
        this.minDistance = min;
        this.maxDistance = max;
        return this;
    }

    public boolean func_75250_a() {
        if (!this.restBetweenRuns.canTick()) {
            return false;
        }
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        this.target = ((CreatureEntity)this.entity).func_70638_az();
        return !GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, 10.0);
    }

    public boolean func_75253_b() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        return this.ticksRunning > 0;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
        this.targetPos = WyHelper.findValidGroundLocation((Entity)this.entity, this.target.func_233580_cy_(), this.maxDistance, this.minDistance);
    }

    @Override
    public void func_75246_d() {
        super.func_75246_d();
        --this.ticksRunning;
        if (this.ticksRunning % 20 == 0) {
            this.findRunPosition(0);
        }
        if (((CreatureEntity)this.entity).func_70661_as().func_75500_f()) {
            this.findRunPosition(0);
        }
        ((CreatureEntity)this.entity).func_70661_as().func_75492_a((double)this.targetPos.func_177958_n(), (double)this.targetPos.func_177956_o(), (double)this.targetPos.func_177952_p(), this.speed);
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.ticksRunning = this.defaultRunningTicks;
    }

    private void findRunPosition(int run) {
        if (run == 0) {
            // empty if block
        }
        BlockPos pos = WyHelper.findValidGroundLocation((Entity)this.entity, this.target.func_233580_cy_(), this.maxDistance, this.minDistance);
        if (run < 5 && !pos.func_218141_a((Vector3i)this.target.func_233580_cy_(), (double)this.maxDistance)) {
            this.findRunPosition(run++);
            return;
        }
        this.targetPos = pos;
    }
}

