/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.TickedGoal;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RunAroundTargetGoal<E extends CreatureEntity>
extends TickedGoal<E> {
    private LivingEntity target;
    private double speed;
    private int ticksRunning;
    private final int defaultRunningTicks;
    private final int restBetweenRuns;
    private int restTicks;
    private int minDistance = 10;
    private int maxDistance = 30;
    private int uses = 0;

    public RunAroundTargetGoal(E entity, double speed, int ticksRunning, int restBetweenRuns) {
        super(entity);
        this.speed = speed;
        this.ticksRunning = ticksRunning;
        this.defaultRunningTicks = ticksRunning;
        this.restBetweenRuns = restBetweenRuns;
        this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
    }

    public RunAroundTargetGoal setRunningDistance(int min, int max) {
        this.minDistance = min;
        this.maxDistance = max;
        return this;
    }

    public boolean func_75250_a() {
        if (this.restTicks > 0) {
            --this.restTicks;
            return false;
        }
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        this.target = ((CreatureEntity)this.entity).func_70638_az();
        return true;
    }

    public boolean func_75253_b() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        return this.ticksRunning > 0;
    }

    @Override
    public void func_75249_e() {
        super.func_75249_e();
    }

    @Override
    public void func_75246_d() {
        Path path;
        boolean isNearTarget;
        super.func_75246_d();
        --this.ticksRunning;
        BlockPos pathTarget = ((CreatureEntity)this.entity).func_70661_as().func_208485_j();
        boolean bl = isNearTarget = pathTarget != null && ((CreatureEntity)this.entity).func_70092_e((double)pathTarget.func_177958_n(), (double)pathTarget.func_177956_o(), (double)pathTarget.func_177952_p()) < 25.0;
        if ((((CreatureEntity)this.entity).func_70661_as().func_75500_f() || isNearTarget) && (path = this.findRunPosition()) != null) {
            ((CreatureEntity)this.entity).func_70661_as().func_75484_a(path, this.speed);
        }
    }

    @Nullable
    private Path findRunPosition() {
        for (int run = 0; run < 20; ++run) {
            Path path;
            boolean isWithinBounds;
            BlockPos pos = WyHelper.findValidGroundLocation((Entity)this.target, this.target.func_233580_cy_(), this.maxDistance, this.minDistance);
            boolean bl = isWithinBounds = WyHelper.isInChallengeDimension(((CreatureEntity)this.entity).field_70170_p) && AbilityHelper.isWithinChallengeArenaBounds(((CreatureEntity)this.entity).field_70170_p, pos);
            if (!isWithinBounds || pos.func_218141_a((Vector3i)this.target.func_233580_cy_(), (double)this.minDistance) || (path = ((CreatureEntity)this.entity).func_70661_as().func_179680_a(pos, 1)) == null || !path.func_224771_h()) continue;
            return path;
        }
        return null;
    }

    @Override
    public void func_75251_c() {
        super.func_75251_c();
        this.ticksRunning = this.defaultRunningTicks;
        this.restTicks = this.restBetweenRuns;
    }
}

