/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.Difficulty;
import xyz.pixelatedw.mineminenomi.entities.ThrowingWeaponEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.CooldownGoal;

public class KnifeThrowingGoal
extends CooldownGoal {
    private int amount = 1;
    private float speed = 1.0f;
    private double spread = 5.0;

    public KnifeThrowingGoal(OPEntity entity) {
        super(entity);
        this.setMaxCooldown(3.0);
    }

    public KnifeThrowingGoal setSpread(double spread) {
        this.spread = spread;
        return this;
    }

    public KnifeThrowingGoal setSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    public KnifeThrowingGoal setAmount(int amount) {
        this.amount = amount;
        return this;
    }

    @Override
    public boolean func_75250_a() {
        boolean hasTarget;
        if (!super.func_75250_a()) {
            return false;
        }
        boolean bl = hasTarget = this.entity.func_70638_az() != null;
        if (!hasTarget) {
            return false;
        }
        if (this.entity.func_70032_d((Entity)this.entity.func_70638_az()) < 3.0f) {
            return false;
        }
        return this.entity.func_70685_l((Entity)this.entity.func_70638_az());
    }

    public void func_75249_e() {
        LivingEntity target = this.entity.func_70638_az();
        if (target == null) {
            return;
        }
        float chanceForFull = 0.6f;
        if (this.entity.func_70032_d((Entity)target) < 10.0f) {
            double distance = this.entity.field_70170_p.func_175659_aa() == Difficulty.HARD ? 15.0 : 10.0;
            Vector3d dir = this.entity.func_213303_ch().func_178788_d(target.func_213303_ch()).func_72432_b().func_216372_d(distance, 0.0, distance).func_72441_c(0.0, this.entity.func_213322_ci().field_72448_b, 0.0);
            this.entity.func_213315_a(MoverType.SELF, dir);
        }
        if (this.entity.field_70170_p.func_175659_aa() == Difficulty.HARD) {
            this.speed += 0.5f;
            chanceForFull = 0.2f;
        }
        int finalAmount = 1;
        if (this.entity.func_70681_au().nextFloat() > chanceForFull) {
            finalAmount = this.amount;
        }
        int min = finalAmount / 2;
        int max = finalAmount / 2;
        float x = (float)(target.func_226277_ct_() - this.entity.func_226277_ct_());
        float z = (float)(target.func_226281_cx_() - this.entity.func_226281_cx_());
        float angle = (float)Math.toDegrees(Math.atan2(x, z));
        for (int i = -min; i <= max; ++i) {
            ThrowingWeaponEntity projectile = new ThrowingWeaponEntity(this.entity.field_70170_p, (LivingEntity)this.entity);
            projectile.func_70107_b(projectile.func_226277_ct_(), this.entity.func_226278_cu_() + (double)(this.entity.func_213302_cg() / 2.0f) + 1.0, projectile.func_226281_cx_());
            projectile.func_234612_a_((Entity)this.entity, this.entity.field_70125_A - 7.0f, (float)((double)(-angle) + (double)i * this.spread), 0.0f, this.speed, 0.0f);
            projectile.setThrower((LivingEntity)this.entity);
            this.entity.field_70170_p.func_217376_c((Entity)projectile);
        }
        this.setOnCooldown(true);
    }
}

