/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import xyz.pixelatedw.mineminenomi.abilities.StealthFootAbility;
import xyz.pixelatedw.mineminenomi.api.entities.GoalUtil;
import xyz.pixelatedw.mineminenomi.api.entities.ai.AbilityWrapperGoal;
import xyz.pixelatedw.mineminenomi.init.ModAbilityKeys;

public class StealthFootWrapperGoal
extends AbilityWrapperGoal<MobEntity, StealthFootAbility> {
    private LivingEntity target;
    private double minDistance = ((StealthFootAbility)this.getAbility()).getComponent(ModAbilityKeys.RANGE).map(comp -> Float.valueOf(comp.getRange())).orElse(Float.valueOf(10.0f)).floatValue();
    private double maxDistance = 20.0;

    public StealthFootWrapperGoal(MobEntity entity) {
        super(entity, StealthFootAbility.INSTANCE);
    }

    @Override
    public boolean canUseWrapper() {
        if (!GoalUtil.hasAliveTarget(this.entity)) {
            return false;
        }
        if (!GoalUtil.canMove((LivingEntity)this.entity)) {
            return false;
        }
        this.target = this.entity.func_70638_az();
        if (!GoalUtil.canSee(this.entity, this.target)) {
            return false;
        }
        if (GoalUtil.isWithinDistance((LivingEntity)this.entity, this.target, this.minDistance)) {
            return false;
        }
        return !GoalUtil.isOutsideDistance((LivingEntity)this.entity, this.target, this.maxDistance);
    }

    @Override
    public boolean canContinueToUseWrapper() {
        return true;
    }

    @Override
    public void startWrapper() {
        GoalUtil.lookAtEntity(this.entity, (Entity)this.target);
    }

    @Override
    public void tickWrapper() {
    }

    @Override
    public void stopWrapper() {
    }
}

